/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.util;

import com.azul.crs.client.Utils;
import com.azul.crs.util.logging.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import sun.net.www.protocol.jar.URLJarFile;

public class ZipTools {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final boolean DEBUG = Boolean.getBoolean("com.azul.crs.jarload.debug");
    private static final CentralDirectoryProviderFactory jdkCentarlDirectoryFactory = ((Supplier<CentralDirectoryProviderFactory>)() -> {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.8.")) {
            return new JDK8CentralDirectoryFactory();
        }
        return new JDKCentralDirectoryFactory();
    }).get();
    private static final CentralDirectoryProviderFactory genericCentralDirectoryProvider = ((Supplier<CentralDirectoryProviderFactory>)() -> {
        String string = System.getProperty("com.azul.crs.jarload.genericCentralDirectoryProvider");
        if ("generic".equals(string)) {
            return new GenericCentralDirectoryFactory();
        }
        if ("jdk".equals(string)) {
            return jdkCentarlDirectoryFactory;
        }
        if ("spring.1.x".equals(string)) {
            return new Spring1xCentralDirectoryFactory();
        }
        if ("spring.2.x".equals(string)) {
            return new Spring2xCentralDirectoryFactory();
        }
        return new GenericCentralDirectoryFactory();
    }).get();
    private static final boolean forceToUseGenericProvider = Boolean.getBoolean("com.azul.crs.jarload.forceToUseGenericProvider");
    private static final boolean allowAdvancedJarLoadDetection = Boolean.getBoolean("com.azul.crs.jarload.allowAdvancedJarLoadDetection");
    private static final Logger logger = Logger.getLogger(ZipTools.class);
    private MultiMap<String, CentralDirectoryProviderFactory> cdTools = new MultiMap();

    public ZipTools() {
        this.cdTools.put(JarFile.class.getName(), jdkCentarlDirectoryFactory);
        this.cdTools.put(URLJarFile.class.getName(), jdkCentarlDirectoryFactory);
        this.cdTools.put("org.springframework.boot.loader.jar.JarFile", new Spring1xCentralDirectoryFactory());
        this.cdTools.put("org.springframework.boot.loader.jar.JarFile", new Spring2xCentralDirectoryFactory());
        this.cdTools.put("org.springframework.boot.loader.jar.JarFileWrapper", new Spring26xCentralDirectoryFactory());
    }

    public byte[] getManifestHash(MessageDigest messageDigest, URL uRL, JarFile jarFile) {
        byte[] byArray = null;
        try {
            int n;
            InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/MANIFEST.MF"));
            char[] cArray = new char[8192];
            StringBuilder stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            messageDigest.reset();
            byArray = messageDigest.digest(stringBuilder.toString().getBytes());
        }
        catch (Exception exception) {
            logger.trace("ZipTools.getDigest failed to get manifest for file=%s", jarFile, exception);
        }
        return byArray;
    }

    public JarShortDigest getDigest(MessageDigest messageDigest, URL uRL, JarFile jarFile) {
        AtomicLong atomicLong;
        byte[] byArray2;
        CentralDirectoryProviderFactory centralDirectoryProviderFactory;
        block10: {
            if (messageDigest == null) {
                return null;
            }
            centralDirectoryProviderFactory = null;
            Class<?> clazz = jarFile.getClass();
            if (!allowAdvancedJarLoadDetection) {
                if (clazz.equals(JarFile.class) || clazz.equals(URLJarFile.class)) {
                    messageDigest.reset();
                    AtomicLong atomicLong2 = new AtomicLong(0L);
                    try {
                        jdkCentarlDirectoryFactory.getCentralDirectoryProvider(uRL, jarFile).deliver((byArray, n, n2) -> {
                            messageDigest.update(byArray, n, n2);
                            atomicLong2.getAndAdd(n2);
                        });
                    }
                    catch (Exception exception) {
                        logger.error("Failed to calculate central directory hash code for ulr=%s, file=%s", uRL, jarFile, exception);
                    }
                    byte[] byArray3 = this.getManifestHash(messageDigest, uRL, jarFile);
                    return new JarShortDigest(messageDigest.digest(), byArray3, jdkCentarlDirectoryFactory.getClass().getName(), atomicLong2.get());
                }
                logger.debug("Unsupported jarFile type %s skip notification for %s", jarFile.getClass().getName(), uRL.toString());
                return null;
            }
            if (!forceToUseGenericProvider) {
                do {
                    if ((centralDirectoryProviderFactory = this.cdTools.get(clazz.getName())) != null) continue;
                    clazz = clazz.getSuperclass();
                } while (!JarFile.class.equals(clazz) && !URLJarFile.class.equals(clazz) && centralDirectoryProviderFactory == null && !clazz.equals(Object.class));
            }
            if (centralDirectoryProviderFactory == null) {
                centralDirectoryProviderFactory = genericCentralDirectoryProvider;
            }
            logger.trace("zip tools calculating sha256 of central directory: digest=" + messageDigest + ", url=" + uRL + ", file=" + jarFile + ", file.class=" + jarFile.getClass().getName() + ", ze=" + centralDirectoryProviderFactory.getClass().getName(), new Object[0]);
            byArray2 = null;
            atomicLong = new AtomicLong(0L);
            try {
                messageDigest.reset();
                centralDirectoryProviderFactory.getCentralDirectoryProvider(uRL, jarFile).deliver((byArray, n, n2) -> {
                    messageDigest.update(byArray, n, n2);
                    atomicLong.getAndAdd(n2);
                    if (DEBUG) {
                        System.out.println(">>> += JarLoadMonitor.encodeToStringOrNull(" + byArray.length + ", " + n + ", " + n2 + ");");
                        System.out.println(">>> +=" + Utils.encodeToStringOrNull(byArray, n, n2));
                    }
                });
                byArray2 = messageDigest.digest();
            }
            catch (Exception exception) {
                logger.trace("(not good, not bad): calculating central directory sha256 ended with exception: url=%s, file=%s, zip-cd provider=%s", uRL, jarFile, centralDirectoryProviderFactory.getClass().getName(), centralDirectoryProviderFactory, exception);
                if (jdkCentarlDirectoryFactory.getClass().isInstance(centralDirectoryProviderFactory) || genericCentralDirectoryProvider.getClass().isInstance(centralDirectoryProviderFactory)) break block10;
                this.cdTools.remove(clazz.getName(), centralDirectoryProviderFactory);
                return this.getDigest(messageDigest, uRL, jarFile);
            }
        }
        byte[] byArray4 = this.getManifestHash(messageDigest, uRL, jarFile);
        return new JarShortDigest(byArray2, byArray4, centralDirectoryProviderFactory.getClass().getName(), atomicLong.get());
    }

    public static class JarShortDigest {
        public byte[] centralDirectoryHash;
        public byte[] manifestHash;
        public String provider;
        public long centralDirectoryLength;

        JarShortDigest(byte[] byArray, byte[] byArray2, String string, long l) {
            this.centralDirectoryHash = byArray;
            this.manifestHash = byArray2;
            this.provider = string;
            this.centralDirectoryLength = l;
        }

        public byte[] getCentralDirectoryHash() {
            return this.centralDirectoryHash;
        }

        public byte[] getManifestHash() {
            return this.manifestHash;
        }

        public String getProvider() {
            return this.provider;
        }

        public long getCentralDirectoryLength() {
            return this.centralDirectoryLength;
        }
    }

    public static class Spring1xCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        Class jarFile;
        Field data;
        Class randomAccessData;
        Class resourceAccess;
        Object resourceAccessOnce;
        Method getInputStream;
        Class centralDirectoryEndRecord;
        Field centralDirectoryEndRecordBlock;
        Field centralDirectoryEndRecordBlockOffset;
        Field centralDirectoryEndRecordBlockLength;
        Method getCentralDirectory;
        Constructor<Object> newCentralDirectoryEndRecord;

        private void lazyInit(ClassLoader classLoader) throws Exception {
            if (this.initialized) {
                return;
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            this.jarFile = Class.forName("org.springframework.boot.loader.jar.JarFile", true, classLoader);
            this.data = this.jarFile.getDeclaredField("data");
            this.data.setAccessible(true);
            this.randomAccessData = this.data.getType();
            this.resourceAccess = Class.forName("org.springframework.boot.loader.data.RandomAccessData$ResourceAccess", true, classLoader);
            for (Object t : this.resourceAccess.getEnumConstants()) {
                if (!"ONCE".equals(t.toString())) continue;
                this.resourceAccessOnce = t;
            }
            this.getInputStream = this.randomAccessData.getDeclaredMethod("getInputStream", this.resourceAccess);
            this.getInputStream.setAccessible(true);
            this.centralDirectoryEndRecord = Class.forName("org.springframework.boot.loader.jar.CentralDirectoryEndRecord", true, classLoader);
            this.centralDirectoryEndRecordBlock = this.centralDirectoryEndRecord.getDeclaredField("block");
            this.centralDirectoryEndRecordBlock.setAccessible(true);
            Class<?> clazz = this.centralDirectoryEndRecordBlock.getType();
            if (!clazz.equals(byte[].class)) {
                throw new RuntimeException("CentralDirectoryEndRecord.block is not of byte[] type, as expected ==" + clazz.getName());
            }
            this.centralDirectoryEndRecordBlockOffset = this.centralDirectoryEndRecord.getDeclaredField("offset");
            this.centralDirectoryEndRecordBlockOffset.setAccessible(true);
            if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockOffset.getType())) {
                throw new RuntimeException("CentralDirectoryEndRecord.offset is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockOffset.getType());
            }
            this.centralDirectoryEndRecordBlockLength = this.centralDirectoryEndRecord.getDeclaredField("size");
            this.centralDirectoryEndRecordBlockLength.setAccessible(true);
            if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockLength.getType())) {
                throw new RuntimeException("CentralDirectoryEndRecord.size is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockLength.getType());
            }
            this.getCentralDirectory = this.centralDirectoryEndRecord.getDeclaredMethod("getCentralDirectory", this.randomAccessData);
            this.getCentralDirectory.setAccessible(true);
            this.newCentralDirectoryEndRecord = this.centralDirectoryEndRecord.getDeclaredConstructor(this.randomAccessData);
            this.newCentralDirectoryEndRecord.setAccessible(true);
            this.initialized = true;
        }

        private void check(ZipFile zipFile) throws Exception {
            if (!zipFile.getClass().equals(this.jarFile)) {
                throw new RuntimeException("Wrong extractor chosen");
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, final ZipFile zipFile) throws Exception {
            this.lazyInit(zipFile.getClass().getClassLoader());
            this.check(zipFile);
            return new DataProvider(){

                @Override
                public void deliver(DataConsumer dataConsumer) throws Exception {
                    int n;
                    Object object = data.get(zipFile);
                    Object object2 = newCentralDirectoryEndRecord.newInstance(object);
                    Object object3 = getCentralDirectory.invoke(object2, object);
                    byte[] byArray = (byte[])centralDirectoryEndRecordBlock.get(object2);
                    int n2 = (Integer)centralDirectoryEndRecordBlockOffset.get(object2);
                    int n3 = (Integer)centralDirectoryEndRecordBlockLength.get(object2);
                    InputStream inputStream = (InputStream)getInputStream.invoke(object3, resourceAccessOnce);
                    byte[] byArray2 = new byte[8192];
                    while ((n = inputStream.read(byArray2)) > 0) {
                        dataConsumer.consume(byArray2, 0, n);
                    }
                    dataConsumer.consume(byArray, n2, n3);
                    inputStream.close();
                }
            };
        }
    }

    public static class Spring26xCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        private Field parent;
        private Class jarFileWrapper;
        private Class jarFile;
        private Spring2xCentralDirectoryFactory delegate;

        private synchronized void lazyInit(ClassLoader classLoader) throws Exception {
            if (this.initialized) {
                return;
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            this.jarFile = Class.forName("org.springframework.boot.loader.jar.JarFile", true, classLoader);
            this.jarFileWrapper = Class.forName("org.springframework.boot.loader.jar.JarFileWrapper", true, classLoader);
            this.parent = this.jarFileWrapper.getDeclaredField("parent");
            this.delegate = new Spring2xCentralDirectoryFactory();
            this.parent.setAccessible(true);
            if (!this.jarFile.equals(this.parent.getType())) {
                throw new RuntimeException("Field 'parent' expecting to have type " + this.jarFile.getName() + ", but has " + this.parent.getType());
            }
            this.initialized = true;
        }

        private void check(ZipFile zipFile) throws Exception {
            if (!zipFile.getClass().equals(this.jarFileWrapper)) {
                throw new RuntimeException("Wrong extractor chosen");
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, ZipFile zipFile) throws Exception {
            this.lazyInit(zipFile.getClass().getClassLoader());
            this.check(zipFile);
            Object object = this.parent.get(zipFile);
            return this.delegate.getCentralDirectoryProvider(uRL, (ZipFile)object);
        }
    }

    public static class Spring2xCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        Class jarFile;
        Field data;
        Class randomAccessData;
        Method read;
        Method getSize;
        Class centralDirectoryEndRecord;
        Field centralDirectoryEndRecordBlock;
        Field centralDirectoryEndRecordBlockOffset;
        Field centralDirectoryEndRecordBlockLength;
        Method getCentralDirectory;
        Constructor<Object> newCentralDirectoryEndRecord;

        private synchronized void lazyInit(ClassLoader classLoader) throws Exception {
            if (this.initialized) {
                return;
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            this.jarFile = Class.forName("org.springframework.boot.loader.jar.JarFile", true, classLoader);
            this.data = this.jarFile.getDeclaredField("data");
            this.data.setAccessible(true);
            this.randomAccessData = this.data.getType();
            this.read = this.randomAccessData.getDeclaredMethod("read", new Class[0]);
            this.read.setAccessible(true);
            this.getSize = this.randomAccessData.getDeclaredMethod("getSize", null);
            this.getSize.setAccessible(true);
            this.centralDirectoryEndRecord = Class.forName("org.springframework.boot.loader.jar.CentralDirectoryEndRecord", true, classLoader);
            this.centralDirectoryEndRecordBlock = this.centralDirectoryEndRecord.getDeclaredField("block");
            this.centralDirectoryEndRecordBlock.setAccessible(true);
            Class<?> clazz = this.centralDirectoryEndRecordBlock.getType();
            if (!clazz.equals(byte[].class)) {
                throw new RuntimeException("CentralDirectoryEndRecord.block is not of byte[] type, as expected ==" + clazz.getName());
            }
            this.centralDirectoryEndRecordBlockOffset = this.centralDirectoryEndRecord.getDeclaredField("offset");
            this.centralDirectoryEndRecordBlockOffset.setAccessible(true);
            if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockOffset.getType())) {
                throw new RuntimeException("CentralDirectoryEndRecord.offset is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockOffset.getType());
            }
            this.centralDirectoryEndRecordBlockLength = this.centralDirectoryEndRecord.getDeclaredField("size");
            this.centralDirectoryEndRecordBlockLength.setAccessible(true);
            if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockLength.getType())) {
                throw new RuntimeException("CentralDirectoryEndRecord.size is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockLength.getType());
            }
            this.getCentralDirectory = this.centralDirectoryEndRecord.getDeclaredMethod("getCentralDirectory", this.randomAccessData);
            this.getCentralDirectory.setAccessible(true);
            this.newCentralDirectoryEndRecord = this.centralDirectoryEndRecord.getDeclaredConstructor(this.randomAccessData);
            this.newCentralDirectoryEndRecord.setAccessible(true);
            this.initialized = true;
        }

        private void check(ZipFile zipFile) throws Exception {
            if (!zipFile.getClass().equals(this.jarFile)) {
                throw new RuntimeException("Wrong extractor chosen");
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, final ZipFile zipFile) throws Exception {
            this.lazyInit(zipFile.getClass().getClassLoader());
            this.check(zipFile);
            return new DataProvider(){

                @Override
                public void deliver(DataConsumer dataConsumer) throws Exception {
                    Object object = data.get(zipFile);
                    Object object2 = newCentralDirectoryEndRecord.newInstance(object);
                    Object object3 = getCentralDirectory.invoke(object2, object);
                    byte[] byArray = (byte[])read.invoke(object3, new Object[0]);
                    byte[] byArray2 = (byte[])centralDirectoryEndRecordBlock.get(object2);
                    int n = (Integer)centralDirectoryEndRecordBlockOffset.get(object2);
                    int n2 = (Integer)centralDirectoryEndRecordBlockLength.get(object2);
                    dataConsumer.consume(byArray);
                    dataConsumer.consume(byArray2, n, n2);
                }
            };
        }
    }

    public static class GenericCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        @Override
        public DataProvider getCentralDirectoryProvider(final URL uRL, final ZipFile zipFile) throws Exception {
            return new DataProvider(){

                @Override
                public void deliver(DataConsumer dataConsumer) throws Exception {
                    try (InputStream inputStream = uRL.openConnection().getInputStream();){
                        long l;
                        ZipInputStreamCentralDirectoryParser zipInputStreamCentralDirectoryParser = new ZipInputStreamCentralDirectoryParser(inputStream);
                        zipInputStreamCentralDirectoryParser.deliver(dataConsumer);
                        if (DEBUG && zipInputStreamCentralDirectoryParser.endtot != (l = (long)Collections.list(zipFile.entries()).size())) {
                            throw new RuntimeException("ERROR: the file=" + zipFile + ":" + zipFile.getClass().getName() + ", contains " + l + " number of entries, but we calculated the number as " + zipInputStreamCentralDirectoryParser.endtot + ".");
                        }
                    }
                    catch (Exception exception) {
                        logger.trace("GenericCentralDirectoryFactory got exception", exception);
                    }
                }
            };
        }

        private static class ZipInputStreamCentralDirectoryParser
        implements DataProvider {
            private RandomAccessBuffer buffer;
            public long endpos;
            public long endtot;
            public long endsiz;
            public long endoff;
            public long endcom;
            public long cenpos;
            public long locpos;
            static final int ENDTOT = 10;
            static final int ENDSIZ = 12;
            static final int ENDOFF = 16;
            static final int ENDCOM = 20;
            static final long LOCSIG = 67324752L;
            static final long CENSIG = 33639248L;
            static final long ENDSIG = 101010256L;
            static final int ENDHDR = 22;
            static final long ZIP64_MAGICVAL = 0xFFFFFFFFL;
            static final int ZIP64_LOCHDR = 20;
            static final long ZIP64_LOCSIG = 117853008L;
            static final int ZIP64_LOCOFF = 8;
            static final long ZIP64_ENDSIG = 101075792L;
            static final int ZIP64_ENDOFF = 48;
            static final int ZIP64_ENDTOT = 32;
            static final int ZIP64_MAGICCOUNT = 65535;
            static final int ZIP64_ENDSIZ = 40;

            ZipInputStreamCentralDirectoryParser(InputStream inputStream) {
                this.buffer = new RandomAccessBuffer(inputStream);
            }

            private void readCentralDirectory(DataConsumer dataConsumer) throws Exception {
                long l = -1L;
                this.buffer.readNextPage();
                int n = 0;
                while (!this.buffer.meetEOF() && (long)n >= this.buffer.getStart() && (long)(n + 4) < this.buffer.getEnd()) {
                    if (this.buffer.get32(n) == 67324752L) {
                        l = n;
                    }
                    ++n;
                }
                this.buffer.readUntilEOF();
                for (long i = this.buffer.getEnd() - 22L; i > this.buffer.getStart(); --i) {
                    long l2;
                    if (this.buffer.get32(i) != 101010256L) continue;
                    long l3 = i;
                    long l4 = this.buffer.get16(l3 + 10L);
                    long l5 = this.buffer.get32(l3 + 12L);
                    long l6 = this.buffer.get32(l3 + 16L);
                    long l7 = this.buffer.get16(l3 + 20L);
                    long l8 = l3 - l5;
                    long l9 = l8 - l6;
                    if (l3 + 22L + l7 != this.buffer.getEnd() && (l8 < 0L || l9 < 0L || l != -1L && l9 != l || this.buffer.get32(l8) != 33639248L)) continue;
                    if (l3 >= 20L && this.buffer.get32(l3 - 20L) == 117853008L && this.buffer.get32(l2 = this.buffer.get64(l3 - 20L + 8L)) == 101075792L) {
                        long l10 = this.buffer.get64(l2 + 40L);
                        long l11 = this.buffer.get64(l2 + 48L);
                        long l12 = this.buffer.get64(l2 + 32L);
                        if (!(l10 != l5 && l5 != 0xFFFFFFFFL || l11 != l6 && l6 != 0xFFFFFFFFL || l12 != l4 && l4 != 65535L)) {
                            l5 = l10;
                            l6 = l11;
                            l4 = l12;
                            l3 = l2;
                            l8 = l3 - l5;
                            l9 = l8 - l6;
                        }
                    }
                    if (DEBUG) {
                        this.endpos = l3;
                        this.endtot = l4;
                        this.endsiz = l5;
                        this.endoff = l6;
                        this.endcom = l7;
                        this.cenpos = l8;
                        this.locpos = l9;
                    }
                    this.buffer.deliver(dataConsumer, l8, l3 + 22L - l8);
                    return;
                }
            }

            @Override
            public void deliver(DataConsumer dataConsumer) throws Exception {
                this.readCentralDirectory(dataConsumer);
            }

            private static class RandomAccessBuffer {
                private final int maxChunks = 100;
                private Queue<Chunk> queue;
                private Chunk[] chunks;
                private InputStream stream;
                private boolean eof;
                private long dataStartOffset;
                private long dataEndOffset;

                private void renumerate() {
                    int n = 0;
                    for (Chunk chunk : this.queue) {
                        this.chunks[n++] = chunk;
                    }
                }

                private Chunk getFreeChunk() {
                    Chunk chunk = null;
                    if (this.queue.size() < 100) {
                        chunk = new Chunk();
                        this.queue.add(chunk);
                        return chunk;
                    }
                    chunk = this.queue.remove();
                    if (chunk.buf.length != chunk.filled) {
                        throw new RuntimeException("!");
                    }
                    this.dataStartOffset += (long)chunk.filled;
                    chunk.clear();
                    this.queue.add(chunk);
                    this.renumerate();
                    return chunk;
                }

                public RandomAccessBuffer(InputStream inputStream) {
                    this.stream = inputStream;
                    this.eof = false;
                    this.dataEndOffset = 0L;
                    this.dataStartOffset = 0L;
                    this.queue = new LinkedList<Chunk>();
                    this.chunks = new Chunk[100];
                }

                public void deliver(DataConsumer dataConsumer, long l, long l2) throws Exception {
                    if (l < this.dataStartOffset || l + l2 > this.dataEndOffset) {
                        throw new RuntimeException("off=" + l + ", len=" + l2 + " are out of range [" + this.dataStartOffset + "," + this.dataEndOffset + "]");
                    }
                    int n = this.getChunkNumber(l);
                    int n2 = this.getOffsetInsideChunk(l);
                    int n3 = this.getChunkNumber(l + l2);
                    int n4 = this.getOffsetInsideChunk(l + l2);
                    if (n == n3) {
                        if (n4 < n2) {
                            throw new RuntimeException("lastOffset=" + n4 + " < firstOffset=" + n2);
                        }
                        dataConsumer.consume(this.chunks[n].buf, n2, n4 - n2);
                    } else {
                        dataConsumer.consume(this.chunks[n].buf, n2, 8192 - n2);
                        for (int i = n + 1; i < n3; ++i) {
                            dataConsumer.consume(this.chunks[i].buf, 0, 8192);
                        }
                        dataConsumer.consume(this.chunks[n3].buf, 0, n4);
                    }
                }

                public boolean meetEOF() {
                    return !this.eof;
                }

                public long getStart() {
                    return this.dataStartOffset;
                }

                public long getEnd() {
                    return this.dataEndOffset;
                }

                public boolean readNextPage() throws Exception {
                    if (this.eof) {
                        return false;
                    }
                    Chunk chunk = this.getFreeChunk();
                    long l = -1L;
                    while (chunk.buf.length - chunk.filled > 0 && (l = (long)this.stream.read(chunk.buf, chunk.filled, chunk.buf.length - chunk.filled)) != -1L) {
                        chunk.filled = (int)((long)chunk.filled + l);
                        this.dataEndOffset += l;
                    }
                    this.renumerate();
                    if (l == -1L) {
                        this.eof = true;
                    }
                    return !this.eof;
                }

                public void readUntilEOF() throws Exception {
                    while (this.readNextPage()) {
                    }
                }

                private int getChunkNumber(long l) {
                    if (l > this.dataEndOffset || l < this.dataStartOffset) {
                        throw new RuntimeException("i is not in range: i=" + l + " range=[" + this.dataStartOffset + "," + this.dataEndOffset + "]");
                    }
                    return (int)((l - this.dataStartOffset) / 8192L);
                }

                private int getOffsetInsideChunk(long l) {
                    if (l > this.dataEndOffset || l < this.dataStartOffset) {
                        throw new RuntimeException("i is not in range: i=" + l + " range=[" + this.dataStartOffset + "," + this.dataEndOffset + "]");
                    }
                    return (int)(l % 8192L);
                }

                public byte get8(long l) {
                    if (l < this.dataStartOffset || l >= this.dataEndOffset) {
                        throw new RuntimeException("RandomAccessBuffer out of index access off=" + l + ", expecting range: [" + this.dataStartOffset + "," + this.dataEndOffset + ")");
                    }
                    return this.chunks[this.getChunkNumber((long)l)].buf[this.getOffsetInsideChunk(l)];
                }

                public int get16(long l) {
                    return this.get8(l) & 0xFF | (this.get8(l + 1L) & 0xFF) << 8;
                }

                public long get32(long l) {
                    return ((long)this.get16(l) | (long)this.get16(l + 2L) << 16) & 0xFFFFFFFFL;
                }

                public long get64(long l) {
                    return this.get32(l) | this.get32(l + 4L) << 32;
                }

                private static class Chunk {
                    public byte[] buf = new byte[8192];
                    public int filled = 0;

                    Chunk() {
                    }

                    public void clear() {
                        this.filled = 0;
                    }
                }
            }
        }
    }

    public static class JDK8CentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        private Method getCentralDirectory;

        private synchronized void lazyInit() throws Exception {
            if (this.initialized) {
                return;
            }
            this.getCentralDirectory = ZipFile.class.getDeclaredMethod("getCentralDirectory", new Class[0]);
            this.getCentralDirectory.setAccessible(true);
            this.initialized = true;
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, final ZipFile zipFile) throws Exception {
            this.lazyInit();
            return new DataProvider(){

                @Override
                public void deliver(DataConsumer dataConsumer) throws Exception {
                    byte[] byArray = (byte[])getCentralDirectory.invoke((Object)zipFile, new Object[0]);
                    dataConsumer.consume(byArray);
                }
            };
        }
    }

    public static class JDKCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        private Field res;
        private Class cleanableResource;
        private Field zsrc;
        private Class source;
        private Field cen;

        private synchronized void lazyInit() throws Exception {
            if (this.initialized) {
                return;
            }
            this.res = ZipFile.class.getDeclaredField("res");
            this.res.setAccessible(true);
            this.cleanableResource = this.res.getType();
            this.zsrc = this.cleanableResource.getDeclaredField("zsrc");
            this.zsrc.setAccessible(true);
            this.source = this.zsrc.getType();
            this.cen = this.source.getDeclaredField("cen");
            this.cen.setAccessible(true);
            this.initialized = true;
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, final ZipFile zipFile) throws Exception {
            this.lazyInit();
            return new DataProvider(){

                @Override
                public void deliver(DataConsumer dataConsumer) throws Exception {
                    Object object = res.get(zipFile);
                    Object object2 = zsrc.get(object);
                    byte[] byArray = (byte[])cen.get(object2);
                    dataConsumer.consume(byArray);
                }
            };
        }
    }

    public static interface CentralDirectoryProviderFactory {
        public DataProvider getCentralDirectoryProvider(URL var1, ZipFile var2) throws Exception;
    }

    public static interface DataProvider {
        public void deliver(DataConsumer var1) throws Exception;
    }

    public static interface DataConsumer {
        public void consume(byte[] var1, int var2, int var3) throws Exception;

        default public void consume(byte[] byArray) throws Exception {
            this.consume(byArray, 0, byArray.length);
        }
    }

    private class MultiMap<K, V> {
        Map<K, List<V>> map = new HashMap<K, List<V>>();

        MultiMap() {
        }

        void put(K k, V v) {
            List<V> list = this.map.get(k);
            if (list == null) {
                list = new ArrayList<V>();
                this.map.put(k, list);
            }
            list.add(v);
        }

        V get(K k) {
            List<V> list = this.map.get(k);
            if (list == null) {
                return null;
            }
            return list.size() > 0 ? (V)list.get(0) : null;
        }

        void remove(K k, V v) {
            if (!this.map.containsKey(k)) {
                return;
            }
            List<V> list = this.map.get(k);
            if (!list.contains(v)) {
                return;
            }
            list.remove(v);
        }
    }
}

