/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.JarLoadMonitor;
import com.azul.crs.util.logging.Logger;
import com.azul.tooling.ConsumerManager;
import com.azul.tooling.JarLoadEventModel;
import com.azul.tooling.in.Tooling;

public class VMToolingClient
implements ClientService,
ConsumerManager.Consumer {
    private static final int POLL_TIMEOUT = 3000;
    private static final int WATERMARK_THRESHOLD = 50;
    private static VMToolingClient instance = new VMToolingClient();
    private Client client;
    private volatile boolean running;
    private Thread thread;
    private volatile long deadline;
    private ConsumerManager consumerManager;
    private JarLoadMonitor jarLoadMonitor;

    public static boolean isToolingImplemented() {
        return Tooling.isImplemented();
    }

    private VMToolingClient() {
    }

    public void setJarLoadMonitor(JarLoadMonitor jarLoadMonitor) {
        this.jarLoadMonitor = jarLoadMonitor;
    }

    public void notifyEvent(Object object) {
        if (object instanceof JarLoadEventModel) {
            JarLoadEventModel jarLoadEventModel = (JarLoadEventModel)object;
            if (this.jarLoadMonitor != null) {
                this.jarLoadMonitor.notifyJarLoad(jarLoadEventModel.getURL(), jarLoadEventModel.getJarFile());
            }
            return;
        }
        this.client.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ANY_CONNECTION).eventPayload(object).eventTime(Utils.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWatermarkReached() {
        VMToolingClient vMToolingClient = this;
        synchronized (vMToolingClient) {
            this.notify();
        }
    }

    public static VMToolingClient getInstance(Client client) {
        VMToolingClient.instance.client = client;
        return instance;
    }

    @Override
    public void start() {
        if (VMToolingClient.isToolingImplemented()) {
            this.consumerManager = ConsumerManager.registerConsumer((ConsumerManager.Consumer)this);
        }
        final Logger logger = Logger.getLogger(VMToolingClient.class);
        if (this.consumerManager == null) {
            logger.error("cannot register with VM", new Object[0]);
            return;
        }
        this.consumerManager.setNotificationWatermark(50);
        this.running = true;
        logger.debug("registered with VM", new Object[0]);
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (VMToolingClient.this.running) {
                        VMToolingClient vMToolingClient = VMToolingClient.this;
                        synchronized (vMToolingClient) {
                            try {
                                VMToolingClient.this.wait(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (!VMToolingClient.this.running && System.currentTimeMillis() >= VMToolingClient.this.deadline) break;
                        VMToolingClient.this.consumerManager.drain();
                    }
                    VMToolingClient.this.consumerManager.unregisterConsumer();
                }
                catch (Throwable throwable) {
                    logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.setName("CRSVMTooling");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long l) {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.deadline = l - 1L;
        Logger.getLogger(VMToolingClient.class).debug("unregistered with VM", new Object[0]);
        VMToolingClient vMToolingClient = this;
        synchronized (vMToolingClient) {
            this.notify();
        }
        try {
            this.thread.join(l - System.currentTimeMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

