/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Utils;
import com.azul.crs.client.service.ClientService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class QueueService<T>
implements ClientService {
    private static final int DEFAULT_MAX_QUEUE_SIZE = 5000;
    private static final int DEFAULT_MAX_WORKERS = 3;
    private static final int DEFAULT_MAX_BATCH_SIZE = 1000;
    private static final long DEFAULT_ADD_TIMEOUT = 500L;
    private volatile boolean stopping;
    private volatile boolean cancelled;
    private final BlockingQueue<T> queue;
    private final List<Thread> workerThreads;
    private final List<Worker> workers;
    private final int maxQueueSize;
    private final int maxWorkers;
    private final int maxBatchSize;
    private final long addTimeout;
    private final ProcessBatch<T> processBatch;
    private final String name;
    private final Object syncOrderMonitor = new Object();
    private final Object syncFinishNotifier = new Object();
    private final T syncMarker;
    private final AtomicInteger syncCount = new AtomicInteger(0);

    private QueueService(int n, int n2, int n3, long l, T t, ProcessBatch<T> processBatch, String string) {
        this.maxQueueSize = n;
        this.maxWorkers = n2;
        this.maxBatchSize = n3;
        this.addTimeout = l;
        this.syncMarker = t;
        this.processBatch = processBatch;
        this.queue = new LinkedBlockingDeque<T>(n);
        this.workerThreads = new LinkedList<Thread>();
        this.workers = new LinkedList<Worker>();
        this.name = string;
    }

    public void add(T t) {
        block3: {
            if (this.cancelled || this.stopping) {
                return;
            }
            try {
                this.queue.offer(t, this.addTimeout, TimeUnit.MILLISECONDS);
                PerformanceMetrics.logEventQueueLength(this.queue.size());
            }
            catch (InterruptedException interruptedException) {
                if (Client.isVMShutdownInitiated()) break block3;
                this.logger().error("Queue failed to enqueue item: queueSize=" + this.queue.size() + ", maxQueueSize=" + this.maxQueueSize + ", timeout=" + this.addTimeout + ", item=" + t, new Object[0]);
            }
        }
    }

    public void addAll(Collection<T> collection) {
        block4: {
            if (this.stopping) {
                return;
            }
            try {
                for (T t : collection) {
                    this.queue.offer(t, this.addTimeout, TimeUnit.MILLISECONDS);
                }
                PerformanceMetrics.logEventQueueLength(this.queue.size());
            }
            catch (InterruptedException interruptedException) {
                if (Client.isVMShutdownInitiated()) break block4;
                this.logger().error("Queue failed to enqueue item: queueSize=" + this.queue.size() + ", maxQueueSize=" + this.maxQueueSize + ", timeout=" + this.addTimeout + ", number of items=" + collection.size(), new Object[0]);
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.stopping || this.cancelled) {
            throw new IllegalStateException(this.serviceName() + " is stopping or cancelled");
        }
        for (int i = 0; i < this.maxWorkers; ++i) {
            Worker worker = new Worker(String.valueOf(i));
            Thread thread = new Thread(worker);
            this.workerThreads.add(thread);
            this.workers.add(worker);
            thread.setDaemon(true);
            thread.setName("CRSQW-" + this.name + i);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(long l) {
        if (this.cancelled) {
            return;
        }
        if (Utils.elapsedTimeMillis(l) >= 0L) {
            this.logger().debug("%s sync missed deadline", this.name);
            return;
        }
        Object object = this.syncOrderMonitor;
        synchronized (object) {
            boolean bl = false;
            this.syncCount.set(this.maxWorkers);
            Object object2 = this.syncFinishNotifier;
            synchronized (object2) {
                this.logger().trace("%s sync start", this.name);
                while (!(bl = this.queue.offer(this.syncMarker)) && Utils.currentTimeCount() < l) {
                    Utils.sleep(10L);
                }
                if (bl) {
                    try {
                        long l2 = -Utils.elapsedTimeMillis(l);
                        if (l2 > 0L) {
                            this.syncFinishNotifier.wait(l2);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.syncCount.get() > 0) {
                        this.logger().warning("%s sync timeout waiting response. %d workers not finished", this.name, this.syncCount.get());
                        this.syncFinishNotifier.notifyAll();
                    }
                } else {
                    this.logger().warning("%s sync timeout waiting to initiate queue sync", this.name);
                }
            }
        }
    }

    @Override
    public void stop(long l) {
        if (this.stopping) {
            return;
        }
        this.stopping = true;
        this.sync(l);
    }

    public void cancel() {
        this.cancelled = true;
    }

    protected class Worker
    implements Runnable {
        private final String workerId;

        public Worker(String string) {
            this.workerId = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sync() {
            try {
                Object object = QueueService.this.syncFinishNotifier;
                synchronized (object) {
                    if (QueueService.this.syncCount.decrementAndGet() > 0) {
                        while (!QueueService.this.queue.offer(QueueService.this.syncMarker)) {
                            Thread.sleep(10L);
                        }
                        QueueService.this.syncFinishNotifier.wait();
                    } else {
                        QueueService.this.syncFinishNotifier.notifyAll();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            try {
                ArrayList arrayList = new ArrayList(QueueService.this.maxBatchSize);
                boolean bl = true;
                while (bl) {
                    Object e;
                    int n = 0;
                    try {
                        e = QueueService.this.queue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    if (e != QueueService.this.syncMarker) {
                        arrayList.add(e);
                        ++n;
                        while (n < QueueService.this.maxBatchSize && (e = QueueService.this.queue.poll()) != QueueService.this.syncMarker && e != null) {
                            arrayList.add(e);
                            ++n;
                        }
                        try {
                            QueueService.this.processBatch.process(this.workerId, arrayList);
                        }
                        catch (Throwable throwable) {
                            QueueService.this.logger().error("Internal processing error: %s", throwable);
                        }
                        arrayList.clear();
                    }
                    if (e != QueueService.this.syncMarker) continue;
                    this.sync();
                    bl = !QueueService.this.stopping;
                }
            }
            catch (Throwable throwable) {
                QueueService.this.logger().error("Internal error or unexpected problem. CRS defunct. %s", throwable);
            }
        }
    }

    public static class Builder<T> {
        private int maxQueueSize = 5000;
        private int maxWorkers = 3;
        private int maxBatchSize = 1000;
        private long addTimeout = 500L;
        private ProcessBatch<T> processBatch;
        private T stopMarker;
        private String name = "<unnamed>";

        public Builder<T> maxQueueSize(int n) {
            this.maxQueueSize = n;
            return this;
        }

        public Builder<T> maxWorkers(int n) {
            this.maxWorkers = n;
            return this;
        }

        public Builder<T> maxBatchSize(int n) {
            this.maxBatchSize = n;
            return this;
        }

        public Builder<T> addTimeout(long l) {
            this.addTimeout = l;
            return this;
        }

        public Builder<T> processBatch(ProcessBatch<T> processBatch) {
            this.processBatch = processBatch;
            return this;
        }

        public Builder<T> stopMarker(T t) {
            this.stopMarker = t;
            return this;
        }

        public Builder<T> name(String string) {
            this.name = string;
            return this;
        }

        private void notNull(Object object) {
            object.getClass();
        }

        QueueService<T> build() {
            this.notNull(this.processBatch);
            this.notNull(this.stopMarker);
            return new QueueService(this.maxQueueSize, this.maxWorkers, this.maxBatchSize, this.addTimeout, this.stopMarker, this.processBatch, this.name);
        }
    }

    public static interface ProcessBatch<T> {
        public void process(String var1, Collection<T> var2);
    }
}

