/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.util.ZipTools;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class JarLoadMonitor
implements ClientService {
    private static final boolean DEBUG = Boolean.getBoolean("com.azul.crs.jarload.debug");
    private static final boolean jarLoadByClassLoad = Boolean.getBoolean("com.azul.crs.jarload.jarLoadByClassLoad");
    private static final boolean sendCentralDirectoryHash = Boolean.getBoolean("com.azul.crs.jarload.sendCentralDirectoryHashOnJarLoad");
    private static final boolean sendJarEntriesHashes = Boolean.getBoolean("com.azul.crs.jarload.sendJarEntriesHashesOnJarLoad");
    private static final boolean sendJarEntries = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.sendJarEntriesOnJarLoad", true);
    private static final boolean sendJarFile = Boolean.getBoolean("com.azul.crs.jarload.sendJarFileOnJarLoad");
    private static final String allowedToSendJarFiles = System.getProperty("com.azul.crs.jarload.allowedToSendJarFilesListOnJarLoad");
    private static final String sendJarEntriesList = System.getProperty("com.azul.crs.jarload.sendJarEntriesListOnJarLoad", "**/META-INF/MANIFEST.MF,**/pom.properties");
    private static JarLoadMonitor instance = new JarLoadMonitor();
    private Client client;
    private volatile boolean started;
    private volatile boolean stopped;
    private long _count;
    private final PrintWriter traceOut;
    private MessageDigest md;
    private Set<String> knownClassLoadSources;
    private ZipTools zt;
    private JarEntryAccess jarEntryAccess;
    private JarFileAccess jarFileAccess;

    private JarLoadMonitor() {
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.logger().error("Failed to initialize SHA-256 MessageDigest. Stop jar load monitor: %s", noSuchAlgorithmException);
            this.stop(0L);
        }
        this.zt = new ZipTools();
        this.jarEntryAccess = new JarEntryAccess(sendJarEntriesList);
        this.jarFileAccess = new JarFileAccess(allowedToSendJarFiles);
        if (jarLoadByClassLoad) {
            this.knownClassLoadSources = new HashSet<String>();
        }
        PrintWriter printWriter = null;
        if (this.logger().isEnabled(Logger.Level.TRACE)) {
            try {
                Path path = Files.createTempFile("CRSJarLoadMonitor", ".log", new FileAttribute[0]);
                this.logger().trace("writing JarLoadMonitor trace to file %s", path);
                printWriter = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));
            }
            catch (IOException iOException) {
                this.logger().error("Cannot trace events into file: %s", iOException);
            }
        }
        this.traceOut = printWriter;
    }

    public static JarLoadMonitor getInstance(Client client) {
        JarLoadMonitor.instance.client = client;
        return instance;
    }

    private VMEvent jarLoadEvent(String string, String string2, long l, String string3, String string4, String string5, Long l2, Map<String, String> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        hashMap.put("jarName", string2);
        hashMap.put("centralDirectoryHash", string3);
        hashMap.put("manifestHash", string4);
        hashMap.put("centralDirectoryExtractionMethod", string5);
        hashMap.put("centralDirectoryLength", l2 != null ? Long.toString(l2) : null);
        hashMap.put("entries", map);
        return new VMEvent().randomEventId().eventType(VMEvent.Type.VM_JAR_LOADED).eventTime(l).eventPayload(hashMap);
    }

    @Override
    public synchronized void start() {
        this.started = true;
    }

    @Override
    public synchronized void stop(long l) {
        this.logger().debug("total jars loaded count " + this._count, new Object[0]);
        PerformanceMetrics.logClassLoads(this._count);
        if (this.traceOut != null) {
            this.traceOut.close();
        }
        this.started = false;
        this.stopped = true;
    }

    public static URL getJarURL(URL uRL) {
        String string = uRL.toString();
        if (string.contains("!/") && !(string = string.substring(0, string.lastIndexOf("!/"))).contains("!/") && string.startsWith("jar:")) {
            string = string.substring(4);
        }
        if (!(string.endsWith(".jar!/") || string.endsWith(".war!/") || string.endsWith(".jar") || string.endsWith(".war"))) {
            Logger.getLogger(JarLoadMonitor.class).debug("given url=" + uRL + " does not have jar to be reported for load event. source=" + string, new Object[0]);
            return null;
        }
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            Logger.getLogger(JarLoadMonitor.class).warning("Failed to construct jar url from url=%s, modified source string=%s", uRL, string, exception);
            return uRL;
        }
    }

    private ZipTools.JarShortDigest getJarCentralDirectorySignature(URL uRL, JarFile jarFile) {
        try {
            URL uRL2 = JarLoadMonitor.getJarURL(uRL);
            if (null == uRL2) {
                return null;
            }
            ZipTools.JarShortDigest jarShortDigest = this.zt.getDigest((MessageDigest)this.md.clone(), uRL2, jarFile);
            if (jarShortDigest == null) {
                return null;
            }
            if (DEBUG) {
                System.out.println(">>> notifyJarLoad url=" + uRL + "\njar=" + jarFile + "\ncentralDirectoryHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()) + "\nmanifestHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getManifestHash()));
            }
            if (this.traceOut != null) {
                this.traceOut.printf("%s", uRL.toString());
            }
            return jarShortDigest;
        }
        catch (Exception exception) {
            this.logger().error("notifyJarLoad url=%s, jar=%s has been interrupted by exception (%s): %s", uRL, jarFile, jarFile != null ? jarFile.getClass().getName() : null, exception);
            return null;
        }
    }

    private void sendJar(URL uRL, JarFile jarFile) {
        if (!this.jarFileAccess.isAllowed(jarFile.getName())) {
            this.logger().debug("jar=%s file is not allowed to upload. skip", jarFile.getName());
            return;
        }
        int n = this.client.createArtifactId();
        this.logger().info("created VM artifact: " + n, new Object[0]);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", jarFile.getName());
        hashMap.put("url", uRL.toString());
        hashMap.put("tags", Inventory.instanceTags());
        try {
            uRL = JarLoadMonitor.getJarURL(uRL);
        }
        catch (Exception exception) {
            this.logger().error("failed to construct jar url by source %s: %s", uRL, exception);
            return;
        }
        if (null == uRL) {
            return;
        }
        this.client.postVMArtifact(VMArtifact.Type.JAR, n, hashMap);
        try (InputStream inputStream = uRL.openConnection().getInputStream();){
            byte[] byArray = new byte[8192];
            int n2 = -1;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                this.client.postVMArtifactData(VMArtifact.Type.JAR, n, byArray, n2);
            }
        }
        catch (Exception exception) {
            this.logger().error("failed to send jar file %s url %s: %s", jarFile, uRL, exception);
        }
    }

    private Map<String, String> getAllJarEntriesHashes(URL uRL, JarFile jarFile) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte[] byArray = new byte[8192];
        for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
            try {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    int n = -1;
                    this.md.reset();
                    while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        this.md.update(byArray, 0, n);
                    }
                    hashMap.put(jarEntry.getName(), Utils.encodeToStringOrNull(this.md.digest()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                this.logger().error("failed to calculate sha-256 of jar entry %s: %s", jarEntry.getName(), exception);
            }
        }
        return hashMap;
    }

    public void notifyJarLoad(URL uRL, JarFile jarFile) {
        if (this.stopped) {
            return;
        }
        if (!this.started) {
            this.logger().error("service is not yet started", new Object[0]);
        }
        if (uRL == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        ++this._count;
        try {
            long l = Utils.currentTimeMillis();
            ZipTools.JarShortDigest jarShortDigest = null;
            Map<String, String> map = null;
            if (sendCentralDirectoryHash) {
                jarShortDigest = this.getJarCentralDirectorySignature(uRL, jarFile);
            }
            if (sendJarEntriesHashes) {
                map = this.getAllJarEntriesHashes(uRL, jarFile);
            }
            if (jarShortDigest != null || map != null) {
                String string = jarShortDigest == null ? null : Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash());
                String string2 = jarShortDigest == null ? null : Utils.encodeToStringOrNull(jarShortDigest.getManifestHash());
                String string3 = jarShortDigest == null ? null : jarShortDigest.getProvider();
                Long l2 = jarShortDigest == null ? null : Long.valueOf(jarShortDigest.getCentralDirectoryLength());
                this.client.postVMEvent(this.jarLoadEvent(uRL.toString(), jarFile.getName(), l, string, string2, string3, l2, map));
            }
            if (sendJarFile) {
                this.sendJar(uRL, jarFile);
            }
            if (sendJarEntries) {
                Collections.list(jarFile.entries()).stream().filter(jarEntry -> this.jarEntryAccess.isAllowed(jarEntry.getName())).forEach(jarEntry -> this.uploadJarEntry(uRL, jarFile, jarEntry.getName()));
            }
        }
        catch (Exception exception) {
            System.out.println("!!! unexpected exception: " + exception);
            exception.printStackTrace();
        }
    }

    private void uploadJarEntry(URL uRL, JarFile jarFile, String string) {
        Object object;
        if (uRL == null) {
            return;
        }
        if (jarFile == null) {
            try {
                object = JarLoadMonitor.getJarURL(uRL);
                URLConnection uRLConnection = ((URL)object).openConnection();
                if (!(uRLConnection instanceof JarURLConnection)) {
                    this.logger().warning("failed to get jar file by url %s", uRL);
                    return;
                }
                jarFile = ((JarURLConnection)uRLConnection).getJarFile();
            }
            catch (Exception exception) {
                this.logger().warning("failed to construct jar url by source %s", uRL, exception);
                return;
            }
        }
        if (!this.jarEntryAccess.isAllowed(string)) {
            this.logger().error("it is not allowed to send jar=%s entry=%s url=%s list=%s", jarFile.getName(), string, uRL, sendJarEntriesList);
            return;
        }
        object = jarFile.getJarEntry(string);
        if (object == null) {
            this.logger().info("jar entry=%s is not present in jar=%s url=%s", string, jarFile.getName(), uRL);
            return;
        }
        int n = this.client.createArtifactId();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("jar", jarFile.getName());
        hashMap.put("url", uRL.toString());
        hashMap.put("entry", string);
        hashMap.put("tags", Inventory.instanceTags());
        this.client.postVMArtifact(VMArtifact.Type.JAR_ENTRY, n, hashMap);
        this.logger().info("send jar=%s entry=%s url=%s artifactId=%d", jarFile.getName(), string, uRL, n);
        try (InputStream inputStream = jarFile.getInputStream((ZipEntry)object);){
            int n2 = -1;
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                this.client.postVMArtifactData(VMArtifact.Type.JAR_ENTRY, n, byArray, n2);
            }
        }
        catch (Exception exception) {
            this.logger().error("failed to send jar=%s entry=%s url=%s: %s", jarFile.getName(), string, uRL, exception);
        }
    }

    public void notifyClassSourceSeen(String string) {
        block11: {
            try {
                if (string == null) {
                    return;
                }
                if (!jarLoadByClassLoad) {
                    return;
                }
                if ("__JVM_DefineClass__".equals(string)) {
                    return;
                }
                if (this.knownClassLoadSources.contains(string)) {
                    return;
                }
                this.knownClassLoadSources.add(string);
                try {
                    if (string.matches("^file:.*\\.jar$")) {
                        string = "jar:" + string + "!/";
                    }
                    if (!string.endsWith(".jar!/")) {
                        return;
                    }
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection instanceof JarURLConnection) {
                        JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                        JarFile jarFile = jarURLConnection.getJarFile();
                        this.notifyJarLoad(uRL, jarFile);
                        break block11;
                    }
                    this.logger().debug("Cannot open JarURLConnection from given class source (%s) (URLConnection.class=%s)", string, uRLConnection.getClass().getName());
                }
                catch (Exception exception) {
                    this.logger().debug("Class source (%s) is malformed or is not applicable to extract jar file", string, exception);
                }
            }
            catch (Exception exception) {
                System.out.println("!!! unexpected exception: " + exception);
                exception.printStackTrace();
            }
        }
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        return Boolean.parseBoolean(System.getProperty(string, String.valueOf(bl)));
    }

    private static final class JarFileAccess {
        private Collection<Pattern> patterns = new ArrayList<Pattern>();

        JarFileAccess(String string) {
            if (string != null && string.length() > 0) {
                for (String string2 : string.split(",")) {
                    string2 = string2.replaceAll("\\*\\*", "%%%%1%%%%");
                    string2 = string2.replaceAll("\\*", "%%%%2%%%%");
                    string2 = string2.replaceAll("%%%%1%%%%", ".*");
                    string2 = string2.replaceAll("%%%%2%%%%", "[^/]*");
                    this.patterns.add(Pattern.compile(string2));
                }
            }
        }

        public boolean isAllowed(String string) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
            return false;
        }
    }

    private static final class JarEntryAccess {
        private Collection<String> entireFileNameMatch = new ArrayList<String>();
        private Collection<String> suffixMatch = new ArrayList<String>();
        private static final String prefix = "**/";

        JarEntryAccess(String string) {
            for (String string2 : string.split(",")) {
                if (string2.startsWith(prefix)) {
                    this.suffixMatch.add(string2.substring(prefix.length()));
                    continue;
                }
                this.entireFileNameMatch.add(string2);
            }
        }

        public boolean isAllowed(String string) {
            if (string == null) {
                return false;
            }
            if (this.entireFileNameMatch.contains(string)) {
                return true;
            }
            for (String string2 : this.suffixMatch) {
                int n;
                int n2 = string.length();
                if (n2 < (n = string2.length()) || !string.endsWith(string2) || n2 != n && string.charAt(n2 - n - 1) != '/') continue;
                return true;
            }
            return false;
        }
    }
}

