/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.FileTailer;
import com.azul.crs.client.service.FileTailerListener;
import com.azul.crs.client.service.GCRotatingLogTailer;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GCLogMonitor
implements ClientService {
    private static long CHECK_DELAY = 1000L;
    private static int BUFFER_SIZE = 102400;
    private final Client client;
    private final long startTime;
    private final AtomicLong reported;
    private FileTailer tailer;
    private volatile boolean running;

    @Override
    public String serviceName() {
        return "client.service.GCLog";
    }

    private GCLogMonitor(Client client, long l) {
        this.client = client;
        this.startTime = l;
        this.reported = new AtomicLong();
    }

    public static GCLogMonitor getInstance(Client client, long l) {
        return new GCLogMonitor(client, l);
    }

    private static Map<String, ?> gclogOptions() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List<String> list = Inventory.jvmArgs();
        for (String string : list) {
            for (Option option : Option.values()) {
                if (option.matchAndSet(string, hashMap)) break;
            }
        }
        return hashMap;
    }

    private FileTailerListener gclogListener(final int n) {
        return new FileTailerListener(){

            @Override
            public void handle(byte[] byArray, int n2) {
                GCLogMonitor.this.client.postVMArtifactData(VMArtifact.Type.GC_LOG, n, byArray, n2);
                long l = GCLogMonitor.this.reported.addAndGet(n2);
                GCLogMonitor.this.logger().info("appended GC log artifact %s: size=%,d bytes, reported=%,d bytes", n, n2, l);
            }

            @Override
            public void handle(Exception exception) {
                GCLogMonitor.this.logger().error("failed to tail GC log file: %s", exception);
            }

            @Override
            public void fileRotated(String string) {
                GCLogMonitor.this.logger().info("GC log file rotated: " + string, new Object[0]);
            }

            @Override
            public void fileNotFound() {
                GCLogMonitor.this.logger().info("GC log file not found", new Object[0]);
            }

            @Override
            public void interrupted() {
                GCLogMonitor.this.logger().info("GC log tailing interrupted", new Object[0]);
            }
        };
    }

    private String getGClogFileName11(String string) {
        String string2 = null;
        String string3 = string;
        if (string3 != null && string3.matches("^[^:]*(gc|all)[^:]*:.*$")) {
            string3 = string3.replaceFirst("^[^:]*:", "");
            if ((string3 = string3.replaceFirst("file=", "")).startsWith("\"")) {
                string3 = string3.substring(1, string3.indexOf("\"", 1));
            } else {
                int n = string3.indexOf(":");
                if (System.getProperty("os.name").contains("Windows") && ":\\".equals(string3.substring(n, n + 2))) {
                    n = string3.indexOf(":", n + 1);
                }
                string3 = string3.substring(0, n);
            }
            string2 = string3;
        }
        return string2;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
        Map<String, ?> map = GCLogMonitor.gclogOptions();
        String string = null;
        string = (String)map.get(Option.LOG_GC.flag());
        if (string == null) {
            string = this.getGClogFileName11((String)map.get(Option.XLOG.flag()));
        }
        if (string == null) {
            return;
        }
        if (string.indexOf("%t") >= 0 || string.indexOf("%p") >= 0) {
            this.logger().info("unsupported '%' macros in GC log file name", new Object[0]);
            return;
        }
        int n = this.client.createArtifactId();
        this.logger().info("created VM artifact: " + n, new Object[0]);
        File file = new File(string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", file.getName());
        hashMap.put("tags", Inventory.instanceTags());
        hashMap.put("options", map);
        this.client.postVMArtifact(VMArtifact.Type.GC_LOG, n, hashMap);
        FileTailerListener fileTailerListener = this.gclogListener(n);
        if (Boolean.TRUE.equals(map.get(Option.USE_GC_LOG_FILE_ROTATION.flag()))) {
            String string2 = (String)map.get(Option.NUMBER_OF_GC_LOG_FILES.flag());
            int n2 = Integer.parseInt(string2);
            this.logger().info("GC log rotation requested: logCount=" + n2, new Object[0]);
            this.tailer = ((GCRotatingLogTailer.Builder)((GCRotatingLogTailer.Builder)((GCRotatingLogTailer.Builder)((GCRotatingLogTailer.Builder)new GCRotatingLogTailer.Builder(file).serviceName(this.serviceName())).listener(fileTailerListener)).delayTimeout(CHECK_DELAY)).bufSize(BUFFER_SIZE)).logCount(n2).startTime(this.startTime).build();
        } else {
            this.tailer = ((FileTailer.Builder)((FileTailer.Builder)((FileTailer.Builder)((FileTailer.Builder)new FileTailer.Builder(file).serviceName(this.serviceName())).listener(fileTailerListener)).delayTimeout(CHECK_DELAY)).bufSize(BUFFER_SIZE)).build();
        }
        this.running = true;
        this.tailer.start();
    }

    @Override
    public synchronized void stop(long l) {
        if (!this.running) {
            return;
        }
        this.tailer.stop(l);
        this.running = false;
        this.logger().info("GC log monitor stopped: reported=%,d bytes", this.reported.get());
    }

    static enum Option {
        LOG_GC("-X(loggc):(\\S+)"),
        XLOG("-X(log):(\\S+)"),
        PRINT_GC("-XX:\\+(PrintGC)"),
        PRINT_GC_DETAILS("-XX:\\+(PrintGCDetails)"),
        PRINT_GC_TIME_STAMPS("-XX:\\+(PrintGCTimeStamps)"),
        PRINT_GC_DATE_STAMPS("-XX:\\+(PrintGCDateStamps)"),
        PRINT_HEAP_AT_GC("-XX:\\+(PrintHeapAtGC)"),
        USE_GC_LOG_FILE_ROTATION("-XX:\\+(UseGCLogFileRotation)"),
        NUMBER_OF_GC_LOG_FILES("-XX:(NumberOfGCLogFiles)=(\\S+)"),
        GC_LOG_FILE_SIZE("-XX:(GCLogFileSize)=(\\S+)");

        private final Pattern pattern;
        private final String flag;

        private Option(String string2) {
            this.flag = string2.substring(string2.indexOf(40) + 1, string2.indexOf(41));
            this.pattern = Pattern.compile(string2);
        }

        public Pattern pattern() {
            return this.pattern;
        }

        public String flag() {
            return this.flag;
        }

        public boolean matchAndSet(String string, Map<String, Object> map) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                Object object = matcher.groupCount() > 1 ? matcher.group(2) : Boolean.valueOf(true);
                map.put(string2, object);
                return true;
            }
            return false;
        }
    }
}

