/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Utils;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.FileTailerListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileTailer
implements ClientService {
    private static final int DEFAULT_DELAY_TIMEOUT = 1000;
    private static final int DEFAULT_BUFSIZE = 4096;
    private static final int EOF = -1;
    protected final String serviceName;
    protected final File file;
    protected final byte[] inputBuf;
    protected final long delayTimeout;
    protected final boolean fromEnd;
    protected final boolean completeOnStop;
    protected final FileTailerListener listener;
    protected volatile boolean running;
    protected volatile long deadlineTimeCount;
    protected Thread thread;

    protected FileTailer(String string, File file, FileTailerListener fileTailerListener, long l, boolean bl, boolean bl2, int n) {
        this.file = file;
        this.delayTimeout = l;
        this.fromEnd = bl;
        this.completeOnStop = bl2;
        this.inputBuf = new byte[n];
        this.listener = fileTailerListener;
        this.serviceName = string == null ? ClientService.super.serviceName() : string;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
        this.running = true;
        this.thread = new Thread(this::run);
        this.thread.setDaemon(true);
        this.thread.setName("CRSFileTailer");
        this.thread.start();
    }

    @Override
    public synchronized void stop(long l) {
        if (!this.running) {
            throw new IllegalStateException("File tailer has not been started");
        }
        try {
            this.running = false;
            this.thread.interrupt();
            this.deadlineTimeCount = l;
            long l2 = -Utils.elapsedTimeMillis(this.deadlineTimeCount);
            if (l2 > 0L) {
                this.thread.join(l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void run() {
        block32: {
            FileInputStream fileInputStream = null;
            try {
                long l = 0L;
                long l2 = 0L;
                this.logger().info("looking for file %s", this.file.getName());
                while (this.running && fileInputStream == null) {
                    try {
                        fileInputStream = new FileInputStream(this.file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.listener.fileNotFound();
                    }
                    if (fileInputStream == null) {
                        Thread.sleep(this.delayTimeout);
                        continue;
                    }
                    try {
                        l2 = this.fromEnd ? fileInputStream.skip(this.file.length()) : this.readBytes(fileInputStream);
                        l = this.file.lastModified();
                    }
                    catch (IOException iOException) {
                        this.listener.handle(iOException);
                    }
                }
                this.logger().info("tailing file %s", this.file.getName());
                while (this.running) {
                    boolean bl = this.file.lastModified() > l;
                    long l3 = this.file.length();
                    if (l3 < l2) {
                        this.listener.fileRotated("");
                        try {
                            FileInputStream fileInputStream2 = fileInputStream;
                            Throwable throwable = null;
                            try {
                                fileInputStream = new FileInputStream(this.file);
                                this.readBytes(fileInputStream2);
                                l2 = 0L;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (fileInputStream2 == null) continue;
                                if (throwable != null) {
                                    try {
                                        fileInputStream2.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                fileInputStream2.close();
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.listener.fileNotFound();
                            Thread.sleep(this.delayTimeout);
                        }
                        continue;
                    }
                    if (l3 > l2) {
                        l2 += this.readBytes(fileInputStream);
                        l = this.file.lastModified();
                    } else if (bl) {
                        try {
                            fileInputStream = new FileInputStream(this.file);
                            l2 = this.readBytes(fileInputStream);
                            l = this.file.lastModified();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.listener.fileNotFound();
                            Thread.sleep(this.delayTimeout);
                        }
                    }
                    Thread.sleep(this.delayTimeout);
                }
                this.closeReader(fileInputStream);
                this.running = false;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                this.listener.interrupted();
            }
            catch (Exception exception) {
                this.listener.handle(exception);
                break block32;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeReader(fileInputStream);
                this.running = false;
            }
        }
    }

    protected void closeReader(FileInputStream fileInputStream) {
        if (fileInputStream != null) {
            try {
                if (this.completeOnStop) {
                    this.readBytes(fileInputStream);
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                this.listener.handle(iOException);
            }
        }
    }

    protected long readBytes(FileInputStream fileInputStream) {
        int n = 0;
        try {
            while (this.running || this.completeOnStop && Utils.currentTimeCount() < this.deadlineTimeCount) {
                int n2;
                int n3 = n2 = fileInputStream.available() > 0 ? fileInputStream.read(this.inputBuf) : -1;
                if (n2 <= 0) break;
                n += n2;
                this.listener.handle(this.inputBuf, n2);
            }
            this.listener.eofReached();
            return n;
        }
        catch (IOException iOException) {
            this.listener.handle(iOException);
            return n;
        }
    }

    public static class Builder<T extends Builder> {
        protected File file;
        protected FileTailerListener listener;
        protected long delayTimeout = 1000L;
        protected int bufSize = 4096;
        protected boolean fromEnd = false;
        protected boolean completeOnStop = true;
        protected String serviceName;

        public Builder(File file) {
            this.file = file;
        }

        public T listener(FileTailerListener fileTailerListener) {
            this.listener = fileTailerListener;
            return (T)this;
        }

        public T delayTimeout(long l) {
            this.delayTimeout = l;
            return (T)this;
        }

        public T bufSize(int n) {
            this.bufSize = n;
            return (T)this;
        }

        public T fromEnd(boolean bl) {
            this.fromEnd = bl;
            return (T)this;
        }

        public T completeOnStop(boolean bl) {
            this.completeOnStop = bl;
            return (T)this;
        }

        public T serviceName(String string) {
            this.serviceName = string;
            return (T)this;
        }

        public FileTailer build() {
            return new FileTailer(this.serviceName, this.file, this.listener, this.delayTimeout, this.fromEnd, this.completeOnStop, this.bufSize);
        }
    }
}

