/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.models;

import com.azul.crs.client.models.Payload;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMInstance;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class VMEvent<T>
extends Payload {
    private String vmId;
    private String eventId;
    private Type eventType;
    private Long eventTime;
    private T eventPayload;

    public String getVmId() {
        return this.vmId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public Long getEventTime() {
        return this.eventTime;
    }

    public T getEventPayload() {
        return this.eventPayload;
    }

    public void setVmId(String string) {
        this.vmId = string;
    }

    public void setEventId(String string) {
        this.eventId = string;
    }

    public void setEventTime(Long l) {
        this.eventTime = l;
    }

    public void setEventType(Type type) {
        if (this.eventPayload != null && !type.payloadClass().isAssignableFrom(this.eventPayload.getClass())) {
            throw new IllegalArgumentException("Event type inconsistent with event payload type");
        }
        this.eventType = type;
    }

    public void setEventPayload(T t) {
        if (this.eventType != null && !this.eventType.payloadClass().isAssignableFrom(t.getClass())) {
            throw new IllegalArgumentException("Event payload type inconsistent with event type ");
        }
        this.eventPayload = t;
    }

    public VMEvent<T> vmId(String string) {
        this.setVmId(string);
        return this;
    }

    public VMEvent<T> eventId(String string) {
        this.setEventId(string);
        return this;
    }

    public VMEvent<T> randomEventId() {
        this.setEventId(UUID.randomUUID().toString());
        return this;
    }

    public VMEvent<T> eventType(Type type) {
        this.setEventType(type);
        return this;
    }

    public VMEvent<T> eventType(String string) {
        this.setEventType(Type.valueOf(string));
        return this;
    }

    public VMEvent<T> eventTime(Long l) {
        this.setEventTime(l);
        return this;
    }

    public VMEvent<T> eventPayload(T t) {
        this.setEventPayload(t);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VMEvent vMEvent = (VMEvent)object;
        return Objects.equals(this.vmId, vMEvent.vmId) && Objects.equals(this.eventId, vMEvent.eventId) && this.eventType == vMEvent.eventType && Objects.equals(this.eventTime, vMEvent.eventTime) && Objects.equals(this.eventPayload, vMEvent.eventPayload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vmId, this.eventId, this.eventType, this.eventTime, this.eventPayload});
    }

    @Override
    public String toString() {
        return "vmId=" + this.vmId + ", eventId=" + this.eventId + ", eventType=" + (Object)((Object)this.eventType) + ", eventTime=" + this.eventTime + ", eventPayload=" + this.eventPayload;
    }

    public static enum Type {
        VM_CREATE(VMInstance.class),
        VM_PATCH(VMInstance.class),
        VM_ARTIFACT_CREATE(VMArtifact.class),
        VM_ARTIFACT_PATCH(VMArtifact.class),
        VM_ARTIFACT_DATA(Map.class),
        VM_HEARTBEAT(Void.class),
        VM_SHUTDOWN(Void.class),
        VM_CLASS_LOADED(Map.class),
        VM_JAR_LOADED(Map.class),
        VM_METHOD_FIRST_CALLED(Map.class),
        VM_PERFORMANCE_METRICS(Map.class),
        VM_ANY_CONNECTION(Object.class);

        private final Class payloadClass;

        private Type(Class clazz) {
            this.payloadClass = clazz;
        }

        public Class payloadClass() {
            return this.payloadClass;
        }

        public static Type eventType(String string) {
            return string != null ? Type.valueOf(string.toUpperCase()) : null;
        }
    }
}

