/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.json.JSONSerializer;
import com.azul.crs.json.JSONStaticSerializer;
import java.util.Arrays;
import java.util.UUID;

public class Utils {
    private static final char[] digit = "0123456789abcdef".toCharArray();
    public static final JSONSerializer serializer = new JSONStaticSerializer();
    public static final JSONSerializer prettySerializer = new JSONStaticSerializer(true);

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid(String string) {
        return UUID.nameUUIDFromBytes(string.getBytes()).toString();
    }

    public static String uuid(Object ... objectArray) {
        return Utils.uuid(Arrays.toString(objectArray));
    }

    public static String lower(String string) {
        return string != null ? string.toLowerCase() : null;
    }

    public static long currentTimeCount() {
        return System.nanoTime();
    }

    public static long nextTimeCount(long l) {
        return System.nanoTime() + l * 1000000L;
    }

    public static String elapsedTimeString(long l) {
        return String.format(" (%,d ms)", Utils.elapsedTimeMillis(l));
    }

    public static long elapsedTimeMillis(long l) {
        return (System.nanoTime() - l + 500000L) / 1000000L;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String encodeToStringOrNull(byte[] byArray, int n, int n2) {
        if (null == byArray) {
            return null;
        }
        char[] cArray = new char[n2 * 2];
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            cArray[(i - n) * 2] = digit[by >>> 4 & 0xF];
            cArray[(i - n) * 2 + 1] = digit[by & 0xF];
        }
        return new String(cArray);
    }

    public static String encodeToStringOrNull(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        return Utils.encodeToStringOrNull(byArray, 0, byArray.length);
    }
}

