/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.Client;
import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

enum Options {
    props,
    lifetimejfr,
    stackRecordId,
    useCRS,
    UnlockExperimentalCRS,
    forceSyncTimeout,
    noDelayShutdown,
    delayShutdown;

    private static final String DEFAULT_SHARED_PROPS_FILE = "crs.properties";
    private static final String DEFAULT_USER_PROPS_FILE;
    private String value;
    private static Map<Client.ClientProp, Object> clientProps;
    private static LinkedList<Map.Entry<String, String>> loggerOptions;
    private static final String agentAuthPrefix = "agentAuth=";
    private static int connectionPort;
    private static int connectionSecret;

    String get() {
        return this.value;
    }

    boolean isSet() {
        return this.value != null;
    }

    int getInt() {
        return Integer.parseInt(this.value);
    }

    long getLong() {
        return Long.parseLong(this.value);
    }

    private void set(String string) {
        this.value = string;
    }

    static int getConnectionPort() {
        return connectionPort;
    }

    static int getConnectionSecret() {
        return connectionSecret;
    }

    static void read(String string) {
        File file;
        loggerOptions = new LinkedList();
        if (string.startsWith(agentAuthPrefix)) {
            string = Options.initAgentConnectionInfo(string);
        }
        String string2 = System.getenv("CRS_ARGUMENTS");
        String string3 = Options.getPropFileNameFromArgs(string);
        if (string3 == null) {
            string3 = Options.getPropFileNameFromArgs(string2);
        }
        if (string3 != null) {
            file = new File(string3);
            if (!file.exists()) {
                Logger.getLogger(Options.class).error("specified properties file %s does not exist", file.getPath());
            }
        } else {
            file = new File(System.getProperty("user.home") + File.separatorChar + DEFAULT_USER_PROPS_FILE);
            if (!file.exists()) {
                file = new File(System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + DEFAULT_SHARED_PROPS_FILE);
            }
        }
        if (file.exists()) {
            Options.tryLoadingProps(file);
        }
        Options.readArgs(string2);
        Options.readArgs(string);
        for (Map.Entry entry : loggerOptions) {
            Logger.parseOption((String)entry.getKey(), (String)entry.getValue());
        }
        loggerOptions = null;
    }

    private static String initAgentConnectionInfo(String string) {
        char c;
        int n;
        int n2 = string.length();
        for (n = agentAuthPrefix.length(); n < n2 && Character.isDigit(c = string.charAt(n)); ++n) {
            connectionPort = connectionPort * 10 + (c - 48);
        }
        if (n < n2 && string.charAt(n) == '+') {
            ++n;
            while (n < n2 && Character.isDigit(c = string.charAt(n))) {
                connectionSecret = connectionSecret * 10 + (c - 48);
                ++n;
            }
        }
        if (n < n2 && string.charAt(n) == ',') {
            ++n;
        }
        return string.substring(n);
    }

    private static String getPropFileNameFromArgs(String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            int n;
            int n2 = string.indexOf(44);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (string.charAt(0) != ',' && ((n = string.indexOf(61)) < 0 || n > n2)) {
                try {
                    Options.valueOf(string.substring(0, n2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string2 = string.substring(0, n2);
                }
            }
            n = 0;
            String string3 = props.name() + "=";
            int n3 = string3.length();
            do {
                if ((n2 = string.indexOf(44, n)) < 0) {
                    n2 = string.length();
                }
                if (!string.startsWith(string3, n)) continue;
                string2 = string.substring(n + n3, n2);
                break;
            } while ((n = n2 + 1) < string.length());
        }
        return string2;
    }

    private static void readArgs(String string) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = 0;
        do {
            String string2;
            int n3;
            if ((n = string.indexOf(44, n2)) == -1) {
                n = string.length();
            }
            if ((n3 = string.indexOf(61, n2)) == -1 || n3 > n) {
                n3 = n;
            }
            String string3 = string.substring(n2, n3);
            String string4 = string2 = n3 == n ? "" : string.substring(n3 + 1, n);
            if (props.name().equals(string3)) continue;
            Options.process(string3, string2, n2 == 0 && n3 == n);
        } while ((n2 = n + 1) < string.length());
    }

    private static void process(String string, String string2, boolean bl) {
        block8: {
            if (string.equals("log") || string.startsWith("log+")) {
                loggerOptions.add(new AbstractMap.SimpleEntry<String, String>(string, string2));
            } else if (props.name().equals(string)) {
                Options.tryLoadingProps(new File(string2));
            } else if (string.length() > 0) {
                for (Client.ClientProp clientProp : (Client.ClientProp[])Client.ClientProp.class.getEnumConstants()) {
                    if (!clientProp.value().equals(string)) continue;
                    clientProps.put(clientProp, string2);
                    return;
                }
                try {
                    Options.valueOf(string).set(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (bl) break block8;
                    Logger.getLogger(Options.class).error("unrecognized CRS agent option %s ignored", string);
                }
            }
        }
    }

    private static void tryLoadingProps(File file) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
            for (String string : properties.stringPropertyNames()) {
                Options.process(string, properties.getProperty(string), false);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(Options.class).error("cannot load specified properties file %s: %s", file.getPath(), iOException.getMessage());
        }
    }

    public static Map<Client.ClientProp, Object> getClientProps() {
        return clientProps;
    }

    static {
        DEFAULT_USER_PROPS_FILE = ".crs" + File.separatorChar + "config.properties";
        clientProps = new HashMap<Client.ClientProp, Object>();
    }
}

