/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.Client;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.Address;
import com.azul.crs.client.models.Network;
import com.azul.crs.client.sysinfo.SystemInfoProvider;
import com.azul.crs.util.logging.Logger;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Inventory {
    public static final String INSTANCE_TAGS_PROPERTY = "com.azul.crs.instance.tags";
    public static final String HOST_NAME_KEY = "hostName";
    public static final String NETWORKS_KEY = "networks";
    public static final String SYSTEM_PROPS_KEY = "systemProperties";
    public static final String SYSTEM_INFO_KEY = "systemInfo";
    public static final String CPU_INFO_KEY = "cpuInfo";
    public static final String MEM_INFO_KEY = "memInfo";
    public static final String OS_INFO_KEY = "osInfo";
    public static final String JVM_ARGS_KEY = "jvmArgs";
    public static final String MAIN_METHOD = "mainMethod";
    public static final String ENVIRONMENT_KEY = "osEnvironment";
    private Logger logger = Logger.getLogger(Inventory.class);
    private Map<String, Object> map = new LinkedHashMap<String, Object>();

    public Inventory populate() {
        this.map.put(HOST_NAME_KEY, this.hostName());
        this.map.put(SYSTEM_PROPS_KEY, new HashMap(this.systemProperties()));
        this.map.put(JVM_ARGS_KEY, Inventory.jvmArgs());
        this.map.put(ENVIRONMENT_KEY, this.osEnvironment());
        return this;
    }

    public Inventory networkInformation() {
        this.map.put(NETWORKS_KEY, this.networks());
        return this;
    }

    public Inventory systemInformation() {
        try {
            this.map.put(CPU_INFO_KEY, SystemInfoProvider.getCPUInfo());
            this.map.put(MEM_INFO_KEY, SystemInfoProvider.getMemInfo());
            this.map.put(OS_INFO_KEY, SystemInfoProvider.getOSInfo());
            this.map.put(SYSTEM_INFO_KEY, SystemInfoProvider.getAllProperties());
        }
        catch (Exception exception) {
            this.logger.warning("Failed to get system information. The data may be incomplete", exception);
        }
        return this;
    }

    public Inventory mainMethod(String string) {
        this.map.put(MAIN_METHOD, string);
        return this;
    }

    public String hostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.warning("cannot get host name %s", unknownHostException.toString());
            String string = this.getHostNameViaReflection();
            if (string == null) {
                string = this.getHostNameFromNetworkInterface();
            }
            if (string == null) {
                string = "<UNKNOWN>";
            }
            return string;
        }
    }

    public static String instanceTags() {
        return System.getProperties().getProperty(INSTANCE_TAGS_PROPERTY);
    }

    public Map systemProperties() {
        return System.getProperties();
    }

    public Map<String, String> osEnvironment() {
        return System.getenv();
    }

    public static List<String> jvmArgs() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments();
    }

    private List<Network> networks() {
        try {
            ArrayList<Network> arrayList = new ArrayList<Network>();
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                try {
                    if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.getName().startsWith("docker")) continue;
                    ArrayList<Address> arrayList2 = new ArrayList<Address>();
                    for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                        if (Client.isVMShutdownInitiated() && Utils.currentTimeCount() >= Client.getVMShutdownDeadline()) {
                            return Collections.emptyList();
                        }
                        arrayList2.add(new Address(inetAddress.getCanonicalHostName(), this.getTrueIpAddress(inetAddress)));
                    }
                    arrayList2.sort(new Comparator<Address>(){

                        @Override
                        public int compare(Address address, Address address2) {
                            return address.hostname.compareTo(address2.hostname);
                        }
                    });
                    arrayList.add(new Network(networkInterface.getName(), arrayList2));
                }
                catch (SocketException socketException) {
                    this.logger.warning("cannot get network info %s", socketException.toString());
                }
            }
            arrayList.sort(new Comparator<Network>(){

                @Override
                public int compare(Network network, Network network2) {
                    return network.interfaceName.compareTo(network2.interfaceName);
                }
            });
            return arrayList;
        }
        catch (SocketException socketException) {
            this.logger.warning("cannot get network info %s", socketException.toString());
            return Collections.emptyList();
        }
    }

    private String getTrueIpAddress(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        int n = string.indexOf(37);
        return n < 0 ? string : string.substring(0, n);
    }

    Map<String, Object> toMap() {
        return this.map;
    }

    private String getHostNameViaReflection() {
        try {
            Class<?> clazz = Class.forName("java.net.Inet4AddressImpl");
            Method method = clazz.getDeclaredMethod("getLocalHostName", new Class[0]);
            method.setAccessible(true);
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != 0) continue;
                constructor.setAccessible(true);
                Object obj = constructor.newInstance(new Object[0]);
                Object object = method.invoke(obj, new Object[0]);
                if (object instanceof String) {
                    return (String)object;
                }
                this.logger.warning("cannot get host name. internal error %s", object == null ? null : object.getClass());
                return null;
            }
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            this.logger.warning("cannot get host name %s", exception.toString());
        }
        return null;
    }

    private String getHostNameFromNetworkInterface() {
        try {
            String string = null;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress instanceof Inet4Address) {
                        return inetAddress.getCanonicalHostName();
                    }
                    string = inetAddress.getCanonicalHostName();
                }
            }
            return string;
        }
        catch (SocketException socketException) {
            this.logger.warning("cannot get host name for iface %s", socketException.toString());
            return null;
        }
    }
}

