/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.ConnectionManager;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Result;
import com.azul.crs.client.Utils;
import com.azul.crs.client.Version;
import com.azul.crs.client.models.Payload;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMArtifactChunk;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.models.VMInstance;
import com.azul.crs.client.service.EventService;
import com.azul.crs.client.service.UploadService;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Client {
    private final ConnectionManager connectionManager;
    private final UploadService uploadService;
    private final EventService eventService;
    private final AtomicInteger nextArtifactId = new AtomicInteger();
    private final AtomicLong nextArtifactChunkId = new AtomicLong();
    private static volatile long vmShutdownDeadline;
    private long vmShutdownDelay;
    private String vmId;

    private void validateProps(Map<ClientProp, Object> map) {
        for (ClientProp clientProp : ClientProp.values()) {
            if (!clientProp.isMandatory() || map.get((Object)clientProp) != null) continue;
            throw new IllegalArgumentException("Invalid CRS properties file: missing value for " + clientProp.value());
        }
    }

    public Client(Map<ClientProp, Object> map, final ClientListener clientListener) {
        this.validateProps(map);
        this.vmShutdownDelay = (Long)map.get((Object)ClientProp.VM_SHUTDOWN_DELAY);
        this.eventService = EventService.getInstance(this);
        this.connectionManager = new ConnectionManager(map, this, new ConnectionManager.ConnectionListener(){

            @Override
            public void authenticated() {
                Client.this.vmId = Client.this.connectionManager.getVmId();
                clientListener.authenticated();
            }

            @Override
            public void syncFailed(Result<String[]> result) {
                clientListener.syncFailed(result);
            }
        });
        this.uploadService = new UploadService(this);
    }

    public void postVMStart(Map<String, Object> map, long l) throws IOException {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_CREATE).eventPayload(new VMInstance().agentVersion(this.getClientVersion()).owner(this.connectionManager.getMailbox()).inventory(map).startTime(l)));
    }

    public void patchInventory(Map<String, Object> map) {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_PATCH).eventPayload(new VMInstance().inventory(map)));
    }

    public void postVMEvent(VMEvent vMEvent) {
        this.eventService.add(vMEvent.randomEventId());
    }

    public void postVMShutdown(Collection<VMEvent> collection) {
        this.eventService.addAll(collection);
        this.eventService.add(new VMEvent().eventType(VMEvent.Type.VM_SHUTDOWN).eventTime(Utils.currentTimeMillis()));
    }

    public int createArtifactId() {
        return this.nextArtifactId.incrementAndGet();
    }

    public long createArtifactChunkId() {
        return this.nextArtifactChunkId.incrementAndGet();
    }

    public void postVMArtifact(VMArtifact.Type type, int n, Map<String, Object> map) {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_CREATE).eventPayload(new VMArtifact().artifactType(type).artifactId(Client.artifactIdToString(n)).metadata(map)));
    }

    public void postVMArtifactPatch(VMArtifact.Type type, int n, Map<String, Object> map) {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_PATCH).eventPayload(new VMArtifact().artifactType(type).artifactId(Client.artifactIdToString(n)).metadata(map)));
    }

    public void postVMArtifactData(VMArtifact.Type type, int n, byte[] byArray, int n2) {
        this.postVMArtifactData(type, n, byArray, 0, n2);
    }

    public void postVMArtifactData(VMArtifact.Type type, int n, byte[] byArray, int n2, int n3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("artifactId", Client.artifactIdToString(n));
        hashMap.put("data", new String(byArray, 0, n2, n3));
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_DATA).eventPayload(hashMap));
        PerformanceMetrics.logArtifactBytes(n3);
    }

    public void postVMArtifactChunk(Set<String> set, Map<String, Object> map, File file, UploadListener<VMArtifactChunk> uploadListener) {
        this.uploadService.post(new VMArtifactChunk().artifactIds(set).metadata(map), file, uploadListener);
    }

    public void finishChunkPost() {
        long l = vmShutdownDeadline;
        this.uploadService.sync(l > 0L ? l : Utils.nextTimeCount(this.vmShutdownDelay));
    }

    public static String artifactIdToString(int n) {
        return Integer.toString(n, 36);
    }

    public void startup() throws IOException {
        this.connectionManager.start();
        this.eventService.start();
        this.uploadService.start();
    }

    public void connectionEstablished() {
        this.eventService.connectionEstablished();
        this.uploadService.connectionEstablished();
    }

    public static boolean isVMShutdownInitiated() {
        return vmShutdownDeadline > 0L;
    }

    public static void setVMShutdownInitiated(long l) {
        vmShutdownDeadline = l;
    }

    public static long getVMShutdownDeadline() {
        return vmShutdownDeadline;
    }

    public void shutdown(long l) {
        this.eventService.stop(l);
        this.uploadService.stop(l);
    }

    public void cancel() {
        this.eventService.cancel();
        this.uploadService.cancel();
    }

    public String getVmId() {
        return this.vmId;
    }

    public String getClientVersion() throws IOException {
        return new Version().clientVersion();
    }

    public String getMailbox() {
        return this.connectionManager.getMailbox();
    }

    public String getRestAPI() {
        return this.connectionManager.getRestAPI();
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public static enum ClientProp {
        API_URL("api.url", true),
        API_MAILBOX("api.mailbox", true),
        KS("ks", false),
        HEAP_BUFFER_SIZE("heapBufferSize", false),
        FILE_SYSTEM_BUFFER_SIZE("fileSystemBufferSize", false),
        FILE_SYSTEM_BUFFER_LOCATION("fileSystemBufferLocation", false),
        NUM_CONCURRENT_CONNECTIONS("numConcurrentConnections", false),
        BACKUP_JFR_CHUNKS("backupJfrChunks", false),
        VM_SHUTDOWN_DELAY("delayShutdownInternal", true);

        private final Object value;
        private final boolean mandatory;

        private ClientProp(String string2, boolean bl) {
            this.value = string2;
            this.mandatory = bl;
        }

        Object value() {
            return this.value;
        }

        boolean isMandatory() {
            return this.mandatory;
        }
    }

    public static interface UploadListener<T extends Payload> {
        public void uploadComplete(T var1);

        public void uploadFailed(T var1, Result<String[]> var2);
    }

    public static interface ClientListener {
        public void authenticated();

        public void syncFailed(Result<String[]> var1);
    }
}

