/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.CRSException;
import com.azul.crs.client.Client;
import com.azul.crs.client.ConnectionManager;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.Options;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Result;
import com.azul.crs.client.Utils;
import com.azul.crs.client.VMSupport;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.CRSLogMonitor;
import com.azul.crs.client.service.ClassLoadMonitor;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.FirstCallMonitor;
import com.azul.crs.client.service.GCLogMonitor;
import com.azul.crs.client.service.HeartbeatService;
import com.azul.crs.client.service.JFRMonitor;
import com.azul.crs.client.service.JarLoadMonitor;
import com.azul.crs.client.service.VMLogMonitor;
import com.azul.crs.client.service.VMToolingClient;
import com.azul.crs.client.util.DnsDetect;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.launcher.LauncherHelper;

class Agent001 {
    private static final int CRS_DISABLED = -1;
    private static final int CRS_NOT_YET_DECIDED = 0;
    private static final int CRS_LAUNCHER_DETECTED = 1;
    private static final int CRS_ENABLED_FORCED = 2;
    private static final int CRS_ENABLED_MAIN_KNOWN = 3;
    private static HeartbeatService heartbeatService;
    private static GCLogMonitor gclogMonitor;
    private static VMLogMonitor vmlogMonitor;
    private static JFRMonitor jfrMonitor;
    private static ClassLoadMonitor classLoadMonitor;
    private static FirstCallMonitor firstCallMonitor;
    private static JarLoadMonitor jarLoadMonitor;
    private static VMToolingClient vmToolingClient;
    private static Client client;
    private static volatile int useCRS;
    private static Thread startThread;
    private static volatile boolean launcherDetected;
    private static final int FLUSH_THREAD_DEFAULT_PERIOD_MS = 1000;
    private static final int FLUSH_THREAD_FORCE_DEFAULT_PERIOD_MS = 1800000;
    private static final long DEFAULT_SHUTDOWN_DELAY = 120000L;
    private static final Object flushThreadLock;
    private static boolean flushThreadStop;
    private static volatile Thread flushThread;
    private static int forceFlushTimeout;
    private static long delayShutdown;
    private static final Logger logger;
    private static final CRSLogMonitor crslogMonitor;
    private static boolean connectionEstablished;
    static VMSupport vmSupport;

    Agent001() {
    }

    private static void addShutdownHook(final long l) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long l3 = Utils.nextTimeCount(delayShutdown);
                    Client.setVMShutdownInitiated(l3);
                    long l2 = Utils.currentTimeCount();
                    if (delayShutdown > 0L) {
                        logger.trace("checking if startup is complete and waiting for it to finish (%d ms)", delayShutdown);
                        startThread.join();
                        if (useCRS == -1) {
                            return;
                        }
                        logger.debug("drain native queue", new Object[0]);
                        flushThreadStop = true;
                        Object object = flushThreadLock;
                        synchronized (object) {
                            flushThreadLock.notifyAll();
                        }
                        try {
                            flushThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Agent001.stopServices(l3, new ClientService[]{heartbeatService, jfrMonitor, vmlogMonitor, gclogMonitor, classLoadMonitor, firstCallMonitor, jarLoadMonitor, vmToolingClient});
                        object = PerformanceMetrics.logPreShutdown(Utils.elapsedTimeMillis(l2));
                        Agent001.postVMShutdown(client, (Map)object);
                        client.shutdown(l3);
                    }
                    if (client != null) {
                        PerformanceMetrics.logShutdown(Utils.elapsedTimeMillis(l2));
                        PerformanceMetrics.report();
                        logger.info("Agent terminated: vmId=%s, runningTime=%d", client.getVmId(), Utils.elapsedTimeMillis(l));
                    } else {
                        logger.info("Agent shut down during startup. Data is discarded", new Object[0]);
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.error("Agent failed to process shutdown during startup. Data is discarded", new Object[0]);
                }
                catch (Throwable throwable) {
                    logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
                }
            }
        }));
    }

    private static void postVMStart(long l, String string) throws Exception {
        Map<String, Object> map = new Inventory().populate().mainMethod(string).toMap();
        logger.trace("Post VM start to CRS service", new Object[0]);
        client.postVMStart(map, l);
    }

    private static void sendMainMethodName(String string) {
        Map<String, Object> map = new Inventory().mainMethod(string).toMap();
        client.patchInventory(map);
    }

    private static void sendNetworkInformation() {
        Map<String, Object> map = new Inventory().networkInformation().toMap();
        client.patchInventory(map);
    }

    private static void sendSystemInformation() {
        Map<String, Object> map = new Inventory().systemInformation().toMap();
        client.patchInventory(map);
    }

    private static void postVMShutdown(Client client, Map map) {
        logger.trace("Post VM shutdown to CRS service", new Object[0]);
        ArrayList<VMEvent> arrayList = new ArrayList<VMEvent>();
        arrayList.add(new VMEvent().eventType(VMEvent.Type.VM_PERFORMANCE_METRICS).randomEventId().eventTime(System.currentTimeMillis()).eventPayload(map));
        client.postVMShutdown(arrayList);
    }

    public static void premain(String string, Instrumentation instrumentation) {
        Options.read(string);
        try {
            vmSupport = VMSupport.init(Options.getConnectionPort(), Options.getConnectionSecret());
            vmSupport.registerAgent(Agent001.class);
            Method method = Agent001.class.getMethod("notifyToJavaCall", String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.EVENT_TO_JAVA_CALL, method);
            Method method2 = Agent001.class.getMethod("notifyClassLoad", String.class, byte[].class, byte[].class, Integer.TYPE, Integer.TYPE, String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_CLASS_LOAD, method2);
            Method method3 = Agent001.class.getMethod("notifyFirstCall", Integer.TYPE, String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_FIRST_CALL, method3);
            Method method4 = Agent001.class.getMethod("notifyVMLogEntry", String.class, String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_VM_LOG_ENTRY, method4);
        }
        catch (IOException | NoSuchMethodException | SecurityException exception) {
            logger.error("Failed to initialize", exception);
            return;
        }
        PerformanceMetrics.init();
        if ("force".equals(Options.useCRS.get())) {
            Agent001.stateEvent(2, null);
        }
        if (Options.forceSyncTimeout.isSet()) {
            forceFlushTimeout = Options.forceSyncTimeout.getInt() * 1000;
        }
        if (Options.delayShutdown.isSet()) {
            delayShutdown = Options.delayShutdown.getLong();
        }
        if (Options.noDelayShutdown.isSet()) {
            delayShutdown = 0L;
        }
        System.setProperty("com.azul.crs.instance.options.delayShutdown", Long.toString(delayShutdown));
    }

    private static synchronized void stateEvent(int n, final String string) {
        switch (n) {
            case 2: {
                assert (useCRS != -1);
                if (useCRS != 0 && useCRS != 1) break;
                useCRS = 2;
                Agent001.activateAgent("");
                break;
            }
            case 1: {
                if (useCRS == 0) {
                    useCRS = 1;
                }
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Class<?> clazz;
                            do {
                                clazz = LauncherHelper.getApplicationClass();
                                Thread.sleep(10L);
                            } while (clazz == null);
                            Agent001.stateEvent(3, clazz.getName().replace('.', '/') + ".main");
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Throwable throwable) {
                            logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
                        }
                    }
                });
                thread.setDaemon(true);
                thread.start();
                break;
            }
            case 3: {
                assert (string != null);
                if (useCRS == 0 || useCRS == 1) {
                    if (string.startsWith("com/sun/tools")) {
                        Agent001.stateEvent(-1, null);
                        break;
                    }
                    useCRS = 3;
                    Agent001.activateAgent(string);
                    break;
                }
                if (useCRS != 2) break;
                assert (startThread != null);
                useCRS = 3;
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            startThread.join();
                            if (useCRS != -1) {
                                Agent001.sendMainMethodName(string);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Throwable throwable) {
                            logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
                        }
                    }
                });
                thread.setDaemon(false);
                thread.start();
                break;
            }
            case -1: {
                useCRS = -1;
                vmSupport.disableCRS();
                break;
            }
            default: {
                throw new InternalError("Unhandled state");
            }
        }
    }

    private static void activateAgent(final String string) {
        final long l = System.currentTimeMillis();
        final long l2 = Utils.currentTimeCount();
        if (logger.isEnabled(Logger.Level.DEBUG)) {
            logger.debug("CRS agent started. VM uptime %dms", ManagementFactory.getRuntimeMXBean().getUptime());
        }
        startThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Agent001.addShutdownHook(l2);
                    }
                    catch (IllegalStateException illegalStateException) {
                        return;
                    }
                    VMCRSCapabilities vMCRSCapabilities = VMCRSCapabilities.init();
                    Agent001.client = new Client(Agent001.getClientProps(), new Client.ClientListener(){

                        @Override
                        public void authenticated() {
                            if (client.getVmId() != null) {
                                logger.info("Agent authenticated: vmId=%s", client.getVmId());
                                if (logger.isEnabled(Logger.Level.DEBUG)) {
                                    logger.debug(" VM uptime %dms", ManagementFactory.getRuntimeMXBean().getUptime());
                                }
                                if (!connectionEstablished) {
                                    client.connectionEstablished();
                                }
                                connectionEstablished = true;
                            } else {
                                Agent001.disableCRS("Backend malfunction, invalid vmId received", null);
                            }
                        }

                        @Override
                        public void syncFailed(Result<String[]> result) {
                            logger.error("Data synchronization to the CRS cloud has failed: %s", result.errorString());
                        }
                    });
                    jfrMonitor = JFRMonitor.getInstance(client, Options.lifetimejfr.get());
                    jfrMonitor.start();
                    Agent001.postVMStart(l, string);
                    Agent001.heartbeatService = HeartbeatService.getInstance(client);
                    crslogMonitor.setClient(client);
                    if (vMCRSCapabilities.has(VMCRSCapability.POST_VM_LOG_EVENTS)) {
                        vmlogMonitor = VMLogMonitor.getInstance(client);
                    } else {
                        gclogMonitor = GCLogMonitor.getInstance(client, l);
                    }
                    if (vMCRSCapabilities.has(VMCRSCapability.POST_CLASS_LOAD_EVENTS)) {
                        Agent001.classLoadMonitor = ClassLoadMonitor.getInstance(client);
                    }
                    if (vMCRSCapabilities.has(VMCRSCapability.POST_FIRST_CALL_EVENTS)) {
                        Agent001.firstCallMonitor = FirstCallMonitor.getInstance(client);
                    }
                    if (vMCRSCapabilities.has(VMCRSCapability.POST_JAR_LOAD_EVENTS)) {
                        Agent001.jarLoadMonitor = JarLoadMonitor.getInstance(client);
                    }
                    if (vMCRSCapabilities.has(VMCRSCapability.POST_VM_TOOLING_EVENT)) {
                        vmToolingClient = VMToolingClient.getInstance(client);
                        vmToolingClient.setJarLoadMonitor(jarLoadMonitor);
                    }
                    client.startup();
                    Agent001.startServices(new ClientService[]{crslogMonitor, heartbeatService, vmlogMonitor, gclogMonitor, classLoadMonitor, firstCallMonitor, jarLoadMonitor, vmToolingClient});
                    flushThread = new Thread(Agent001::flushThreadMain);
                    flushThread.setDaemon(true);
                    flushThread.setName("CRSEventFlush");
                    flushThread.start();
                    Agent001.sendNetworkInformation();
                    Agent001.sendSystemInformation();
                }
                catch (Throwable throwable) {
                    Agent001.disableCRS("CRS failed to start: %s", throwable);
                }
            }
        });
        startThread.setDaemon(delayShutdown == 0L);
        startThread.setName("CRSStartThread");
        startThread.start();
    }

    private static void startServices(ClientService ... clientServiceArray) {
        for (ClientService clientService : clientServiceArray) {
            if (clientService == null) continue;
            try {
                clientService.start();
            }
            catch (Exception exception) {
                logger.error("Agent failed to start " + clientService.serviceName() + ". Data is discarded", new Object[0]);
            }
        }
    }

    private static void stopServices(long l, ClientService ... clientServiceArray) {
        for (ClientService clientService : clientServiceArray) {
            if (clientService == null) continue;
            try {
                clientService.stop(l);
            }
            catch (Exception exception) {
                logger.error("Agent failed to stop " + clientService.serviceName() + ". Data is discarded", new Object[0]);
            }
        }
    }

    private static void disableCRS(String string, Throwable throwable) {
        if (client != null) {
            client.cancel();
        }
        useCRS = -1;
        logger.error(string, throwable);
        if (throwable.getCause() != null) {
            logger.trace("caused by: %s", throwable.getCause());
        }
    }

    private static Map<Client.ClientProp, Object> getClientProps() throws CRSException {
        boolean bl;
        Map<Client.ClientProp, Object> map = Options.getClientProps();
        boolean bl2 = map.get((Object)Client.ClientProp.API_URL) != null;
        boolean bl3 = bl = map.get((Object)Client.ClientProp.API_MAILBOX) != null;
        if (!bl2 || !bl) {
            try {
                DnsDetect dnsDetect = new DnsDetect(Options.stackRecordId.get());
                Logger.getLogger(ConnectionManager.class).info("querying DNS record%s", dnsDetect.getRecordNamePostfix().length() > 0 ? " (postfix " + dnsDetect.getRecordNamePostfix() + ")" : "");
                if (!bl2) {
                    map.put(Client.ClientProp.API_URL, "https://" + dnsDetect.queryEndpoint());
                }
                if (!bl) {
                    map.put(Client.ClientProp.API_MAILBOX, dnsDetect.queryMailbox());
                }
            }
            catch (IOException iOException) {
                throw new CRSException(-1, "DNS query error and not enough configuration supplied", iOException);
            }
        }
        map.put(Client.ClientProp.VM_SHUTDOWN_DELAY, delayShutdown);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void flushThreadMain() {
        try {
            long l = Utils.currentTimeCount();
            while (true) {
                boolean bl;
                Object object = flushThreadLock;
                synchronized (object) {
                    try {
                        flushThreadLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                if (flushThreadStop) break;
                boolean bl2 = bl = Utils.elapsedTimeMillis(l) >= (long)forceFlushTimeout;
                if (bl) {
                    l = Utils.currentTimeCount();
                }
                vmSupport.drainQueues(bl, false);
            }
            vmSupport.drainQueues(true, true);
        }
        catch (Throwable throwable) {
            logger.error("Internal error or unexpected problem. CRS defunct. %s", throwable);
        }
    }

    public static void notifyToJavaCall(String string) {
        if (useCRS != 0 && useCRS != 2) {
            vmSupport.enableEventNotifications(VMSupport.CrsNotificationType.EVENT_TO_JAVA_CALL, false);
            return;
        }
        if (string.startsWith("sun/launcher/LauncherHelper.checkAndLoadMain")) {
            launcherDetected = true;
            Agent001.stateEvent(1, null);
        } else if (!launcherDetected) {
            if (string.startsWith("java/lang/Thread") || string.startsWith("sun/launcher") || string.startsWith("java/") || string.startsWith("javax/") || string.startsWith("sun/") || string.startsWith("com/sun/") || string.startsWith("com/fasterxml") || string.startsWith("org/jcp") || string.startsWith("com/azul/crs") || string.startsWith("jdk/jfr")) {
                return;
            }
            Agent001.stateEvent(3, string);
        }
    }

    public static void notifyFirstCall(int n, String string) {
        firstCallMonitor.notifyMethodFirstCalled(n, string);
    }

    public static void notifyClassLoad(String string, byte[] byArray, byte[] byArray2, int n, int n2, String string2) {
        if (jarLoadMonitor != null) {
            jarLoadMonitor.notifyClassSourceSeen(string2);
        }
        classLoadMonitor.notifyClassLoad(string, byArray, byArray2, n, n2, string2);
    }

    public static void notifyVMLogEntry(String string, String string2) {
        vmlogMonitor.notifyVMLogEntry(string, string2);
    }

    static {
        useCRS = 0;
        flushThreadLock = new Object();
        forceFlushTimeout = 1800000;
        delayShutdown = 120000L;
        logger = Logger.getLogger(Agent001.class);
        crslogMonitor = new CRSLogMonitor();
        Logger.addOutputStream(new OutputStream(){

            @Override
            public void write(int n) throws IOException {
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                crslogMonitor.notifyCRSLogEntry(byArray, n, n2);
            }
        });
        vmSupport = null;
    }

    private static final class VMCRSCapabilities {
        private final Set<VMCRSCapability> capabilities;

        private VMCRSCapabilities(Set<VMCRSCapability> set) {
            this.capabilities = Collections.unmodifiableSet(set);
            logger.trace("Active VMCRSCapabilities: " + this.capabilities, new Object[0]);
        }

        boolean has(VMCRSCapability vMCRSCapability) {
            return this.capabilities.contains((Object)vMCRSCapability);
        }

        static VMCRSCapabilities init() {
            HashSet<VMCRSCapability> hashSet = new HashSet<VMCRSCapability>();
            try {
                if (VMToolingClient.isToolingImplemented()) {
                    hashSet.add(VMCRSCapability.POST_VM_TOOLING_EVENT);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray = vmSupport.getVMCRSCapabilities();
            if (stringArray != null) {
                for (String string : stringArray) {
                    try {
                        hashSet.add(VMCRSCapability.valueOf(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.trace("VM reported unknown capability: " + string, new Object[0]);
                    }
                }
            } else {
                hashSet.addAll(Arrays.asList(VMCRSCapability.POST_CLASS_LOAD_EVENTS, VMCRSCapability.POST_JAR_LOAD_EVENTS, VMCRSCapability.POST_FIRST_CALL_EVENTS, VMCRSCapability.POST_NOTIFY_TO_JAVA_CALLS));
            }
            return new VMCRSCapabilities(hashSet);
        }
    }

    private static enum VMCRSCapability {
        POST_CLASS_LOAD_EVENTS,
        POST_FIRST_CALL_EVENTS,
        POST_NOTIFY_TO_JAVA_CALLS,
        POST_VM_LOG_EVENTS,
        POST_JAR_LOAD_EVENTS,
        POST_VM_TOOLING_EVENT;

    }
}

