/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AcceleratedScreen;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.RunnableProcessor;

public abstract class NativePlatform {
    private static InputDeviceRegistry inputDeviceRegistry;
    private final RunnableProcessor runnableProcessor = new RunnableProcessor();
    private NativeCursor cursor;
    private NativeScreen screen;
    protected AcceleratedScreen accScreen;

    protected NativePlatform() {
    }

    void shutdown() {
        this.runnableProcessor.shutdown();
        if (this.cursor != null) {
            this.cursor.shutdown();
        }
        if (this.screen != null) {
            this.screen.shutdown();
        }
    }

    RunnableProcessor getRunnableProcessor() {
        return this.runnableProcessor;
    }

    synchronized InputDeviceRegistry getInputDeviceRegistry() {
        if (inputDeviceRegistry == null) {
            inputDeviceRegistry = this.createInputDeviceRegistry();
        }
        return inputDeviceRegistry;
    }

    protected abstract InputDeviceRegistry createInputDeviceRegistry();

    protected abstract NativeCursor createCursor();

    synchronized NativeCursor getCursor() {
        if (this.cursor == null) {
            this.cursor = this.createCursor();
        }
        return this.cursor;
    }

    protected abstract NativeScreen createScreen();

    synchronized NativeScreen getScreen() {
        if (this.screen == null) {
            this.screen = this.createScreen();
        }
        return this.screen;
    }

    public synchronized AcceleratedScreen getAcceleratedScreen(int[] nArray) throws GLException, UnsatisfiedLinkError {
        if (this.accScreen == null) {
            this.accScreen = new AcceleratedScreen(nArray);
        }
        return this.accScreen;
    }
}

