/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.qupath.command;

import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import ch.epfl.biop.bdv.img.qupath.struct.MinimalQuPathProject;
import ch.epfl.biop.bdv.img.qupath.struct.ProjectIO;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Create BDV Dataset [QuPath]")
public class CreateBdvDatasetQuPathCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(CreateBdvDatasetQuPathCommand.class);
    @Parameter
    File qupath_project;
    @Parameter
    Context context;
    @Parameter(label="Dataset name (leave empty to name it like the QuPath project)", persist=false)
    public String datasetname = "";
    @Parameter(required=false, label="Physical units of the dataset", choices={"MILLIMETER", "MICROMETER", "NANOMETER"})
    public String unit = "MILLIMETER";
    @Parameter(type=ItemIO.OUTPUT)
    AbstractSpimData<?> spimData;
    @Parameter(label="Split RGB channels")
    boolean split_rgb_channels = false;
    @Parameter(required=false, label="Plane Origin Convention", choices={"CENTER", "TOP LEFT"})
    String plane_origin_convention = "CENTER";

    public void run() {
        try {
            JsonObject projectJson = ProjectIO.loadRawProject(new File(this.qupath_project.toURI()));
            Gson gson = new Gson();
            MinimalQuPathProject project = (MinimalQuPathProject)gson.fromJson((JsonElement)projectJson, MinimalQuPathProject.class);
            logger.debug("Opening QuPath project " + project.uri);
            ArrayList<OpenerSettings> openerSettingsList = new ArrayList<OpenerSettings>();
            project.images.forEach(image -> {
                OpenerSettings openerSettings = OpenerSettings.QuPath().splitRGBChannels(this.split_rgb_channels).location(this.qupath_project.getAbsolutePath()).setEntry(image.entryID).unit(this.unit).positionConvention(this.plane_origin_convention).context(this.context).quPathBuilder();
                openerSettingsList.add(openerSettings);
            });
            this.spimData = OpenersToSpimData.getSpimData(openerSettingsList);
            if (this.datasetname.isEmpty()) {
                this.datasetname = this.qupath_project.getParentFile().getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

