/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.qupath;

import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.OpenerSetupLoader;
import ch.epfl.biop.bdv.img.ResourcePool;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsOpener;
import ch.epfl.biop.bdv.img.omero.OmeroOpener;
import ch.epfl.biop.bdv.img.opener.ChannelProperties;
import ch.epfl.biop.bdv.img.opener.EmptyOpener;
import ch.epfl.biop.bdv.img.opener.Opener;
import ch.epfl.biop.bdv.img.opener.OpenerHelper;
import ch.epfl.biop.bdv.img.qupath.entity.QuPathEntryIdEntity;
import ch.epfl.biop.bdv.img.qupath.struct.MinimalQuPathProject;
import ch.epfl.biop.bdv.img.qupath.struct.ProjectIO;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.scijava.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuPathOpener<T>
implements Opener<T> {
    protected static final Logger logger = LoggerFactory.getLogger(QuPathOpener.class);
    final Opener<T> opener;
    final MinimalQuPathProject.ImageEntry image;
    final String unit;
    final int entryId;
    final Opener.OpenerMeta meta;
    boolean pyramidize = false;

    public QuPathOpener(Context context, String dataLocation, final int entryId, final String unit, boolean positionIsImageCenter, int poolSize, boolean useDefaultXYBlockSize, int[] cacheBlockSize, boolean splitRGBChannels, Map<String, Object> cachedObjects, int defaultNumberOfChannels, boolean skipMeta) throws UnsupportedOperationException {
        MinimalQuPathProject project = OpenerHelper.memoize("opener.qupath.project." + dataLocation, cachedObjects, () -> QuPathOpener.getQuPathProject(context, dataLocation));
        this.unit = unit;
        this.entryId = entryId;
        HashMap idToImage = new HashMap();
        project.images.forEach(server -> idToImage.put(server.entryID, server));
        if (!idToImage.containsKey(entryId)) {
            logger.error("Entry " + entryId + " not found! You've probably deleted an entry in the QuPath. Let's try to deal with it the best we can...");
            this.image = new MinimalQuPathProject.EmptyImageEntry(entryId, defaultNumberOfChannels);
        } else {
            this.image = (MinimalQuPathProject.ImageEntry)idToImage.get(entryId);
        }
        MinimalQuPathProject.ServerBuilderEntry mostInnerBuilder = this.image.serverBuilder;
        while (mostInnerBuilder.builderType.equals("rotated") || mostInnerBuilder.builderType.equals("pyramidize")) {
            if (mostInnerBuilder.builderType.equals("pyramidize")) {
                this.setPyramidize(true);
            }
            MinimalQuPathProject.PixelCalibrations pixelCalibration = null;
            if (mostInnerBuilder.metadata != null) {
                pixelCalibration = mostInnerBuilder.metadata.pixelCalibration;
            }
            mostInnerBuilder = mostInnerBuilder.builder;
            if (pixelCalibration == null || mostInnerBuilder.metadata == null) continue;
            mostInnerBuilder.metadata.pixelCalibration = pixelCalibration;
        }
        if (mostInnerBuilder.builderType.equals("Empty")) {
            logger.error("Empty image server!");
            this.opener = new EmptyOpener("Entry " + entryId, defaultNumberOfChannels, "Error, entry " + entryId + " missing!", false);
        } else if (mostInnerBuilder.builderType.equals("uri")) {
            logger.debug("URI image server");
            try {
                logger.debug("provided class name : " + mostInnerBuilder.providerClassName);
                if (mostInnerBuilder.providerClassName.equals("qupath.lib.images.servers.bioformats.BioFormatsServerBuilder")) {
                    URI uri = new URI(mostInnerBuilder.uri.getScheme(), mostInnerBuilder.uri.getHost(), mostInnerBuilder.uri.getPath(), null);
                    String filePath = Paths.get(uri).toString();
                    if (!new File(filePath).exists()) {
                        String multiLinePath = filePath.replace(File.separator, "\n\t\\");
                        throw new UnsupportedOperationException("Please fix URIs in QuPath.\nFile not found:\n " + multiLinePath);
                    }
                    int idxSeriesK = mostInnerBuilder.args.indexOf("--series");
                    int idxSeriesV = idxSeriesK + 1;
                    ArrayList<String> filteredArgs = new ArrayList<String>(mostInnerBuilder.args);
                    filteredArgs.remove(idxSeriesK);
                    filteredArgs.remove(idxSeriesK);
                    String joinedArgs = String.join((CharSequence)" ", filteredArgs);
                    this.opener = new BioFormatsOpener(context, filePath, Integer.parseInt(mostInnerBuilder.args.get(idxSeriesV)), new AffineTransform3D().getRowPackedCopy(), new AffineTransform3D().getRowPackedCopy(), positionIsImageCenter, new Length((Number)1, UNITS.MICROMETER), new Length((Number)1, UNITS.MICROMETER), unit, poolSize, useDefaultXYBlockSize, cacheBlockSize, splitRGBChannels, cachedObjects, defaultNumberOfChannels, skipMeta, false, joinedArgs);
                    logger.debug("BioFormats Opener for image " + this.image.imageName);
                }
                if (mostInnerBuilder.providerClassName.equals("qupath.ext.biop.servers.omero.raw.OmeroRawImageServerBuilder")) {
                    this.opener = new OmeroOpener(context, URLDecoder.decode(mostInnerBuilder.uri.toString(), "UTF-8"), poolSize, unit, positionIsImageCenter, cachedObjects, defaultNumberOfChannels, skipMeta);
                    logger.debug("OMERO-RAW Opener (BIOP) for image " + this.image.imageName);
                }
                if (mostInnerBuilder.providerClassName.equals("qupath.ext.omero.core.imageserver.OmeroImageServerBuilder")) {
                    if (!mostInnerBuilder.args.contains("Ice")) {
                        throw new UnsupportedOperationException("Unsupported " + mostInnerBuilder.providerClassName + " because it is not using the Ice API");
                    }
                    this.opener = new OmeroOpener(context, URLDecoder.decode(mostInnerBuilder.uri.toString(), "UTF-8"), poolSize, unit, positionIsImageCenter, cachedObjects, defaultNumberOfChannels, skipMeta);
                    logger.debug("OMERO-ICE Opener for image " + this.image.imageName);
                }
                throw new UnsupportedOperationException("Unsupported " + mostInnerBuilder.providerClassName + " provider Class Name");
            }
            catch (Exception e) {
                logger.error("URI Syntax error " + e.getMessage());
                e.printStackTrace();
                throw new UnsupportedOperationException(e.getMessage());
            }
        } else {
            throw new UnsupportedOperationException("Unsupported " + this.image.serverBuilder.builderType + " server builder");
        }
        this.meta = !skipMeta ? new Opener.OpenerMeta(){

            @Override
            public String getImageName() {
                return QuPathOpener.this.image.imageName;
            }

            @Override
            public ChannelProperties getChannel(int iChannel) {
                if (QuPathOpener.this.image.serverBuilder != null && QuPathOpener.this.image.serverBuilder.metadata != null && QuPathOpener.this.image.serverBuilder.metadata.channels != null) {
                    if (QuPathOpener.this.image.serverBuilder.metadata.isRGB) {
                        if (QuPathOpener.this.opener.getPixelType() instanceof ARGBType) {
                            return QuPathOpener.this.opener.getMeta().getChannel(iChannel).setChannelName("RGB");
                        }
                        MinimalQuPathProject.ChannelInfo channel = QuPathOpener.this.image.serverBuilder.metadata.channels.get(iChannel);
                        return QuPathOpener.this.opener.getMeta().getChannel(iChannel).setChannelName(channel.name).setChannelColor(channel.color);
                    }
                    MinimalQuPathProject.ChannelInfo channel = QuPathOpener.this.image.serverBuilder.metadata.channels.get(iChannel);
                    return QuPathOpener.this.opener.getMeta().getChannel(iChannel).setChannelName(channel.name).setChannelColor(channel.color);
                }
                return QuPathOpener.this.opener.getMeta().getChannel(iChannel);
            }

            @Override
            public List<Entity> getEntities(int iChannel) {
                ArrayList<Entity> entities = new ArrayList<Entity>();
                QuPathEntryIdEntity entry = new QuPathEntryIdEntity(entryId);
                entities.add(entry);
                return entities;
            }

            @Override
            public AffineTransform3D getTransform() {
                if (QuPathOpener.this.image.serverBuilder != null && QuPathOpener.this.image.serverBuilder.metadata != null && QuPathOpener.this.image.serverBuilder.metadata.pixelCalibration != null) {
                    MinimalQuPathProject.PixelCalibrations pixelCalibration = QuPathOpener.this.image.serverBuilder.metadata.pixelCalibration;
                    return QuPathOpener.getTransform(pixelCalibration, unit, QuPathOpener.this.opener.getMeta().getTransform(), QuPathOpener.this.opener.getVoxelDimensions());
                }
                return QuPathOpener.this.opener.getMeta().getTransform();
            }
        } : null;
    }

    private void setPyramidize(boolean pyramidize) {
        this.pyramidize = pyramidize;
    }

    public boolean getPyramidize() {
        return this.pyramidize;
    }

    public static MinimalQuPathProject getQuPathProject(Context ctx, String dataLocation) {
        try {
            File quPathProject = new File(dataLocation);
            JsonObject projectJson = ProjectIO.loadRawProject(new File(quPathProject.toURI()));
            return (MinimalQuPathProject)new Gson().fromJson((JsonElement)projectJson, MinimalQuPathProject.class);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private static double getAngleRotationZAxis(MinimalQuPathProject.ImageEntry image) {
        String angleDegreesStr = image.serverBuilder.rotation.substring(7);
        logger.debug("Rotated image server (" + angleDegreesStr + ")");
        double angleRotationZAxis = angleDegreesStr.equals("NONE") ? 0.0 : Double.parseDouble(angleDegreesStr) / 180.0 * Math.PI;
        MinimalQuPathProject.ServerBuilderMetadata metadata = image.serverBuilder.metadata;
        image.serverBuilder = image.serverBuilder.builder;
        image.serverBuilder.metadata = metadata;
        return angleRotationZAxis;
    }

    private static AffineTransform3D getTransform(MinimalQuPathProject.PixelCalibrations pixelCalibrations, String outputUnit, AffineTransform3D rootTransform, VoxelDimensions voxSizes) {
        AffineTransform3D quPathRescaling = new AffineTransform3D();
        if (pixelCalibrations != null) {
            Length defaultxPix;
            MinimalQuPathProject.PixelCalibration pc;
            double scaleX = 1.0;
            double scaleY = 1.0;
            double scaleZ = 1.0;
            double voxSizeX = voxSizes.dimension(0);
            double voxSizeY = voxSizes.dimension(1);
            double voxSizeZ = voxSizes.dimension(2);
            if (pixelCalibrations.pixelWidth != null) {
                pc = pixelCalibrations.pixelWidth;
                Length voxLengthX = new Length((Number)voxSizeX, BioFormatsHelper.getUnitFromString(voxSizes.unit()));
                if (voxLengthX.value(UNITS.MICROMETER) != null) {
                    logger.debug("xVox size = " + pc.value + " micrometer");
                    scaleX = pc.value / voxLengthX.value(UNITS.MICROMETER).doubleValue();
                } else {
                    defaultxPix = new Length((Number)1, BioFormatsHelper.getUnitFromString(outputUnit));
                    scaleX = pc.value / defaultxPix.value(UNITS.MICROMETER).doubleValue();
                    logger.debug("rescaling x");
                }
            }
            if (pixelCalibrations.pixelHeight != null) {
                pc = pixelCalibrations.pixelHeight;
                Length voxLengthY = new Length((Number)voxSizeY, BioFormatsHelper.getUnitFromString(voxSizes.unit()));
                if (voxLengthY.value(UNITS.MICROMETER) != null) {
                    logger.debug("yVox size = " + pc.value + " micrometer");
                    scaleY = pc.value / voxLengthY.value(UNITS.MICROMETER).doubleValue();
                } else {
                    defaultxPix = new Length((Number)1, BioFormatsHelper.getUnitFromString(outputUnit));
                    scaleY = pc.value / defaultxPix.value(UNITS.MICROMETER).doubleValue();
                    logger.debug("rescaling y");
                }
            }
            if (pixelCalibrations.zSpacing != null) {
                pc = pixelCalibrations.zSpacing;
                Length voxLengthZ = new Length((Number)voxSizeZ, BioFormatsHelper.getUnitFromString(voxSizes.unit()));
                if (voxLengthZ.value(UNITS.MICROMETER) != null) {
                    logger.debug("zVox size = " + pc.value + " micrometer");
                    scaleZ = pc.value / voxLengthZ.value(UNITS.MICROMETER).doubleValue();
                } else {
                    logger.warn("Null Z voxel size");
                }
            }
            logger.debug("ScaleX: " + scaleX + " scaleY:" + scaleY + " scaleZ:" + scaleZ);
            double finalScalex = scaleX;
            double finalScaley = scaleY;
            double finalScalez = scaleZ;
            if (Math.abs(finalScalex - 1.0) > 1.0E-4 || Math.abs(finalScaley - 1.0) > 1.0E-4 || Math.abs(finalScalez - 1.0) > 1.0E-4) {
                logger.debug("Perform QuPath rescaling");
                quPathRescaling.scale(finalScalex, finalScaley, finalScalez);
                double oX = rootTransform.get(0, 3);
                double oY = rootTransform.get(1, 3);
                double oZ = rootTransform.get(2, 3);
                rootTransform.preConcatenate(quPathRescaling);
                rootTransform.set(oX, 0, 3);
                rootTransform.set(oY, 1, 3);
                rootTransform.set(oZ, 2, 3);
            }
        }
        return rootTransform;
    }

    private static Unit<Length> convertStringToUnit(String unitString) {
        switch (unitString) {
            case "\u00b5m": {
                return UNITS.MICROMETER;
            }
            case "mm": {
                return UNITS.MILLIMETER;
            }
            case "cm": {
                return UNITS.CENTIMETER;
            }
            case "px": {
                return UNITS.PIXEL;
            }
        }
        return UNITS.REFERENCEFRAME;
    }

    public static VoxelDimensions getVoxelDimensions(MinimalQuPathProject.PixelCalibrations pixelCalibrations, String unit) {
        final int numDimensions = 3;
        Length[] voxSize = new Length[]{new Length((Number)pixelCalibrations.pixelWidth.value, QuPathOpener.convertStringToUnit(pixelCalibrations.pixelWidth.unit)), new Length((Number)pixelCalibrations.pixelHeight.value, QuPathOpener.convertStringToUnit(pixelCalibrations.pixelHeight.unit)), new Length((Number)pixelCalibrations.zSpacing.value, QuPathOpener.convertStringToUnit(pixelCalibrations.zSpacing.unit))};
        final double[] d = new double[3];
        final Unit<Length> u = BioFormatsHelper.getUnitFromString(unit);
        Length voxSizeReferenceFrameLength = new Length((Number)1, UNITS.MICROMETER);
        for (int iDimension = 0; iDimension < 3; ++iDimension) {
            if (voxSize[iDimension].unit() != null && voxSize[iDimension].unit().isConvertible(u).booleanValue()) {
                d[iDimension] = voxSize[iDimension].value(u).doubleValue();
                continue;
            }
            if (voxSize[iDimension].unit().getSymbol().equals("reference frame")) {
                Length l = new Length((Number)(voxSize[iDimension].value().doubleValue() * voxSizeReferenceFrameLength.value().doubleValue()), voxSizeReferenceFrameLength.unit());
                d[iDimension] = l.value(u).doubleValue();
                continue;
            }
            d[iDimension] = 1.0;
        }
        assert (numDimensions == 3);
        VoxelDimensions voxelDimensions = new VoxelDimensions(){
            final Unit<Length> targetUnit;
            final double[] dims;
            {
                this.targetUnit = u;
                this.dims = new double[]{d[0], d[1], d[2]};
            }

            public String unit() {
                return this.targetUnit.getSymbol();
            }

            public void dimensions(double[] doubles) {
                doubles[0] = this.dims[0];
                doubles[1] = this.dims[1];
                doubles[2] = this.dims[2];
            }

            public double dimension(int i) {
                return this.dims[i];
            }

            public int numDimensions() {
                return numDimensions;
            }
        };
        return voxelDimensions;
    }

    @Override
    public int[] getCellDimensions(int level) {
        return this.opener.getCellDimensions(level);
    }

    @Override
    public Dimensions[] getDimensions() {
        return this.opener.getDimensions();
    }

    @Override
    public int getNChannels() {
        return this.opener.getNChannels();
    }

    @Override
    public int getNTimePoints() {
        return this.opener.getNTimePoints();
    }

    @Override
    public int getNumMipmapLevels() {
        return this.opener.getNumMipmapLevels();
    }

    @Override
    public ResourcePool<T> getPixelReader() {
        return this.opener.getPixelReader();
    }

    @Override
    public Type<? extends NumericType<?>> getPixelType() {
        return this.opener.getPixelType();
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        if (this.image.serverBuilder != null && this.image.serverBuilder.metadata != null && this.image.serverBuilder.metadata.pixelCalibration != null) {
            return QuPathOpener.getVoxelDimensions(this.image.serverBuilder.metadata.pixelCalibration, this.unit);
        }
        return this.opener.getVoxelDimensions();
    }

    @Override
    public boolean isLittleEndian() {
        return this.opener.isLittleEndian();
    }

    @Override
    public String getImageFormat() {
        return this.opener.getImageFormat();
    }

    @Override
    public OpenerSetupLoader<?, ?, ?> getSetupLoader(int channelIdx, int setupIdx, Supplier<VolatileGlobalCellCache> cacheSupplier) {
        return this.opener.getSetupLoader(channelIdx, setupIdx, cacheSupplier);
    }

    @Override
    public String getRawPixelDataKey() {
        return this.opener.getRawPixelDataKey();
    }

    @Override
    public Opener.OpenerMeta getMeta() {
        return this.meta;
    }

    @Override
    public void close() throws IOException {
        this.opener.close();
    }
}

