/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.pyramidize;

import bdv.img.cache.CacheArrayLoader;
import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.OpenerSetupLoader;
import ch.epfl.biop.bdv.img.opener.OpenerHelper;
import ch.epfl.biop.bdv.img.pyramidize.PyramidizeArrayLoaders;
import ch.epfl.biop.bdv.img.pyramidize.PyramidizeOpener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;

public class PyramidizeSetupLoader<T extends NumericType<T> & NativeType<T>, V extends Volatile<T> & NativeType<V>, A extends DataAccess & ArrayDataAccess<A>>
extends OpenerSetupLoader<T, V, A> {
    final PyramidizeOpener<?> opener;
    final Supplier<VolatileGlobalCellCache> cacheSupplier;
    final OpenerSetupLoader<T, V, A> level0SetupLoader;
    final AffineTransform3D[] ats;
    final double[][] mmResolutions;
    final int setup;
    List<List<RandomAccessibleInterval<T>>> raiTL = new ArrayList<List<RandomAccessibleInterval<T>>>();
    List<List<RandomAccessibleInterval<V>>> raiTLV = new ArrayList<List<RandomAccessibleInterval<V>>>();
    volatile boolean hasBeenInitialised = false;

    protected PyramidizeSetupLoader(PyramidizeOpener<?> opener, int channelIdx, int setupIdx, Supplier<VolatileGlobalCellCache> cacheSupplier) {
        super((NumericType)opener.getPixelType(), OpenerHelper.getVolatileOf((NumericType)opener.getPixelType()));
        this.opener = opener;
        this.cacheSupplier = cacheSupplier;
        this.setup = setupIdx;
        this.level0SetupLoader = opener.getOrigin().getSetupLoader(channelIdx, setupIdx, cacheSupplier);
        this.ats = new AffineTransform3D[opener.getNumMipmapLevels()];
        this.ats[0] = this.level0SetupLoader.getMipmapTransforms()[0];
        double[] tr = this.ats[0].getTranslation();
        for (int level = 1; level < opener.nResolutionLevels; ++level) {
            AffineTransform3D transform = new AffineTransform3D();
            transform.translate(new double[]{-tr[0], -tr[1], -tr[2]});
            transform.scale(Math.pow(2.0, level), Math.pow(2.0, level), 1.0);
            transform.translate(tr);
            this.ats[level] = transform;
        }
        this.mmResolutions = new double[opener.nResolutionLevels][3];
        this.mmResolutions[0][0] = 1.0;
        this.mmResolutions[0][1] = 1.0;
        this.mmResolutions[0][2] = 1.0;
        for (int iLevel = 1; iLevel < opener.nResolutionLevels; ++iLevel) {
            double downscalingFactor;
            this.mmResolutions[iLevel][0] = downscalingFactor = Math.pow(2.0, iLevel);
            this.mmResolutions[iLevel][1] = downscalingFactor;
            this.mmResolutions[iLevel][2] = 1.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInitialisation() {
        if (this.hasBeenInitialised) {
            return;
        }
        PyramidizeSetupLoader pyramidizeSetupLoader = this;
        synchronized (pyramidizeSetupLoader) {
            PyramidizeArrayLoaders.PyramidizeArrayLoader loader;
            if (this.hasBeenInitialised) {
                return;
            }
            NumericType t = (NumericType)this.opener.getPixelType();
            if (t instanceof UnsignedByteType) {
                loader = new PyramidizeArrayLoaders.PyramidizeByteArrayLoader(this);
            } else if (t instanceof UnsignedShortType) {
                loader = new PyramidizeArrayLoaders.PyramidizeShortArrayLoader(this);
            } else if (t instanceof FloatType) {
                loader = new PyramidizeArrayLoaders.PyramidizeFloatArrayLoader(this);
            } else if (t instanceof IntType) {
                loader = new PyramidizeArrayLoaders.PyramidizeIntArrayLoader(this);
            } else if (t instanceof ARGBType) {
                loader = new PyramidizeArrayLoaders.PyramidizeARGBArrayLoader(this);
            } else {
                throw new UnsupportedOperationException("Pixel type " + t.getClass().getName() + " unsupported in " + PyramidizeSetupLoader.class.getName());
            }
            for (int tp = 0; tp < this.opener.getNTimePoints(); ++tp) {
                this.raiTL.add(new ArrayList());
                this.raiTLV.add(new ArrayList());
                for (int level = 1; level < this.opener.nResolutionLevels; ++level) {
                    int tileSizeLevel = PyramidizeOpener.tileSize(level);
                    int[] cellDimensions = new int[]{tileSizeLevel, tileSizeLevel, 1};
                    RandomAccessibleInterval<T> raiBelow = level == 1 ? this.getImage(tp, 0, new ImgLoaderHint[0]) : this.raiTL.get(tp).get(level - 2);
                    long[] newDimensions = new long[]{raiBelow.dimensionsAsLongArray()[0] / 2L, raiBelow.dimensionsAsLongArray()[1] / 2L, raiBelow.dimensionsAsLongArray()[2]};
                    CellGrid grid = new CellGrid(newDimensions, cellDimensions);
                    int priority = this.opener.nResolutionLevels - level;
                    CacheHints cacheHints = new CacheHints(LoadingStrategy.BLOCKING, priority, false);
                    this.raiTL.get(tp).add((RandomAccessibleInterval<T>)this.cacheSupplier.get().createImg(grid, tp, this.setup, level, cacheHints, (CacheArrayLoader)loader, (NativeType)this.type));
                    priority = this.opener.nResolutionLevels - level;
                    cacheHints = new CacheHints(LoadingStrategy.BUDGETED, priority, false);
                    this.raiTLV.get(tp).add((RandomAccessibleInterval<V>)this.cacheSupplier.get().createImg(grid, tp, this.setup, level, cacheHints, (CacheArrayLoader)loader, (NativeType)this.volatileType));
                }
            }
            this.hasBeenInitialised = true;
            ((PyramidizeArrayLoaders.PyramidizeArrayLoader)loader).init();
        }
    }

    public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
        if (level == 0) {
            return this.level0SetupLoader.getVolatileImage(timepointId, level, hints);
        }
        this.ensureInitialisation();
        return this.raiTLV.get(timepointId).get(level - 1);
    }

    public Dimensions getImageSize(int timepointId, int level) {
        return this.opener.getDimensions()[level];
    }

    public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
        if (level == 0) {
            return this.level0SetupLoader.getImage(timepointId, level, hints);
        }
        this.ensureInitialisation();
        return this.raiTL.get(timepointId).get(level - 1);
    }

    public double[][] getMipmapResolutions() {
        return this.mmResolutions;
    }

    public AffineTransform3D[] getMipmapTransforms() {
        return this.ats;
    }

    public int numMipmapLevels() {
        return this.opener.getNumMipmapLevels();
    }

    public VoxelDimensions getVoxelSize(int timepointId) {
        return this.opener.getVoxelDimensions();
    }
}

