/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.pyramidize;

import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.OpenerSetupLoader;
import ch.epfl.biop.bdv.img.ResourcePool;
import ch.epfl.biop.bdv.img.opener.Opener;
import ch.epfl.biop.bdv.img.pyramidize.PyramidizeSetupLoader;
import java.io.IOException;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;

public class PyramidizeOpener<T>
implements Opener<T> {
    final Opener<T> origin;
    final int nResolutionLevels;
    Dimensions[] dimensions;

    public PyramidizeOpener(Opener<T> origin) {
        int nResolutionLevels;
        this.origin = origin;
        long maxX = origin.getDimensions()[0].dimension(0);
        long maxY = origin.getDimensions()[0].dimension(1);
        for (nResolutionLevels = 1; nResolutionLevels < 6 && maxX > 64L && maxY > 64L; ++nResolutionLevels) {
            maxX = (long)((double)maxX / 2.0);
            maxY = (long)((double)maxY / 2.0);
        }
        this.nResolutionLevels = nResolutionLevels;
        this.dimensions = new Dimensions[nResolutionLevels];
        this.dimensions[0] = origin.getDimensions()[0];
        long currentDimX = this.dimensions[0].dimension(0);
        long currentDimY = this.dimensions[0].dimension(1);
        long currentDimZ = this.dimensions[0].dimension(2);
        for (int level = 1; level < nResolutionLevels; ++level) {
            this.dimensions[level] = PyramidizeOpener.getDimension(currentDimX /= 2L, currentDimY /= 2L, currentDimZ);
        }
    }

    static int tileSize(int level) {
        return (int)Math.pow(2.0, 8 - level);
    }

    protected Opener<T> getOrigin() {
        return this.origin;
    }

    @Override
    public int[] getCellDimensions(int level) {
        if (level == 0) {
            return this.origin.getCellDimensions(0);
        }
        int tileSize = PyramidizeOpener.tileSize(level);
        return new int[]{tileSize, tileSize, 1};
    }

    @Override
    public Dimensions[] getDimensions() {
        return this.dimensions;
    }

    @Override
    public int getNChannels() {
        return this.origin.getNChannels();
    }

    @Override
    public int getNTimePoints() {
        return this.origin.getNTimePoints();
    }

    @Override
    public int getNumMipmapLevels() {
        return this.nResolutionLevels;
    }

    @Override
    public ResourcePool<T> getPixelReader() {
        return this.origin.getPixelReader();
    }

    @Override
    public Type<? extends NumericType<?>> getPixelType() {
        return this.origin.getPixelType();
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return this.origin.getVoxelDimensions();
    }

    @Override
    public boolean isLittleEndian() {
        return this.origin.isLittleEndian();
    }

    @Override
    public String getImageFormat() {
        return this.origin.getImageFormat();
    }

    @Override
    public OpenerSetupLoader<?, ?, ?> getSetupLoader(int channelIdx, int setupIdx, Supplier<VolatileGlobalCellCache> cacheSupplier) {
        return new PyramidizeSetupLoader(this, channelIdx, setupIdx, cacheSupplier);
    }

    @Override
    public String getRawPixelDataKey() {
        return this.origin.getRawPixelDataKey() + ".pyramid";
    }

    @Override
    public Opener.OpenerMeta getMeta() {
        return this.origin.getMeta();
    }

    @Override
    public void close() throws IOException {
        this.origin.close();
    }

    static Dimensions getDimension(final long sizeX, final long sizeY, final long sizeZ) {
        return new Dimensions(){

            public long dimension(int d) {
                if (d == 0) {
                    return sizeX;
                }
                if (d == 1) {
                    return sizeY;
                }
                return sizeZ;
            }

            public int numDimensions() {
                return 3;
            }
        };
    }
}

