/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.pyramidize;

import bdv.img.cache.CacheArrayLoader;
import ch.epfl.biop.bdv.img.pyramidize.PyramidizeSetupLoader;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class PyramidizeArrayLoaders {

    protected static class PyramidizeARGBArrayLoader
    extends PyramidizeArrayLoader
    implements CacheArrayLoader<VolatileIntArray> {
        final List<List<RandomAccessibleInterval<ARGBType>>> rais00 = new ArrayList<List<RandomAccessibleInterval<ARGBType>>>();
        final List<List<RandomAccessibleInterval<ARGBType>>> rais01 = new ArrayList<List<RandomAccessibleInterval<ARGBType>>>();
        final List<List<RandomAccessibleInterval<ARGBType>>> rais10 = new ArrayList<List<RandomAccessibleInterval<ARGBType>>>();
        final List<List<RandomAccessibleInterval<ARGBType>>> rais11 = new ArrayList<List<RandomAccessibleInterval<ARGBType>>>();

        protected PyramidizeARGBArrayLoader(PyramidizeSetupLoader psl) {
            super(psl);
        }

        @Override
        void init() {
            for (int tp = 0; tp < this.psl.opener.getNTimePoints(); ++tp) {
                this.rais00.add(new ArrayList());
                this.rais01.add(new ArrayList());
                this.rais10.add(new ArrayList());
                this.rais11.add(new ArrayList());
                for (int level = 1; level < this.psl.numMipmapLevels(); ++level) {
                    IntervalView rai = Views.expandBorder(this.psl.getImage(tp, level - 1, new ImgLoaderHint[0]), (long[])new long[]{1L, 1L, 0L});
                    this.rais00.get(tp).add((RandomAccessibleInterval<ARGBType>)Views.subsample((RandomAccessibleInterval)rai, (long[])new long[]{2L, 2L, 1L}));
                    this.rais01.get(tp).add((RandomAccessibleInterval<ARGBType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 0L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais10.get(tp).add((RandomAccessibleInterval<ARGBType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{0L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais11.get(tp).add((RandomAccessibleInterval<ARGBType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                }
            }
        }

        public VolatileIntArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) {
            assert (dimensions[2] == 1);
            FinalInterval cell = Intervals.createMinSize((long[])new long[]{min[0], min[1], min[2], dimensions[0], dimensions[1], dimensions[2]});
            Cursor c00 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais00.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c01 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais01.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c10 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais10.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c11 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais11.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            int nElements = dimensions[0] * dimensions[1] * dimensions[2];
            int[] ints = new int[nElements];
            int idx = 0;
            while (c00.hasNext()) {
                int v00 = ((ARGBType)c00.next()).get();
                int v01 = ((ARGBType)c01.next()).get();
                int v10 = ((ARGBType)c10.next()).get();
                int v11 = ((ARGBType)c11.next()).get();
                ints[idx] = ARGBType.rgba((int)((ARGBType.red((int)v00) + ARGBType.red((int)v10) + ARGBType.red((int)v01) + ARGBType.red((int)v11)) / 4), (int)((ARGBType.green((int)v00) + ARGBType.green((int)v10) + ARGBType.green((int)v01) + ARGBType.green((int)v11)) / 4), (int)((ARGBType.blue((int)v00) + ARGBType.blue((int)v10) + ARGBType.blue((int)v01) + ARGBType.blue((int)v11)) / 4), (int)((ARGBType.alpha((int)v00) + ARGBType.alpha((int)v10) + ARGBType.alpha((int)v01) + ARGBType.alpha((int)v11)) / 4));
                ++idx;
            }
            return new VolatileIntArray(ints, true);
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    protected static class PyramidizeIntArrayLoader
    extends PyramidizeArrayLoader
    implements CacheArrayLoader<VolatileIntArray> {
        final List<List<RandomAccessibleInterval<IntType>>> rais00 = new ArrayList<List<RandomAccessibleInterval<IntType>>>();
        final List<List<RandomAccessibleInterval<IntType>>> rais01 = new ArrayList<List<RandomAccessibleInterval<IntType>>>();
        final List<List<RandomAccessibleInterval<IntType>>> rais10 = new ArrayList<List<RandomAccessibleInterval<IntType>>>();
        final List<List<RandomAccessibleInterval<IntType>>> rais11 = new ArrayList<List<RandomAccessibleInterval<IntType>>>();

        protected PyramidizeIntArrayLoader(PyramidizeSetupLoader psl) {
            super(psl);
        }

        @Override
        void init() {
            for (int tp = 0; tp < this.psl.opener.getNTimePoints(); ++tp) {
                this.rais00.add(new ArrayList());
                this.rais01.add(new ArrayList());
                this.rais10.add(new ArrayList());
                this.rais11.add(new ArrayList());
                for (int level = 1; level < this.psl.numMipmapLevels(); ++level) {
                    IntervalView rai = Views.expandBorder(this.psl.getImage(tp, level - 1, new ImgLoaderHint[0]), (long[])new long[]{1L, 1L, 0L});
                    this.rais00.get(tp).add((RandomAccessibleInterval<IntType>)Views.subsample((RandomAccessibleInterval)rai, (long[])new long[]{2L, 2L, 1L}));
                    this.rais01.get(tp).add((RandomAccessibleInterval<IntType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 0L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais10.get(tp).add((RandomAccessibleInterval<IntType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{0L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais11.get(tp).add((RandomAccessibleInterval<IntType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                }
            }
        }

        public VolatileIntArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) {
            assert (dimensions[2] == 1);
            FinalInterval cell = Intervals.createMinSize((long[])new long[]{min[0], min[1], min[2], dimensions[0], dimensions[1], dimensions[2]});
            Cursor c00 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais00.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c01 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais01.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c10 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais10.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c11 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais11.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            int nElements = dimensions[0] * dimensions[1] * dimensions[2];
            int[] ints = new int[nElements];
            int idx = 0;
            while (c00.hasNext()) {
                ints[idx] = (((IntType)c00.next()).get() + ((IntType)c01.next()).get() + ((IntType)c10.next()).get() + ((IntType)c11.next()).get()) / 4;
                ++idx;
            }
            return new VolatileIntArray(ints, true);
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    protected static class PyramidizeFloatArrayLoader
    extends PyramidizeArrayLoader
    implements CacheArrayLoader<VolatileFloatArray> {
        final List<List<RandomAccessibleInterval<FloatType>>> rais00 = new ArrayList<List<RandomAccessibleInterval<FloatType>>>();
        final List<List<RandomAccessibleInterval<FloatType>>> rais01 = new ArrayList<List<RandomAccessibleInterval<FloatType>>>();
        final List<List<RandomAccessibleInterval<FloatType>>> rais10 = new ArrayList<List<RandomAccessibleInterval<FloatType>>>();
        final List<List<RandomAccessibleInterval<FloatType>>> rais11 = new ArrayList<List<RandomAccessibleInterval<FloatType>>>();

        protected PyramidizeFloatArrayLoader(PyramidizeSetupLoader psl) {
            super(psl);
        }

        @Override
        void init() {
            for (int tp = 0; tp < this.psl.opener.getNTimePoints(); ++tp) {
                this.rais00.add(new ArrayList());
                this.rais01.add(new ArrayList());
                this.rais10.add(new ArrayList());
                this.rais11.add(new ArrayList());
                for (int level = 1; level < this.psl.numMipmapLevels(); ++level) {
                    IntervalView rai = Views.expandBorder(this.psl.getImage(tp, level - 1, new ImgLoaderHint[0]), (long[])new long[]{1L, 1L, 0L});
                    this.rais00.get(tp).add((RandomAccessibleInterval<FloatType>)Views.subsample((RandomAccessibleInterval)rai, (long[])new long[]{2L, 2L, 1L}));
                    this.rais01.get(tp).add((RandomAccessibleInterval<FloatType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 0L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais10.get(tp).add((RandomAccessibleInterval<FloatType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{0L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais11.get(tp).add((RandomAccessibleInterval<FloatType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                }
            }
        }

        public VolatileFloatArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) {
            assert (dimensions[2] == 1);
            FinalInterval cell = Intervals.createMinSize((long[])new long[]{min[0], min[1], min[2], dimensions[0], dimensions[1], dimensions[2]});
            Cursor c00 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais00.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c01 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais01.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c10 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais10.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c11 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais11.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            int nElements = dimensions[0] * dimensions[1] * dimensions[2];
            float[] floats = new float[nElements];
            int idx = 0;
            while (c00.hasNext()) {
                floats[idx] = (((FloatType)c00.next()).get() + ((FloatType)c01.next()).get() + ((FloatType)c10.next()).get() + ((FloatType)c11.next()).get()) / 4.0f;
                ++idx;
            }
            return new VolatileFloatArray(floats, true);
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    protected static class PyramidizeShortArrayLoader
    extends PyramidizeArrayLoader
    implements CacheArrayLoader<VolatileShortArray> {
        final List<List<RandomAccessibleInterval<UnsignedShortType>>> rais00 = new ArrayList<List<RandomAccessibleInterval<UnsignedShortType>>>();
        final List<List<RandomAccessibleInterval<UnsignedShortType>>> rais01 = new ArrayList<List<RandomAccessibleInterval<UnsignedShortType>>>();
        final List<List<RandomAccessibleInterval<UnsignedShortType>>> rais10 = new ArrayList<List<RandomAccessibleInterval<UnsignedShortType>>>();
        final List<List<RandomAccessibleInterval<UnsignedShortType>>> rais11 = new ArrayList<List<RandomAccessibleInterval<UnsignedShortType>>>();

        protected PyramidizeShortArrayLoader(PyramidizeSetupLoader psl) {
            super(psl);
        }

        @Override
        void init() {
            for (int tp = 0; tp < this.psl.opener.getNTimePoints(); ++tp) {
                this.rais00.add(new ArrayList());
                this.rais01.add(new ArrayList());
                this.rais10.add(new ArrayList());
                this.rais11.add(new ArrayList());
                for (int level = 1; level < this.psl.numMipmapLevels(); ++level) {
                    IntervalView rai = Views.expandBorder(this.psl.getImage(tp, level - 1, new ImgLoaderHint[0]), (long[])new long[]{1L, 1L, 0L});
                    this.rais00.get(tp).add((RandomAccessibleInterval<UnsignedShortType>)Views.subsample((RandomAccessibleInterval)rai, (long[])new long[]{2L, 2L, 1L}));
                    this.rais01.get(tp).add((RandomAccessibleInterval<UnsignedShortType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 0L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais10.get(tp).add((RandomAccessibleInterval<UnsignedShortType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{0L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais11.get(tp).add((RandomAccessibleInterval<UnsignedShortType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                }
            }
        }

        public VolatileShortArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) {
            assert (dimensions[2] == 1);
            FinalInterval cell = Intervals.createMinSize((long[])new long[]{min[0], min[1], min[2], dimensions[0], dimensions[1], dimensions[2]});
            Cursor c00 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais00.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c01 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais01.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c10 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais10.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c11 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais11.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            int nElements = dimensions[0] * dimensions[1] * dimensions[2];
            short[] shorts = new short[nElements * 2];
            int idx = 0;
            while (c00.hasNext()) {
                shorts[idx] = (short)((((UnsignedShortType)c00.next()).get() + ((UnsignedShortType)c01.next()).get() + ((UnsignedShortType)c10.next()).get() + ((UnsignedShortType)c11.next()).get()) / 4);
                ++idx;
            }
            return new VolatileShortArray(shorts, true);
        }

        public int getBytesPerElement() {
            return 2;
        }
    }

    protected static class PyramidizeByteArrayLoader
    extends PyramidizeArrayLoader
    implements CacheArrayLoader<VolatileByteArray> {
        final List<List<RandomAccessibleInterval<UnsignedByteType>>> rais00 = new ArrayList<List<RandomAccessibleInterval<UnsignedByteType>>>();
        final List<List<RandomAccessibleInterval<UnsignedByteType>>> rais01 = new ArrayList<List<RandomAccessibleInterval<UnsignedByteType>>>();
        final List<List<RandomAccessibleInterval<UnsignedByteType>>> rais10 = new ArrayList<List<RandomAccessibleInterval<UnsignedByteType>>>();
        final List<List<RandomAccessibleInterval<UnsignedByteType>>> rais11 = new ArrayList<List<RandomAccessibleInterval<UnsignedByteType>>>();

        protected PyramidizeByteArrayLoader(PyramidizeSetupLoader psl) {
            super(psl);
        }

        @Override
        void init() {
            for (int tp = 0; tp < this.psl.opener.getNTimePoints(); ++tp) {
                this.rais00.add(new ArrayList());
                this.rais01.add(new ArrayList());
                this.rais10.add(new ArrayList());
                this.rais11.add(new ArrayList());
                for (int level = 1; level < this.psl.numMipmapLevels(); ++level) {
                    IntervalView rai = Views.expandBorder(this.psl.getImage(tp, level - 1, new ImgLoaderHint[0]), (long[])new long[]{1L, 1L, 0L});
                    this.rais00.get(tp).add((RandomAccessibleInterval<UnsignedByteType>)Views.subsample((RandomAccessibleInterval)rai, (long[])new long[]{2L, 2L, 1L}));
                    this.rais01.get(tp).add((RandomAccessibleInterval<UnsignedByteType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 0L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais10.get(tp).add((RandomAccessibleInterval<UnsignedByteType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{0L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                    this.rais11.get(tp).add((RandomAccessibleInterval<UnsignedByteType>)Views.subsample((RandomAccessibleInterval)Views.offsetInterval((RandomAccessible)rai, (long[])new long[]{1L, 1L, 0L}, (long[])rai.dimensionsAsLongArray()), (long[])new long[]{2L, 2L, 1L}));
                }
            }
        }

        public VolatileByteArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) {
            assert (dimensions[2] == 1);
            FinalInterval cell = Intervals.createMinSize((long[])new long[]{min[0], min[1], min[2], dimensions[0], dimensions[1], dimensions[2]});
            Cursor c00 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais00.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c01 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais01.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c10 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais10.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            Cursor c11 = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)((RandomAccessible)this.rais11.get(timepoint).get(level - 1)), (Interval)cell)).cursor();
            int nElements = dimensions[0] * dimensions[1] * dimensions[2];
            byte[] bytes = new byte[nElements];
            int idx = 0;
            while (c00.hasNext()) {
                bytes[idx] = (byte)((((UnsignedByteType)c00.next()).get() + ((UnsignedByteType)c01.next()).get() + ((UnsignedByteType)c10.next()).get() + ((UnsignedByteType)c11.next()).get()) / 4);
                ++idx;
            }
            return new VolatileByteArray(bytes, true);
        }

        public int getBytesPerElement() {
            return 1;
        }
    }

    static abstract class PyramidizeArrayLoader<T extends NumericType<T> & NativeType<T>, V extends Volatile<T> & NativeType<V>, A extends DataAccess & ArrayDataAccess<A>> {
        final PyramidizeSetupLoader<T, V, A> psl;

        private PyramidizeArrayLoader(PyramidizeSetupLoader<T, V, A> psl) {
            this.psl = psl;
        }

        abstract void init();
    }
}

