/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.opener;

import ch.epfl.biop.bdv.img.bioformats.BioFormatsOpener;
import ch.epfl.biop.bdv.img.omero.OmeroOpener;
import ch.epfl.biop.bdv.img.opener.Opener;
import ch.epfl.biop.bdv.img.pyramidize.PyramidizeOpener;
import ch.epfl.biop.bdv.img.qupath.QuPathOpener;
import com.google.gson.Gson;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Map;
import net.imglib2.realtransform.AffineTransform3D;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import omero.api.RawPixelsStorePrx;
import org.scijava.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenerSettings {
    static Logger logger = LoggerFactory.getLogger(OpenerSettings.class);
    transient Context scijavaContext;
    String opt = "";
    transient double[] positionPreTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
    transient double[] positionPostTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
    transient boolean positionIsImageCenter = false;
    transient Length defaultSpaceUnit = new Length((Number)1, UNITS.MICROMETER);
    transient Length defaultVoxelUnit = new Length((Number)1, UNITS.MICROMETER);
    String unit = "MICROMETER";
    int nReader = 10;
    boolean defaultBlockSize = true;
    int[] blockSize = new int[]{512, 512, 1};
    boolean splitRGB = false;
    boolean to16bits = false;
    boolean autoPyramidize = false;
    public static int THRESHOLD_PYRAMIDIZE_PIX = 1024;
    OpenerType type = OpenerType.UNDEF;
    String location = "";
    public static final String BF_MEMO_KEY = "use_bfmemo";
    int id = -1;
    int nChannels = -1;
    transient boolean skipMeta = false;

    public OpenerSettings positionConvention(String position_convention) {
        if (position_convention.equals("CENTER")) {
            return this.centerPositionConvention();
        }
        return this.cornerPositionConvention();
    }

    public OpenerType getType() {
        return this.type;
    }

    public String getLocation() {
        return this.location;
    }

    public int getNChannels() {
        return this.nChannels;
    }

    public int getEntryId() {
        return this.id;
    }

    public int getSeries() {
        return this.id;
    }

    public OpenerSettings context(Context context) {
        this.scijavaContext = context;
        return this;
    }

    public OpenerSettings readerPoolSize(int pSize) {
        this.nReader = pSize;
        return this;
    }

    public OpenerSettings useDefaultCacheBlockSize(boolean flag) {
        this.defaultBlockSize = flag;
        return this;
    }

    public void setNChannels(int nChannels) {
        this.nChannels = nChannels;
    }

    public OpenerSettings cacheBlockSize(int sx, int sy, int sz) {
        this.defaultBlockSize = false;
        this.blockSize = new int[]{sx, sy, sz};
        return this;
    }

    public OpenerSettings flipPositionXYZ() {
        if (this.positionPreTransformMatrixArray == null) {
            this.positionPreTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
        }
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.set(this.positionPreTransformMatrixArray);
        at3D.scale(-1.0);
        this.positionPreTransformMatrixArray = at3D.getRowPackedCopy();
        return this;
    }

    public OpenerSettings flipPositionX() {
        if (this.positionPreTransformMatrixArray == null) {
            this.positionPreTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
        }
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.set(this.positionPreTransformMatrixArray);
        at3D.scale(-1.0, 1.0, 1.0);
        this.positionPreTransformMatrixArray = at3D.getRowPackedCopy();
        return this;
    }

    public OpenerSettings flipPositionY() {
        if (this.positionPreTransformMatrixArray == null) {
            this.positionPreTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
        }
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.set(this.positionPreTransformMatrixArray);
        at3D.scale(1.0, -1.0, 1.0);
        this.positionPreTransformMatrixArray = at3D.getRowPackedCopy();
        return this;
    }

    public OpenerSettings to16bits(boolean to16bits) {
        this.to16bits = to16bits;
        return this;
    }

    public OpenerSettings flipPositionZ() {
        if (this.positionPreTransformMatrixArray == null) {
            this.positionPreTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
        }
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.set(this.positionPreTransformMatrixArray);
        at3D.scale(1.0, 1.0, -1.0);
        this.positionPreTransformMatrixArray = at3D.getRowPackedCopy();
        return this;
    }

    public OpenerSettings setPositionPreTransform(AffineTransform3D at3d) {
        this.positionPreTransformMatrixArray = at3d.getRowPackedCopy();
        return this;
    }

    public OpenerSettings setPositionPostTransform(AffineTransform3D at3d) {
        this.positionPostTransformMatrixArray = at3d.getRowPackedCopy();
        return this;
    }

    public OpenerSettings centerPositionConvention() {
        this.positionIsImageCenter = true;
        return this;
    }

    public OpenerSettings cornerPositionConvention() {
        this.positionIsImageCenter = false;
        return this;
    }

    public OpenerSettings positionReferenceFrameLength(Length l) {
        this.defaultSpaceUnit = l;
        return this;
    }

    public OpenerSettings voxSizeReferenceFrameLength(Length l) {
        this.defaultVoxelUnit = l;
        return this;
    }

    public OpenerSettings location(String location) {
        this.location = location;
        return this;
    }

    public OpenerSettings location(URI uri) throws URISyntaxException {
        if (uri.getScheme().equals("https") || uri.getScheme().equals("http")) {
            this.location = uri.toString();
        } else {
            URI newuri = new URI(uri.getScheme(), uri.getHost(), uri.getPath(), null);
            this.location = Paths.get(newuri).toString();
        }
        return this;
    }

    public OpenerSettings location(File f) {
        this.location = f.getAbsolutePath();
        return this;
    }

    public OpenerSettings splitRGBChannels() {
        this.splitRGB = true;
        return this;
    }

    public OpenerSettings splitRGBChannels(boolean flag) {
        this.splitRGB = flag;
        return this;
    }

    public OpenerSettings unit(String u) {
        this.unit = u;
        return this;
    }

    public OpenerSettings unit(UNITS u) {
        this.unit = u.getName();
        return this;
    }

    public OpenerSettings unit(Unit<Length> u) {
        this.unit = u.getSymbol();
        return this;
    }

    public OpenerSettings millimeter() {
        this.unit = UNITS.MILLIMETER.getSymbol();
        return this;
    }

    public OpenerSettings micrometer() {
        this.unit = UNITS.MICROMETER.getSymbol();
        return this;
    }

    public OpenerSettings nanometer() {
        this.unit = UNITS.NANOMETER.getSymbol();
        return this;
    }

    public OpenerSettings omeroBuilder() {
        this.type = OpenerType.OMERO;
        return this;
    }

    public OpenerSettings bioFormatsBuilder() {
        this.type = OpenerType.BIOFORMATS;
        return this;
    }

    public OpenerSettings imageJBuilder() {
        this.type = OpenerType.IMAGEJ;
        return this;
    }

    public OpenerSettings openSlideBuilder() {
        this.type = OpenerType.OPENSLIDE;
        return this;
    }

    public OpenerSettings quPathBuilder() {
        this.type = OpenerType.QUPATH;
        return this;
    }

    public OpenerSettings setSerie(int iSerie) {
        this.id = iSerie;
        return this;
    }

    public OpenerSettings setEntry(int entryId) {
        this.id = entryId;
        return this;
    }

    public OpenerSettings addOptions(String options) {
        this.opt = options;
        return this;
    }

    public OpenerSettings useBFMemo(boolean flag) {
        if (!flag) {
            this.opt = this.opt + " --bfOptions " + BF_MEMO_KEY + "=false";
        }
        return this;
    }

    public OpenerSettings skipMeta() {
        this.skipMeta = true;
        return this;
    }

    public OpenerSettings pyramidize(boolean flag) {
        this.autoPyramidize = flag;
        return this;
    }

    public Opener<?> create(Map<String, Object> cachedObjects) throws Exception {
        boolean pyramidize;
        Opener<RawPixelsStorePrx> opener;
        switch (this.type) {
            case OMERO: {
                opener = new OmeroOpener(this.scijavaContext, this.location, this.nReader, this.unit, this.positionIsImageCenter, cachedObjects, this.nChannels, this.skipMeta);
                break;
            }
            case QUPATH: {
                opener = new QuPathOpener(this.scijavaContext, this.location, this.id, this.unit, this.positionIsImageCenter, this.nReader, this.defaultBlockSize, this.blockSize, this.splitRGB, cachedObjects, this.nChannels, this.skipMeta);
                break;
            }
            case BIOFORMATS: {
                opener = new BioFormatsOpener(this.scijavaContext, this.location, this.id, this.positionPreTransformMatrixArray, this.positionPostTransformMatrixArray, this.positionIsImageCenter, this.defaultSpaceUnit, this.defaultVoxelUnit, this.unit, this.nReader, this.defaultBlockSize, this.blockSize, this.splitRGB, cachedObjects, this.nChannels, this.skipMeta, this.to16bits, this.opt);
                break;
            }
            case IMAGEJ: {
                throw new UnsupportedOperationException("ImageJ opener not supported");
            }
            case OPENSLIDE: {
                throw new UnsupportedOperationException("OPENSLIDE opener not supported");
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)this.type) + " opener not supported");
            }
        }
        if (opener.getNChannels() != -1) {
            this.nChannels = opener.getNChannels();
        }
        if (this.autoPyramidize ? opener.getDimensions()[0].dimension(0) > (long)THRESHOLD_PYRAMIDIZE_PIX && opener.getDimensions()[0].dimension(1) > (long)THRESHOLD_PYRAMIDIZE_PIX && opener.getNumMipmapLevels() == 1 : opener instanceof QuPathOpener && (pyramidize = ((QuPathOpener)opener).getPyramidize()) && opener.getNumMipmapLevels() == 1) {
            return new PyramidizeOpener<RawPixelsStorePrx>(opener);
        }
        return opener;
    }

    public static OpenerSettings BioFormats() {
        return new OpenerSettings().bioFormatsBuilder();
    }

    public static OpenerSettings OMERO() {
        return new OpenerSettings().omeroBuilder();
    }

    public static OpenerSettings QuPath() {
        return new OpenerSettings().quPathBuilder();
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public static enum OpenerType {
        BIOFORMATS,
        OMERO,
        IMAGEJ,
        OPENSLIDE,
        QUPATH,
        UNDEF;

    }
}

