/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.opener;

import ch.epfl.biop.bdv.img.bioformats.entity.FileName;
import ch.epfl.biop.bdv.img.bioformats.entity.SeriesIndex;
import ch.epfl.biop.bdv.img.entity.ImageName;
import ch.epfl.biop.bdv.img.omero.entity.OmeroHostId;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.Tile;
import net.imglib2.Volatile;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.type.volatiles.VolatileFloatType;
import net.imglib2.type.volatiles.VolatileIntType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedShortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenerHelper {
    private static final Logger logger = LoggerFactory.getLogger(OpenerHelper.class);

    public static <T> T memoize(String key, Map<String, Object> cache, Supplier<T> getter) {
        if (!cache.containsKey(key)) {
            cache.put(key, getter.get());
        } else {
            logger.debug(key + " is reused! ");
        }
        return (T)cache.get(key);
    }

    public static Volatile getVolatileOf(NumericType t) {
        if (t instanceof UnsignedShortType) {
            return new VolatileUnsignedShortType();
        }
        if (t instanceof IntType) {
            return new VolatileIntType();
        }
        if (t instanceof UnsignedByteType) {
            return new VolatileUnsignedByteType();
        }
        if (t instanceof FloatType) {
            return new VolatileFloatType();
        }
        if (t instanceof ARGBType) {
            return new VolatileARGBType();
        }
        return null;
    }

    public static Map<String, Class<? extends Entity>> getEntities() {
        HashMap<String, Class<? extends Entity>> entityClasses = new HashMap<String, Class<? extends Entity>>();
        entityClasses.put(Tile.class.getSimpleName().toUpperCase(), Tile.class);
        entityClasses.put(Illumination.class.getSimpleName().toUpperCase(), Illumination.class);
        entityClasses.put(Angle.class.getSimpleName().toUpperCase(), Angle.class);
        entityClasses.put(Channel.class.getSimpleName().toUpperCase(), Channel.class);
        entityClasses.put(FileName.class.getSimpleName().toUpperCase(), FileName.class);
        entityClasses.put(SeriesIndex.class.getSimpleName().toUpperCase(), SeriesIndex.class);
        entityClasses.put(ImageName.class.getSimpleName().toUpperCase(), ImageName.class);
        entityClasses.put(OmeroHostId.class.getSimpleName().toUpperCase(), OmeroHostId.class);
        return entityClasses;
    }
}

