/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.opener;

import bdv.img.cache.VolatileGlobalCellCache;
import bdv.util.volatiles.VolatileViews;
import ch.epfl.biop.bdv.img.OpenerSetupLoader;
import ch.epfl.biop.bdv.img.ResourcePool;
import ch.epfl.biop.bdv.img.opener.ChannelProperties;
import ch.epfl.biop.bdv.img.opener.Opener;
import ij.process.ByteProcessor;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.ReadOnlyCachedCellImgFactory;
import net.imglib2.cache.img.ReadOnlyCachedCellImgOptions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import net.imglib2.view.Views;

public class EmptyOpener
implements Opener<Object> {
    final List<ChannelProperties> channelProperties = new ArrayList<ChannelProperties>();
    String imageName;
    final String message;
    final ResourcePool<Object> pool;
    final Dimensions[] dimensions;
    final Opener.OpenerMeta meta;
    final int sx = 512;
    final int sy = 512;

    public EmptyOpener(final String imageName, int nChannels, String message, boolean skipMeta) {
        this.message = message;
        for (int iCh = 0; iCh < nChannels; ++iCh) {
            ChannelProperties channel = new ChannelProperties(iCh);
            channel.setNChannels(nChannels).setChannelColor(new ARGBType(ARGBType.rgba((int)255, (int)255, (int)255, (int)128))).setChannelName("Channel " + iCh).setDisplayRange(0.0, 255.0).setPixelType((Type<? extends NumericType<?>>)new UnsignedByteType());
            this.channelProperties.add(channel);
        }
        this.pool = new ResourcePool<Object>(2, Boolean.valueOf(true)){

            @Override
            protected Object createObject() {
                return new Object();
            }
        };
        this.meta = new Opener.OpenerMeta(){

            @Override
            public String getImageName() {
                return imageName;
            }

            @Override
            public AffineTransform3D getTransform() {
                return new AffineTransform3D();
            }

            @Override
            public List<Entity> getEntities(int iChannel) {
                return new ArrayList<Entity>();
            }

            @Override
            public ChannelProperties getChannel(int iChannel) {
                return EmptyOpener.this.channelProperties.get(iChannel);
            }
        };
        this.dimensions = new Dimensions[]{new Dimensions(){

            public long dimension(int d) {
                if (d == 0) {
                    return 512L;
                }
                if (d == 1) {
                    return 512L;
                }
                return 1L;
            }

            public int numDimensions() {
                return 3;
            }
        }};
    }

    @Override
    public int[] getCellDimensions(int level) {
        return new int[]{512, 512, 1};
    }

    @Override
    public Dimensions[] getDimensions() {
        return this.dimensions;
    }

    @Override
    public int getNChannels() {
        return this.channelProperties.size();
    }

    @Override
    public int getNTimePoints() {
        return 1;
    }

    @Override
    public int getNumMipmapLevels() {
        return 1;
    }

    @Override
    public ResourcePool<Object> getPixelReader() {
        return this.pool;
    }

    @Override
    public Type<? extends NumericType<?>> getPixelType() {
        return new UnsignedByteType();
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return new FinalVoxelDimensions("px", new double[]{1.0, 1.0, 1.0});
    }

    @Override
    public boolean isLittleEndian() {
        return false;
    }

    @Override
    public String getImageFormat() {
        return "Empty";
    }

    @Override
    public OpenerSetupLoader<?, ?, ?> getSetupLoader(int channelIdx, int setupIdx, Supplier<VolatileGlobalCellCache> cacheSupplier) {
        return new EmptySetupLoader(this.message);
    }

    @Override
    public String getRawPixelDataKey() {
        return "empty." + this.imageName + "." + this.message;
    }

    @Override
    public Opener.OpenerMeta getMeta() {
        return this.meta;
    }

    @Override
    public void close() {
    }

    public static byte[] getImage(String text, int w, int h) {
        Font font = new Font("Arial", 1, 20);
        ByteProcessor ip = new ByteProcessor(w, h);
        ip.setColor(Color.WHITE);
        ip.setFont(font);
        ip.drawString(text, 20, 25);
        return (byte[])ip.getPixels();
    }

    static class EmptySetupLoader<A>
    extends OpenerSetupLoader<UnsignedByteType, VolatileUnsignedByteType, A> {
        final AffineTransform3D transform3D = new AffineTransform3D();
        final VoxelDimensions voxelDimensions = new FinalVoxelDimensions("px", new double[]{1.0, 1.0, 1.0});
        final double[][] mipmapResolutions;
        final int sx = 512;
        final int sy = 512;
        final Dimensions dimensions;
        final RandomAccessibleInterval<UnsignedByteType> zeRAI;
        final RandomAccessibleInterval<VolatileUnsignedByteType> zeVolatileRAI;
        final String message;

        public EmptySetupLoader(String message) {
            super(new UnsignedByteType(), new VolatileUnsignedByteType());
            this.message = message;
            this.mipmapResolutions = new double[1][3];
            this.mipmapResolutions[0][0] = 1.0;
            this.mipmapResolutions[0][1] = 1.0;
            this.mipmapResolutions[0][2] = 1.0;
            this.dimensions = new Dimensions(){

                public long dimension(int d) {
                    if (d == 0) {
                        return 512L;
                    }
                    if (d == 1) {
                        return 512L;
                    }
                    return 1L;
                }

                public int numDimensions() {
                    return 3;
                }
            };
            ReadOnlyCachedCellImgFactory factory = new ReadOnlyCachedCellImgFactory((ReadOnlyCachedCellImgOptions)ReadOnlyCachedCellImgOptions.options().cellDimensions(new int[]{512, 512, 1}));
            byte[] rawImage = EmptyOpener.getImage(message, 512, 512);
            this.zeRAI = factory.create(new long[]{512L, 512L, 1L}, (NativeType)new UnsignedByteType(), cell -> {
                int iPix = 0;
                for (UnsignedByteType pixel : Views.flatIterable((RandomAccessibleInterval)cell)) {
                    pixel.set(255 - rawImage[iPix]);
                    ++iPix;
                }
            });
            this.zeVolatileRAI = VolatileViews.wrapAsVolatile(this.zeRAI);
        }

        public RandomAccessibleInterval<VolatileUnsignedByteType> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.zeVolatileRAI;
        }

        public RandomAccessibleInterval<UnsignedByteType> getImage(int i, int i1, ImgLoaderHint ... imgLoaderHints) {
            return this.zeRAI;
        }

        public Dimensions getImageSize(int timepointId, int level) {
            return this.dimensions;
        }

        public double[][] getMipmapResolutions() {
            return this.mipmapResolutions;
        }

        public AffineTransform3D[] getMipmapTransforms() {
            return new AffineTransform3D[]{this.transform3D};
        }

        public int numMipmapLevels() {
            return 1;
        }

        public VoxelDimensions getVoxelSize(int i) {
            return this.voxelDimensions;
        }
    }
}

