/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.opener;

import com.google.gson.Gson;
import java.awt.Color;
import loci.formats.meta.IMetadata;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import ome.model.units.BigResult;
import ome.units.UNITS;
import omero.gateway.model.ChannelData;
import omero.model.ChannelBinding;
import omero.model.RenderingDef;
import omero.model.enums.UnitsLength;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelProperties {
    protected static final Logger logger = LoggerFactory.getLogger(ChannelProperties.class);
    String name = "";
    int nChannels = 1;
    int iChannel;
    double displayRangeMin = 0.0;
    double displayRangeMax = 255.0;
    transient Type<? extends NumericType<?>> pixelType;
    Boolean isRGB = false;
    public transient ARGBType color;
    int emissionWavelength = -1;
    int excitationWavelength = -1;
    static final int[] loopR = new int[]{1, 0, 0, 1, 1, 1, 0};
    static final int[] loopG = new int[]{0, 1, 0, 1, 1, 0, 1};
    static final int[] loopB = new int[]{0, 0, 1, 1, 0, 1, 1};

    public ARGBType getColor() {
        return this.color;
    }

    public String getChannelName() {
        return this.name;
    }

    public double getDisplayRangeMin() {
        return this.displayRangeMin;
    }

    public double getDisplayRangeMax() {
        return this.displayRangeMax;
    }

    public ChannelProperties(int iChannel) {
        this.iChannel = iChannel;
    }

    public ChannelProperties setEmissionWavelength(int iSerie, IMetadata metadata) {
        try {
            this.emissionWavelength = metadata.getChannelEmissionWavelength(iSerie, this.iChannel) != null ? metadata.getChannelEmissionWavelength(iSerie, this.iChannel).value(UNITS.NANOMETER).intValue() : -1;
        }
        catch (Exception e) {
            logger.warn("Error: " + e.getMessage() + " caught when trying to get the channel emission wavelength");
            this.emissionWavelength = -1;
        }
        return this;
    }

    public ChannelProperties setEmissionWavelength(ChannelData channelData) throws BigResult {
        this.emissionWavelength = channelData.getEmissionWavelength(UnitsLength.NANOMETER) != null ? (int)channelData.getEmissionWavelength(UnitsLength.NANOMETER).getValue() : -1;
        return this;
    }

    public ChannelProperties setExcitationWavelength(int iSerie, IMetadata metadata) {
        try {
            this.excitationWavelength = metadata.getChannelExcitationWavelength(iSerie, this.iChannel) != null ? metadata.getChannelExcitationWavelength(iSerie, this.iChannel).value(UNITS.NANOMETER).intValue() : -1;
        }
        catch (Exception e) {
            logger.warn("Error: " + e.getMessage() + " caught when trying to get the channel excitation wavelength.");
            this.excitationWavelength = -1;
        }
        return this;
    }

    public ChannelProperties setExcitationWavelength(ChannelData channelData) throws BigResult {
        this.excitationWavelength = channelData.getExcitationWavelength(UnitsLength.NANOMETER) != null ? (int)channelData.getExcitationWavelength(UnitsLength.NANOMETER).getValue() : -1;
        return this;
    }

    public ChannelProperties setChannelColor(int iSerie, IMetadata metadata) {
        try {
            ome.xml.model.primitives.Color c = metadata.getChannelColor(iSerie, this.iChannel);
            if (c != null) {
                logger.debug("c = [" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "]");
                this.color = new ARGBType(ARGBType.rgba((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue(), (int)255));
            } else {
                if (this.emissionWavelength == -1) {
                    this.setEmissionWavelength(iSerie, metadata);
                }
                if (this.emissionWavelength != -1) {
                    int emission = this.emissionWavelength;
                    logger.debug("emission = " + emission);
                    Color cAwt = ChannelProperties.getColorFromWavelength(emission);
                    this.color = new ARGBType(ARGBType.rgba((int)cAwt.getRed(), (int)cAwt.getGreen(), (int)cAwt.getBlue(), (int)255));
                } else {
                    this.color = new ARGBType(ARGBType.rgba((int)(255 * loopR[this.iChannel % 7]), (int)(255 * loopG[this.iChannel % 7]), (int)(255 * loopB[this.iChannel % 7]), (int)255));
                }
            }
        }
        catch (Exception e) {
            logger.warn("Error: " + e.getMessage() + " caught when trying to get the channel color");
            this.color = new ARGBType(ARGBType.rgba((int)(255 * loopR[this.iChannel % 7]), (int)(255 * loopG[this.iChannel % 7]), (int)(255 * loopB[this.iChannel % 7]), (int)255));
        }
        return this;
    }

    public ChannelProperties setChannelColor(RenderingDef renderingDef) {
        if (renderingDef == null) {
            logger.warn("No rendering definition found!");
            this.color = new ARGBType(ARGBType.rgba((int)(this.iChannel % 3 == 0 ? 255 : 0), (int)((this.iChannel + 1) % 3 == 0 ? 255 : 0), (int)((this.iChannel + 2) % 3 == 0 ? 255 : 0), (int)255));
            return this;
        }
        ChannelBinding cb = renderingDef.getChannelBinding(this.iChannel);
        this.color = new ARGBType(ARGBType.rgba((int)cb.getRed().getValue(), (int)cb.getGreen().getValue(), (int)cb.getBlue().getValue(), (int)cb.getAlpha().getValue()));
        return this;
    }

    public ChannelProperties setChannelColor(int colorIdx) {
        Color color = new Color(colorIdx);
        this.color = new ARGBType(ARGBType.rgba((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue(), (int)color.getAlpha()));
        return this;
    }

    public ChannelProperties setChannelColor(ARGBType color) {
        this.color = color;
        return this;
    }

    public ChannelProperties setChannelName(int iSerie, IMetadata metadata) {
        String channelName;
        try {
            channelName = metadata.getChannelName(iSerie, this.iChannel);
        }
        catch (Exception e) {
            logger.warn("Error: " + e.getMessage() + " caught when trying to get the channel name");
            channelName = null;
        }
        if (channelName != null && !channelName.equals("")) {
            this.name = metadata.getChannelName(iSerie, this.iChannel);
        } else {
            this.name = "ch_" + this.iChannel;
            logger.warn("No name found for serie " + iSerie + " ch " + this.iChannel + " setting name to " + this.name);
        }
        return this;
    }

    public ChannelProperties setChannelName(ChannelData channelData) {
        this.name = channelData.getChannelLabeling();
        return this;
    }

    public ChannelProperties setChannelName(String name) {
        this.name = name;
        return this;
    }

    public ChannelProperties setDynamicRange(RenderingDef rd) {
        if (rd == null) {
            this.displayRangeMin = 0.0;
            this.displayRangeMax = 255.0;
            return this;
        }
        this.displayRangeMin = rd.getChannelBinding(this.iChannel).getInputStart().getValue();
        this.displayRangeMax = rd.getChannelBinding(this.iChannel).getInputEnd().getValue();
        return this;
    }

    public ChannelProperties setDisplayRange(double min, double max) {
        this.displayRangeMin = min;
        this.displayRangeMax = max;
        return this;
    }

    public ChannelProperties setPixelType(Type<? extends NumericType<?>> pixelType) {
        this.pixelType = pixelType;
        return this;
    }

    public ChannelProperties setRGB(Boolean RGB) {
        this.isRGB = RGB;
        return this;
    }

    public ChannelProperties setNChannels(int nChannels) {
        this.nChannels = nChannels;
        return this;
    }

    public static Color getColorFromWavelength(int wv) {
        int[] res = ChannelProperties.waveLengthToRGB(wv);
        return new Color(res[0], res[1], res[2]);
    }

    public static int[] waveLengthToRGB(double Wavelength) {
        double Blue;
        double Green;
        double Red;
        double Gamma = 0.8;
        double IntensityMax = 255.0;
        if (Wavelength >= 380.0 && Wavelength < 440.0) {
            Red = -(Wavelength - 440.0) / 60.0;
            Green = 0.0;
            Blue = 1.0;
        } else if (Wavelength >= 440.0 && Wavelength < 490.0) {
            Red = 0.0;
            Green = (Wavelength - 440.0) / 50.0;
            Blue = 1.0;
        } else if (Wavelength >= 490.0 && Wavelength < 510.0) {
            Red = 0.0;
            Green = 1.0;
            Blue = -(Wavelength - 510.0) / 20.0;
        } else if (Wavelength >= 510.0 && Wavelength < 580.0) {
            Red = (Wavelength - 510.0) / 70.0;
            Green = 1.0;
            Blue = 0.0;
        } else if (Wavelength >= 580.0 && Wavelength < 645.0) {
            Red = 1.0;
            Green = -(Wavelength - 645.0) / 65.0;
            Blue = 0.0;
        } else if (Wavelength >= 645.0 && Wavelength < 781.0) {
            Red = 1.0;
            Green = 0.0;
            Blue = 0.0;
        } else {
            Red = 0.0;
            Green = 0.0;
            Blue = 0.0;
        }
        double factor = Wavelength >= 380.0 && Wavelength < 420.0 ? 0.3 + 0.7 * (Wavelength - 380.0) / 40.0 : (Wavelength >= 420.0 && Wavelength < 701.0 ? 1.0 : (Wavelength >= 701.0 && Wavelength < 781.0 ? 0.3 + 0.7 * (780.0 - Wavelength) / 80.0 : 0.0));
        int[] rgb = new int[]{Red == 0.0 ? 0 : (int)Math.round(IntensityMax * Math.pow(Red * factor, Gamma)), Green == 0.0 ? 0 : (int)Math.round(IntensityMax * Math.pow(Green * factor, Gamma)), Blue == 0.0 ? 0 : (int)Math.round(IntensityMax * Math.pow(Blue * factor, Gamma))};
        return rgb;
    }

    public int hashCode() {
        return this.name.hashCode() * this.pixelType.getClass().hashCode() * this.emissionWavelength * this.excitationWavelength * (this.iChannel + 1) * 1 * this.nChannels;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChannelProperties) {
            ChannelProperties bc = (ChannelProperties)obj;
            return this.isRGB == bc.isRGB && this.name.equals(bc.name) && this.pixelType.getClass().equals(bc.pixelType.getClass()) && this.iChannel == bc.iChannel && this.emissionWavelength == bc.emissionWavelength && this.excitationWavelength == bc.excitationWavelength && this.nChannels == bc.nChannels && this.color.get() == bc.color.get();
        }
        return false;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

