/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.omero.command;

import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import java.util.ArrayList;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.apache.commons.lang.time.StopWatch;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Create BDV Dataset [OMERO]", description="Bridge between OMERO and BigDataViewer. You can create a BDV dataset from a set of OMERO URLs.")
public class CreateBdvDatasetOMEROCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(CreateBdvDatasetOMEROCommand.class);
    @Parameter
    Context context;
    @Parameter(label="Name of this dataset")
    public String datasetname = "dataset";
    @Parameter(label="OMERO URLs", style="text area")
    public String omero_urls;
    @Parameter(type=ItemIO.OUTPUT)
    AbstractSpimData<?> spimdata;
    @Parameter(required=false, label="Physical units of the dataset", choices={"MILLIMETER", "MICROMETER", "NANOMETER"})
    public String unit = "MILLIMETER";
    @Parameter(required=false, label="Plane Origin Convention", choices={"CENTER", "TOP LEFT"})
    String plane_origin_convention = "CENTER";

    public void run() {
        try {
            String[] omeroIDstrings;
            ArrayList<OpenerSettings> openersSettings = new ArrayList<OpenerSettings>();
            for (String s : omeroIDstrings = this.omero_urls.split(",")) {
                logger.debug("Getting settings for omero url " + s);
                OpenerSettings settings = OpenerSettings.OMERO().context(this.context).location(s).unit(this.unit).positionConvention(this.plane_origin_convention);
                openersSettings.add(settings);
            }
            StopWatch watch = new StopWatch();
            logger.debug("All openers obtained, converting to spimdata object ");
            watch.start();
            this.spimdata = OpenersToSpimData.getSpimData(openersSettings);
            watch.stop();
            logger.debug("Converted to SpimData in " + (int)(watch.getTime() / 1000L) + " s");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

