/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.omero;

import bdv.img.cache.CacheArrayLoader;
import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.OpenerSetupLoader;
import ch.epfl.biop.bdv.img.omero.OmeroArrayLoaders;
import ch.epfl.biop.bdv.img.omero.OmeroOpener;
import java.util.function.Function;
import java.util.function.Supplier;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmeroSetupLoader<T extends NumericType<T> & NativeType<T>, V extends Volatile<T> & NativeType<V>, A extends DataAccess>
extends OpenerSetupLoader<T, V, A> {
    private static final Logger logger = LoggerFactory.getLogger(OmeroSetupLoader.class);
    Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<FloatType>> cvtRaiToFloatRai;
    final Converter<T, FloatType> cvt;
    final Supplier<VolatileGlobalCellCache> cacheSupplier;
    final CacheArrayLoader<A> loader;
    final double[][] mmResolutions;
    final int numMipmapLevels;
    final OmeroOpener opener;
    final int iChannel;
    final Dimensions[] dimensions;
    final VoxelDimensions voxelsDimensions;
    final int setup;

    public OmeroSetupLoader(OmeroOpener opener, int channelIndex, int setup, T t, V v, Supplier<VolatileGlobalCellCache> cacheSupplier) {
        super(t, v);
        this.opener = opener;
        this.iChannel = channelIndex;
        this.setup = setup;
        this.cacheSupplier = cacheSupplier;
        if (t instanceof FloatType) {
            this.cvt = null;
            this.cvtRaiToFloatRai = rai -> null;
        } else if (t instanceof ARGBType) {
            this.cvt = (input, output) -> {
                int val = ((ARGBType)input).get();
                int r = ARGBType.red((int)val);
                int g = ARGBType.green((int)val);
                int b = ARGBType.blue((int)val);
                output.set((float)(r + g + b));
            };
            this.cvtRaiToFloatRai = rai -> Converters.convert((RandomAccessibleInterval)rai, this.cvt, (Type)new FloatType());
        } else if (t instanceof AbstractIntegerType) {
            this.cvt = (input, output) -> output.set(((AbstractIntegerType)input).getRealFloat());
            this.cvtRaiToFloatRai = rai -> Converters.convert((RandomAccessibleInterval)rai, this.cvt, (Type)new FloatType());
        } else {
            this.cvt = null;
            this.cvtRaiToFloatRai = e -> {
                logger.error("Conversion of " + t.getClass() + " to FloatType unsupported.");
                return null;
            };
        }
        boolean isLittleEndian = opener.isLittleEndian();
        this.voxelsDimensions = opener.getVoxelDimensions();
        this.dimensions = opener.getDimensions();
        this.numMipmapLevels = opener.getNumMipmapLevels();
        this.mmResolutions = new double[this.numMipmapLevels][3];
        this.mmResolutions[0][0] = 1.0;
        this.mmResolutions[0][1] = 1.0;
        this.mmResolutions[0][2] = 1.0;
        if (opener.getImageFormat().equals("CellSens")) {
            for (int iLevel = 1; iLevel < this.numMipmapLevels; ++iLevel) {
                double downscalingFactor;
                this.mmResolutions[iLevel][0] = downscalingFactor = Math.pow(2.0, iLevel);
                this.mmResolutions[iLevel][1] = downscalingFactor;
                this.mmResolutions[iLevel][2] = 1.0;
            }
        } else {
            int[] srcL0dims = new int[]{(int)this.dimensions[0].dimension(0), (int)this.dimensions[0].dimension(1), (int)this.dimensions[0].dimension(2)};
            for (int iLevel = 1; iLevel < this.numMipmapLevels; ++iLevel) {
                int[] srcLidims = new int[]{(int)this.dimensions[iLevel].dimension(0), (int)this.dimensions[iLevel].dimension(1), (int)this.dimensions[iLevel].dimension(2)};
                this.mmResolutions[iLevel][0] = (double)srcL0dims[0] / (double)srcLidims[0];
                this.mmResolutions[iLevel][1] = (double)srcL0dims[1] / (double)srcLidims[1];
                this.mmResolutions[iLevel][2] = (double)srcL0dims[2] / (double)srcLidims[2];
            }
        }
        if (t instanceof UnsignedByteType) {
            this.loader = new OmeroArrayLoaders.OmeroUnsignedByteArrayLoader(opener.getPixelReader(), this.iChannel, opener.getNumMipmapLevels(), (int)this.dimensions[0].dimension(0), (int)this.dimensions[0].dimension(1), (int)this.dimensions[0].dimension(2));
        } else if (t instanceof UnsignedShortType) {
            this.loader = new OmeroArrayLoaders.OmeroUnsignedShortArrayLoader(opener.getPixelReader(), this.iChannel, opener.getNumMipmapLevels(), (int)this.dimensions[0].dimension(0), (int)this.dimensions[0].dimension(1), (int)this.dimensions[0].dimension(2), isLittleEndian);
        } else if (t instanceof FloatType) {
            this.loader = new OmeroArrayLoaders.OmeroFloatArrayLoader(opener.getPixelReader(), this.iChannel, opener.getNumMipmapLevels(), (int)this.dimensions[0].dimension(0), (int)this.dimensions[0].dimension(1), (int)this.dimensions[0].dimension(2), isLittleEndian);
        } else if (t instanceof IntType) {
            this.loader = new OmeroArrayLoaders.OmeroIntArrayLoader(opener.getPixelReader(), this.iChannel, opener.getNumMipmapLevels(), (int)this.dimensions[0].dimension(0), (int)this.dimensions[0].dimension(1), (int)this.dimensions[0].dimension(2), isLittleEndian);
        } else if (t instanceof ARGBType) {
            this.loader = new OmeroArrayLoaders.OmeroRGBArrayLoader(opener.getPixelReader(), this.iChannel, opener.getNumMipmapLevels(), (int)this.dimensions[0].dimension(0), (int)this.dimensions[0].dimension(1), (int)this.dimensions[0].dimension(2));
        } else {
            throw new UnsupportedOperationException("Pixel type " + t.getClass().getName() + " unsupported in " + OmeroSetupLoader.class.getName());
        }
    }

    public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
        long[] dims = this.dimensions[level].dimensionsAsLongArray();
        int[] cellDimensions = this.opener.getCellDimensions(level);
        CellGrid grid = new CellGrid(dims, cellDimensions);
        int priority = this.numMipmapLevels - level;
        CacheHints cacheHints = new CacheHints(LoadingStrategy.BUDGETED, priority, false);
        return this.cacheSupplier.get().createImg(grid, timepointId, this.setup, level, cacheHints, this.loader, (NativeType)this.volatileType);
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, int level, boolean normalize, ImgLoaderHint ... hints) {
        return this.cvtRaiToFloatRai.apply(this.getImage(timepointId, level, new ImgLoaderHint[0]));
    }

    public Dimensions getImageSize(int timepointId, int level) {
        return this.dimensions[level];
    }

    public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
        long[] dims = this.dimensions[level].dimensionsAsLongArray();
        int[] cellDimensions = this.opener.getCellDimensions(level);
        CellGrid grid = new CellGrid(dims, cellDimensions);
        int priority = this.numMipmapLevels - level;
        CacheHints cacheHints = new CacheHints(LoadingStrategy.BLOCKING, priority, false);
        return this.cacheSupplier.get().createImg(grid, timepointId, this.setup, level, cacheHints, this.loader, (NativeType)this.type);
    }

    public double[][] getMipmapResolutions() {
        return this.mmResolutions;
    }

    public AffineTransform3D[] getMipmapTransforms() {
        AffineTransform3D[] ats = new AffineTransform3D[this.numMipmapLevels];
        for (int iLevel = 0; iLevel < this.numMipmapLevels; ++iLevel) {
            AffineTransform3D at = new AffineTransform3D();
            at.scale(this.mmResolutions[iLevel][0], this.mmResolutions[iLevel][1], this.mmResolutions[iLevel][2]);
            ats[iLevel] = at;
        }
        return ats;
    }

    public int numMipmapLevels() {
        return this.numMipmapLevels;
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, boolean normalize, ImgLoaderHint ... hints) {
        return this.cvtRaiToFloatRai.apply(this.getImage(timepointId, 0, new ImgLoaderHint[0]));
    }

    public Dimensions getImageSize(int timepointId) {
        return this.getImageSize(0, 0);
    }

    public VoxelDimensions getVoxelSize(int timepointId) {
        return this.opener.getVoxelDimensions();
    }
}

