/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.omero;

import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.OpenerSetupLoader;
import ch.epfl.biop.bdv.img.ResourcePool;
import ch.epfl.biop.bdv.img.omero.OmeroHelper;
import ch.epfl.biop.bdv.img.omero.OmeroSetupLoader;
import ch.epfl.biop.bdv.img.omero.entity.OmeroHostId;
import ch.epfl.biop.bdv.img.opener.ChannelProperties;
import ch.epfl.biop.bdv.img.opener.Opener;
import ch.epfl.biop.bdv.img.opener.OpenerHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imagej.omero.OMEROSession;
import net.imglib2.Dimensions;
import net.imglib2.Volatile;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.type.volatiles.VolatileFloatType;
import net.imglib2.type.volatiles.VolatileIntType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedShortType;
import ome.model.units.BigResult;
import omero.ServerError;
import omero.api.RawPixelsStorePrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.MetadataFacility;
import omero.gateway.model.ChannelData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.PlaneInfo;
import omero.model.RenderingDef;
import omero.model.enums.UnitsLength;
import org.scijava.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmeroOpener
implements Opener<RawPixelsStorePrx> {
    protected static final Logger logger = LoggerFactory.getLogger(OmeroOpener.class);
    final RawPixelsStorePool pool;
    final Gateway gateway;
    final SecurityContext securityContext;
    final long omeroImageID;
    final String datalocation;
    final Map<Integer, int[]> imageSize;
    final Map<Integer, int[]> tileSize;
    final int nMipmapLevels;
    final int nTimePoints;
    final Type<? extends NumericType<?>> pixelType;
    final String unit;
    final double psizeX;
    final double psizeY;
    final double psizeZ;
    final long pixelsID;
    final int nChannels;
    final String rawPixelDataKey;
    Exception exception = null;
    final String host;
    final Opener.OpenerMeta meta;
    final String format;

    public int getSizeX(int level) {
        return this.imageSize.get(level)[0];
    }

    public int getSizeY(int level) {
        return this.imageSize.get(level)[1];
    }

    public int getSizeZ(int level) {
        return this.imageSize.get(level)[2];
    }

    public int getTileSizeX(int level) {
        return this.tileSize.get(level)[0];
    }

    public int getTileSizeY(int level) {
        return this.tileSize.get(level)[1];
    }

    public OmeroOpener(Context context, String datalocation, int poolSize, String unit, boolean positionIsImageCenter, Map<String, Object> cachedObjects, int defaultNumberOfChannels, boolean skipMeta) throws Exception {
        URL url = new URL(datalocation);
        this.host = url.getHost();
        if (cachedObjects.containsKey("opener.omero.connect." + this.host + ".error")) {
            throw new RuntimeException("Connection to OMERO failed");
        }
        OMEROSession session = null;
        try {
            session = OmeroHelper.getGatewayAndSecurityContext(context, this.host);
        }
        catch (Exception e) {
            cachedObjects.put("opener.omero.connect." + this.host + ".error", e);
            this.exception = e;
        }
        assert (session != null);
        if (this.exception != null) {
            throw this.exception;
        }
        this.gateway = session.getGateway();
        this.securityContext = session.getSecurityContext();
        List<Long> imageIDs = OmeroHelper.getImageIDs(datalocation, this.gateway, this.securityContext);
        if (imageIDs.isEmpty()) {
            throw new IllegalStateException("Could not found an image ID in url " + datalocation);
        }
        if (imageIDs.size() > 1) {
            throw new UnsupportedOperationException("Could not open multiple Omero IDs in a single URL, split them.");
        }
        long imageID = imageIDs.get(0);
        PixelsData pixels = OpenerHelper.memoize("opener.omero.pixels." + this.host + "." + imageID, cachedObjects, () -> {
            try {
                return OmeroOpener.getPixelsDataFromOmeroID(imageID, this.gateway, this.securityContext);
            }
            catch (Exception e) {
                this.exception = e;
                return null;
            }
        });
        if (this.exception != null) {
            throw this.exception;
        }
        this.pixelsID = pixels.getId();
        logger.debug("Opener :" + this + " pixel.getID : " + this.pixelsID);
        this.omeroImageID = imageID;
        this.unit = unit;
        this.datalocation = datalocation;
        this.rawPixelDataKey = "opener.omero." + this.host + "." + this.omeroImageID;
        this.pool = OpenerHelper.memoize("opener.omero.pool." + this.host + "." + imageID, cachedObjects, () -> {
            logger.debug("Creating pool for opener.omero.pool." + this.host + "." + imageID);
            return new RawPixelsStorePool(poolSize, true, this::getNewStore);
        });
        RawPixelsStorePrx rawPixStore = this.gateway.getPixelsStore(this.securityContext);
        rawPixStore.setPixelsId(this.pixelsID, false);
        this.nMipmapLevels = rawPixStore.getResolutionLevels();
        this.imageSize = new HashMap<Integer, int[]>();
        if (this.nMipmapLevels == 1) {
            this.imageSize.put(0, new int[]{pixels.getSizeX(), pixels.getSizeY(), pixels.getSizeZ()});
            this.tileSize = this.imageSize;
        } else {
            this.tileSize = new HashMap<Integer, int[]>();
            logger.debug("Get image size and tile sizes...");
            int tileSizeX = rawPixStore.getTileSize()[0];
            int tileSizeY = rawPixStore.getTileSize()[1];
            int bytesWidth = rawPixStore.getByteWidth();
            for (int level = 0; level < this.nMipmapLevels; ++level) {
                int[] sizes = new int[3];
                rawPixStore.setResolutionLevel(this.nMipmapLevels - level - 1);
                sizes[0] = rawPixStore.getRowSize() / bytesWidth;
                sizes[1] = (int)(rawPixStore.getPlaneSize() / (long)sizes[0] / (long)bytesWidth);
                sizes[2] = pixels.getSizeZ();
                int[] tileSizes = new int[]{Math.min(tileSizeX, sizes[0]), Math.min(tileSizeY, sizes[1])};
                this.imageSize.put(level, sizes);
                this.tileSize.put(level, tileSizes);
            }
        }
        rawPixStore.close();
        this.nTimePoints = pixels.getSizeT();
        this.nChannels = pixels.getSizeC();
        logger.debug("SQL request completed!");
        if (pixels.getPixelSizeX(OmeroHelper.getUnitsLengthFromString(unit)) == null || pixels.getPixelSizeY(OmeroHelper.getUnitsLengthFromString(unit)) == null) {
            this.psizeX = 1.0;
            this.psizeY = 1.0;
            logger.warn("The physical pixel size is not set for image " + datalocation + " ; a default value of 1 " + unit + " has been set");
        } else {
            this.psizeX = pixels.getPixelSizeX(OmeroHelper.getUnitsLengthFromString(unit)).getValue();
            this.psizeY = pixels.getPixelSizeY(OmeroHelper.getUnitsLengthFromString(unit)).getValue();
        }
        Length length = pixels.getPixelSizeZ(OmeroHelper.getUnitsLengthFromString(unit));
        this.psizeZ = length != null ? length.getValue() : 1.0;
        this.pixelType = OmeroOpener.getNumericType(pixels);
        ImageData imageData = OmeroOpener.getImageData(imageID, this.gateway, this.securityContext);
        this.format = imageData.asImage().getFormat().getValue().getValue();
        final String imageName = imageData.getName();
        if (!skipMeta) {
            double stagePosY;
            double stagePosX;
            List channelMetadata = ((MetadataFacility)this.gateway.getFacility(MetadataFacility.class)).getChannelData(this.securityContext, imageID);
            RenderingDef renderingDef = null;
            try {
                renderingDef = this.gateway.getRenderingSettingsService(this.securityContext).getRenderingSettings(this.pixelsID);
            }
            catch (Exception e) {
                logger.error("Couldn't get rendering definition.");
            }
            boolean isRGB = this.nChannels == 3 && this.pixelType instanceof UnsignedByteType;
            logger.debug("Begin SQL request for OMERO image with ID : " + imageID);
            List objectinfos = this.gateway.getQueryService(this.securityContext).findAllByQuery("select info from PlaneInfo as info join fetch info.deltaT as dt join fetch info.exposureTime as et where info.pixels.id=" + pixels.getId(), null);
            if (!objectinfos.isEmpty()) {
                PlaneInfo planeinfo = (PlaneInfo)objectinfos.get(0);
                if (planeinfo == null) {
                    logger.warn("The planeinfo is not set for the image " + imageName + " ; plane position set at origin ");
                    stagePosX = 0.0;
                    stagePosY = 0.0;
                } else if (planeinfo.getPositionX() == null) {
                    logger.warn("The planeinfo position is not set for the image " + imageName + " ; plane position set at origin ");
                    stagePosX = 0.0;
                    stagePosY = 0.0;
                } else if (planeinfo.getPositionX().getUnit() == null) {
                    logger.warn("The planeinfo position unit is not set for the image " + imageName + " ; plane position set at origin ");
                    stagePosX = 0.0;
                    stagePosY = 0.0;
                } else if (!planeinfo.getPositionX().getUnit().equals((Object)UnitsLength.REFERENCEFRAME)) {
                    stagePosX = new LengthI(planeinfo.getPositionX(), unit).getValue();
                    stagePosY = new LengthI(planeinfo.getPositionY(), unit).getValue();
                } else {
                    logger.warn("The pixel unit is not set for the image " + imageName + " ; a default unit " + unit + " has been set");
                    Length l1 = planeinfo.getPositionX();
                    Length l2 = planeinfo.getPositionY();
                    l1.setUnit(OmeroHelper.getUnitsLengthFromString(unit));
                    l2.setUnit(OmeroHelper.getUnitsLengthFromString(unit));
                    LengthI lengthPosX = new LengthI(l1, unit);
                    LengthI lengthPosY = new LengthI(l2, unit);
                    stagePosX = lengthPosX.getValue();
                    stagePosY = lengthPosY.getValue();
                }
            } else {
                stagePosX = 0.0;
                stagePosY = 0.0;
            }
            final List<ChannelProperties> channelPropertiesList = OmeroOpener.getChannelProperties(channelMetadata, renderingDef, this.nChannels, this.pixelType, isRGB);
            this.meta = new Opener.OpenerMeta(){

                @Override
                public String getImageName() {
                    return imageName;
                }

                @Override
                public AffineTransform3D getTransform() {
                    AffineTransform3D transform = new AffineTransform3D();
                    transform.identity();
                    transform.scale(OmeroOpener.this.psizeX, OmeroOpener.this.psizeY, OmeroOpener.this.psizeZ);
                    transform.translate(new double[]{stagePosX, stagePosY, 0.0});
                    return transform;
                }

                @Override
                public List<Entity> getEntities(int iChannel) {
                    ArrayList<Entity> entityList = new ArrayList<Entity>();
                    if (OmeroOpener.this.omeroImageID < Integer.MAX_VALUE) {
                        entityList.add((Entity)new OmeroHostId((int)OmeroOpener.this.omeroImageID, OmeroOpener.this.host + "/" + OmeroOpener.this.omeroImageID));
                    } else {
                        logger.error("Can't index the omeroid with an int, taking the modulo, and hoping for no overlap");
                        entityList.add((Entity)new OmeroHostId((int)(OmeroOpener.this.omeroImageID % Integer.MAX_VALUE), OmeroOpener.this.host + "/" + OmeroOpener.this.omeroImageID));
                    }
                    return entityList;
                }

                @Override
                public ChannelProperties getChannel(int iChannel) {
                    return (ChannelProperties)channelPropertiesList.get(iChannel);
                }
            };
        } else {
            this.meta = null;
        }
    }

    static List<ChannelProperties> getChannelProperties(List<ChannelData> channelMetadata, RenderingDef rd, int nChannels, Type<? extends NumericType<?>> pixType, Boolean isRGB) throws BigResult {
        ArrayList<ChannelProperties> channelPropertiesList = new ArrayList<ChannelProperties>();
        for (int i = 0; i < nChannels; ++i) {
            channelPropertiesList.add(new ChannelProperties(i).setNChannels(nChannels).setChannelColor(rd).setEmissionWavelength(channelMetadata.get(i)).setExcitationWavelength(channelMetadata.get(i)).setChannelName(channelMetadata.get(i)).setPixelType(pixType).setRGB(isRGB).setDynamicRange(rd));
        }
        return channelPropertiesList;
    }

    public static PixelsData getPixelsDataFromOmeroID(long imageID, Gateway gateway, SecurityContext ctx) throws Exception {
        ImageData image = OmeroOpener.getImageData(imageID, gateway, ctx);
        return image.getDefaultPixels();
    }

    public static ImageData getImageData(long imageID, Gateway gateway, SecurityContext ctx) throws Exception {
        BrowseFacility browse = (BrowseFacility)gateway.getFacility(BrowseFacility.class);
        return browse.getImage(ctx, imageID);
    }

    public RawPixelsStorePrx getNewStore() {
        try {
            RawPixelsStorePrx rawPixStore = this.gateway.getPixelsStore(this.securityContext);
            rawPixStore.setPixelsId(this.pixelsID, false);
            return rawPixStore;
        }
        catch (ServerError | DSOutOfServiceException serverError) {
            serverError.printStackTrace();
            return null;
        }
    }

    private static Type<? extends NumericType<?>> getNumericType(PixelsData pixels) {
        switch (pixels.getPixelType()) {
            case "float": {
                return new FloatType();
            }
            case "uint16": {
                return new UnsignedShortType();
            }
            case "uint8": {
                return new UnsignedByteType();
            }
            case "uint32": {
                return new UnsignedIntType();
            }
        }
        throw new IllegalStateException("Unsupported pixel type : " + pixels.getPixelType());
    }

    public Dimensions getDimension() {
        long sX = this.imageSize.get(0)[0];
        long sY = this.imageSize.get(0)[1];
        long sZ = this.imageSize.get(0)[2];
        return this.getDimension(sX, sY, sZ);
    }

    public Dimensions getDimension(long sX, long sY, long sZ) {
        final int numDimensions = 3;
        final long[] dims = new long[]{sX, sY, sZ};
        Dimensions dimensions = new Dimensions(){

            public void dimensions(long[] dimensions) {
                dimensions[0] = dims[0];
                dimensions[1] = dims[1];
                dimensions[2] = dims[2];
            }

            public long dimension(int d) {
                return dims[d];
            }

            public int numDimensions() {
                return numDimensions;
            }
        };
        return dimensions;
    }

    private static Volatile<?> getVolatileOf(NumericType<?> t) {
        if (t instanceof UnsignedShortType) {
            return new VolatileUnsignedShortType();
        }
        if (t instanceof IntType) {
            return new VolatileIntType();
        }
        if (t instanceof UnsignedByteType) {
            return new VolatileUnsignedByteType();
        }
        if (t instanceof FloatType) {
            return new VolatileFloatType();
        }
        if (t instanceof ARGBType) {
            return new VolatileARGBType();
        }
        System.err.println("Volatile type of pixel type " + t.getClass().getName() + " not found!");
        return null;
    }

    @Override
    public int getNumMipmapLevels() {
        return this.nMipmapLevels;
    }

    @Override
    public int getNTimePoints() {
        return this.nTimePoints;
    }

    @Override
    public ResourcePool<RawPixelsStorePrx> getPixelReader() {
        return this.pool;
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        final int numDimensions = 3;
        final double[] d = new double[]{this.psizeX, this.psizeY, this.psizeZ};
        assert (numDimensions == 3);
        VoxelDimensions voxelDimensions = new VoxelDimensions(){
            final double[] dims;
            {
                this.dims = new double[]{d[0], d[1], d[2]};
            }

            public String unit() {
                return OmeroOpener.this.unit;
            }

            public void dimensions(double[] doubles) {
                doubles[0] = this.dims[0];
                doubles[1] = this.dims[1];
                doubles[2] = this.dims[2];
            }

            public double dimension(int i) {
                return this.dims[i];
            }

            public int numDimensions() {
                return numDimensions;
            }
        };
        return voxelDimensions;
    }

    @Override
    public boolean isLittleEndian() {
        return false;
    }

    @Override
    public String getImageFormat() {
        return this.format;
    }

    @Override
    public OpenerSetupLoader<?, ?, ?> getSetupLoader(int channelIdx, int setupIdx, Supplier<VolatileGlobalCellCache> cacheSupplier) {
        return new OmeroSetupLoader(this, channelIdx, setupIdx, (NumericType)this.getPixelType(), OmeroOpener.getVolatileOf((NumericType)this.getPixelType()), cacheSupplier);
    }

    @Override
    public String getRawPixelDataKey() {
        return this.rawPixelDataKey;
    }

    @Override
    public Opener.OpenerMeta getMeta() {
        return this.meta;
    }

    @Override
    public int[] getCellDimensions(int level) {
        return new int[]{this.getTileSizeX(this.nMipmapLevels - 1 - level), this.getTileSizeY(this.nMipmapLevels - 1 - level), 1};
    }

    @Override
    public Dimensions[] getDimensions() {
        Dimensions[] dimensions = new Dimensions[this.nMipmapLevels];
        for (int level = 0; level < this.nMipmapLevels; ++level) {
            dimensions[level] = this.getDimension(this.getSizeX(level), this.getSizeY(level), this.getSizeZ(level));
        }
        return dimensions;
    }

    @Override
    public int getNChannels() {
        return this.nChannels;
    }

    @Override
    public Type<? extends NumericType<?>> getPixelType() {
        return this.pixelType;
    }

    @Override
    public void close() {
        this.pool.shutDown(store -> {
            try {
                if (this.gateway.isConnected()) {
                    store.close();
                }
            }
            catch (ServerError e) {
                e.printStackTrace();
            }
        });
    }

    public static class RawPixelsStorePool
    extends ResourcePool<RawPixelsStorePrx> {
        final Supplier<RawPixelsStorePrx> rpsSupplier;

        public RawPixelsStorePool(int size, Boolean dynamicCreation, Supplier<RawPixelsStorePrx> rawPixelStoreSupplier) {
            super(size, dynamicCreation);
            this.rpsSupplier = rawPixelStoreSupplier;
        }

        @Override
        protected RawPixelsStorePrx createObject() {
            return this.rpsSupplier.get();
        }
    }
}

