/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.omero;

import ch.epfl.biop.bdv.img.omero.command.OmeroConnectCommand;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.imagej.omero.OMEROServer;
import net.imagej.omero.OMEROService;
import net.imagej.omero.OMEROSession;
import omero.gateway.Gateway;
import omero.gateway.LoginCredentials;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.log.SimpleLogger;
import omero.model.enums.UnitsLength;
import org.apache.commons.lang.StringUtils;
import org.scijava.Context;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmeroHelper {
    protected static final Logger logger = LoggerFactory.getLogger(OmeroHelper.class);

    public static Gateway omeroConnect(String hostname, int port, String userName, String password) throws DSOutOfServiceException {
        LoginCredentials cred = new LoginCredentials();
        cred.getServer().setHost(hostname);
        cred.getServer().setPort(port);
        cred.getUser().setUsername(userName);
        cred.getUser().setPassword(password);
        SimpleLogger simpleLogger = new SimpleLogger();
        Gateway gateway = new Gateway((omero.log.Logger)simpleLogger);
        gateway.connect(cred);
        return gateway;
    }

    public static Collection<ImageData> getImagesFromDataset(Gateway gateway, long DatasetID) throws Exception {
        BrowseFacility browse = (BrowseFacility)gateway.getFacility(BrowseFacility.class);
        SecurityContext ctx = OmeroHelper.getSecurityContext(gateway);
        ArrayList<Long> datasetIds = new ArrayList<Long>();
        datasetIds.add(DatasetID);
        return browse.getImagesForDatasets(ctx, datasetIds);
    }

    public static SecurityContext getSecurityContext(Gateway gateway) {
        ExperimenterData exp = gateway.getLoggedInUser();
        long groupID = exp.getGroupId();
        return new SecurityContext(groupID);
    }

    public static UnitsLength getUnitsLengthFromString(String unit_string) {
        Field[] bfUnits;
        for (Field f : bfUnits = UnitsLength.class.getFields()) {
            if (!f.getType().equals(UnitsLength.class) || f.getName() == null) continue;
            try {
                if (!f.getName().equalsIgnoreCase(unit_string.trim())) continue;
                return (UnitsLength)f.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static OMEROSession getGatewayAndSecurityContext(Context context, String host) throws Exception {
        OMEROService omeroService = (OMEROService)context.getService(OMEROService.class);
        OMEROServer server = new OMEROServer(host, 4064);
        try {
            return omeroService.session(server);
        }
        catch (Exception e) {
            logger.info("The OMERO session for " + host + " needs to be initialized");
            CommandService command = (CommandService)context.getService(CommandService.class);
            boolean success = false;
            int iAttempt = 0;
            int nAttempts = 3;
            String lastErrorMessage = "";
            while (iAttempt < nAttempts && !success) {
                Exception error;
                ++iAttempt;
                try {
                    OmeroConnectCommand.message_in = lastErrorMessage.isEmpty() ? "<html>Please enter your " + host + " credentials:</html>" : "<html>Error:" + lastErrorMessage + "<br> Please re-enter your " + host + " credentials (" + iAttempt + "/" + nAttempts + "):</html>";
                    CommandModule module = (CommandModule)command.run(OmeroConnectCommand.class, true, new Object[]{"host", host}).get();
                    success = (Boolean)module.getOutput("success");
                    OMEROSession omeroSession = (OMEROSession)module.getOutput("omeroSession");
                    if (success) {
                        return omeroSession;
                    }
                    error = (Exception)module.getOutput("error");
                    if (error != null) {
                        lastErrorMessage = error.getMessage();
                    }
                }
                catch (Exception commandException) {
                    error = commandException;
                }
                if (success || iAttempt != nAttempts) continue;
                throw error;
            }
            return null;
        }
    }

    public static List<Long> getImageIDs(String omeroURL, Gateway gateway, SecurityContext ctx) throws ExecutionException, DSOutOfServiceException, DSAccessException, MalformedURLException {
        ArrayList<Long> imageIDs = new ArrayList<Long>();
        URL url = new URL(omeroURL);
        String query = url.getQuery();
        if (query.contains("show=image-")) {
            String[] parts = query.split("-");
            for (int i = 1; i < parts.length; ++i) {
                if (!parts[i].contains("image")) continue;
                String part = parts[i];
                String[] subParts = part.split("\\|image");
                imageIDs.add(Long.valueOf(subParts[0]));
            }
            imageIDs.add(Long.valueOf(parts[parts.length - 1]));
        } else if (query.contains("show=dataset-")) {
            String[] parts = query.split("-");
            for (int i = 1; i < parts.length; ++i) {
                if (!parts[i].contains("dataset")) continue;
                String[] subParts = parts[i].split("\\|dataset");
                long datasetID = Long.parseLong(subParts[0]);
                BrowseFacility browse = (BrowseFacility)gateway.getFacility(BrowseFacility.class);
                Collection images = browse.getImagesForDatasets(ctx, Collections.singletonList(datasetID));
                for (ImageData image : images) {
                    imageIDs.add(image.getId());
                }
            }
            long datasetID = Long.parseLong(parts[parts.length - 1]);
            BrowseFacility browse = (BrowseFacility)gateway.getFacility(BrowseFacility.class);
            Collection images = browse.getImagesForDatasets(ctx, Collections.singletonList(datasetID));
            for (ImageData image : images) {
                imageIDs.add(image.getId());
            }
        } else if (omeroURL.contains("img_detail")) {
            String[] parts = url.getFile().split("/");
            int index = OmeroHelper.findIndexOfStringInStringArray(parts, "img_detail") + 1;
            imageIDs.add(Long.valueOf(parts[index]));
        } else if (query.contains("images=")) {
            if (query.contains(",")) {
                String[] parts = query.split(",");
                imageIDs.add(Long.valueOf(parts[0].substring(parts[0].indexOf("=") + 1)));
                for (int i = 1; i < parts.length; ++i) {
                    imageIDs.add(Long.valueOf(parts[i]));
                }
            } else {
                String[] parts = query.split("&");
                imageIDs.add(Long.valueOf(parts[0].substring(parts[0].indexOf("=") + 1)));
            }
        } else {
            System.err.println("Can't parse OMERO URL " + omeroURL);
        }
        return imageIDs;
    }

    public static int findIndexOfStringInStringArray(String[] array, String pattern) {
        int idx = 0;
        for (String content : array) {
            if (StringUtils.contains((String)content, (String)pattern)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }
}

