/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.omero;

import bdv.img.cache.CacheArrayLoader;
import ch.epfl.biop.bdv.img.ResourcePool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;
import omero.api.RawPixelsStorePrx;

public class OmeroArrayLoaders {

    public static class OmeroIntArrayLoader
    extends OmeroArrayLoader
    implements CacheArrayLoader<VolatileIntArray> {
        final ByteOrder byteOrder;

        public OmeroIntArrayLoader(ResourcePool<RawPixelsStorePrx> pixelStorePool, int channel, int nResolutionLevels, int sx, int sy, int sz, boolean littleEndian) {
            super(pixelStorePool, channel, nResolutionLevels, sx, sy, sz);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileIntArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                RawPixelsStorePrx rawPixStore = (RawPixelsStorePrx)this.pixelStorePool.acquire();
                rawPixStore.setResolutionLevel(this.nResolutionLevels - 1 - level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], this.sx);
                int maxY = Math.min(minY + dimensions[1], this.sy);
                int maxZ = Math.min(minZ + dimensions[2], this.sz);
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 4);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = rawPixStore.getTile(z, this.channel, timepoint, minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.pixelStorePool.recycle(rawPixStore);
                int[] ints = new int[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asIntBuffer().get(ints);
                return new VolatileIntArray(ints, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    public static class OmeroRGBArrayLoader
    extends OmeroArrayLoader
    implements CacheArrayLoader<VolatileIntArray> {
        public OmeroRGBArrayLoader(ResourcePool<RawPixelsStorePrx> pixelStorePool, int channel, int nResolutionLevels, int sx, int sy, int sz) {
            super(pixelStorePool, channel, nResolutionLevels, sx, sy, sz);
        }

        public VolatileIntArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            throw new IllegalStateException("OMERO is not really supposed to give RGB images. But apparently that's the case. Please reach out to the developers to fix this!");
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    public static class OmeroFloatArrayLoader
    extends OmeroArrayLoader
    implements CacheArrayLoader<VolatileFloatArray> {
        final ByteOrder byteOrder;

        public OmeroFloatArrayLoader(ResourcePool<RawPixelsStorePrx> pixelStorePool, int channel, int nResolutionLevels, int sx, int sy, int sz, boolean littleEndian) {
            super(pixelStorePool, channel, nResolutionLevels, sx, sy, sz);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileFloatArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                RawPixelsStorePrx rawPixStore = (RawPixelsStorePrx)this.pixelStorePool.acquire();
                rawPixStore.setResolutionLevel(this.nResolutionLevels - 1 - level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], this.sx);
                int maxY = Math.min(minY + dimensions[1], this.sy);
                int maxZ = Math.min(minZ + dimensions[2], this.sz);
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 4);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = rawPixStore.getTile(z, this.channel, timepoint, minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.pixelStorePool.recycle(rawPixStore);
                float[] floats = new float[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asFloatBuffer().get(floats);
                return new VolatileFloatArray(floats, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    public static class OmeroUnsignedShortArrayLoader
    extends OmeroArrayLoader
    implements CacheArrayLoader<VolatileShortArray> {
        final ByteOrder byteOrder;

        public OmeroUnsignedShortArrayLoader(ResourcePool<RawPixelsStorePrx> pixelStorePool, int channel, int nResolutionLevels, int sx, int sy, int sz, boolean littleEndian) {
            super(pixelStorePool, channel, nResolutionLevels, sx, sy, sz);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileShortArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                RawPixelsStorePrx rawPixStore = (RawPixelsStorePrx)this.pixelStorePool.acquire();
                rawPixStore.setResolutionLevel(this.nResolutionLevels - 1 - level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], this.sx);
                int maxY = Math.min(minY + dimensions[1], this.sy);
                int maxZ = Math.min(minZ + dimensions[2], this.sz);
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 2);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = rawPixStore.getTile(z, this.channel, timepoint, minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.pixelStorePool.recycle(rawPixStore);
                short[] shorts = new short[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asShortBuffer().get(shorts);
                return new VolatileShortArray(shorts, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 2;
        }
    }

    public static class OmeroUnsignedByteArrayLoader
    extends OmeroArrayLoader
    implements CacheArrayLoader<VolatileByteArray> {
        public OmeroUnsignedByteArrayLoader(ResourcePool<RawPixelsStorePrx> pixelStorePool, int channel, int nResolutionLevels, int sx, int sy, int sz) {
            super(pixelStorePool, channel, nResolutionLevels, sx, sy, sz);
        }

        public VolatileByteArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                RawPixelsStorePrx rawPixStore = (RawPixelsStorePrx)this.pixelStorePool.acquire();
                rawPixStore.setResolutionLevel(this.nResolutionLevels - 1 - level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], this.sx);
                int maxY = Math.min(minY + dimensions[1], this.sy);
                int maxZ = Math.min(minZ + dimensions[2], this.sz);
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytesCurrentPlane = rawPixStore.getTile(z, this.channel, timepoint, minX, minY, w, h);
                    buffer.put(bytesCurrentPlane);
                }
                this.pixelStorePool.recycle(rawPixStore);
                return new VolatileByteArray(buffer.array(), true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 1;
        }
    }

    static abstract class OmeroArrayLoader {
        protected final ResourcePool<RawPixelsStorePrx> pixelStorePool;
        protected final int channel;
        protected final int nResolutionLevels;
        protected final int sx;
        protected final int sy;
        protected final int sz;

        public OmeroArrayLoader(ResourcePool<RawPixelsStorePrx> pixelStorePool, int channel, int nResolutionLevels, int sx, int sy, int sz) {
            this.pixelStorePool = pixelStorePool;
            this.channel = channel;
            this.nResolutionLevels = nResolutionLevels;
            this.sx = sx;
            this.sy = sy;
            this.sz = sz;
        }
    }
}

