/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.legacy.qupath;

import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsBdvOpener;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsTools;
import ch.epfl.biop.bdv.img.legacy.bioformats.entity.FileIndex;
import ch.epfl.biop.bdv.img.legacy.bioformats.entity.SeriesNumber;
import ch.epfl.biop.bdv.img.legacy.qupath.QuPathImageLoader;
import ch.epfl.biop.bdv.img.legacy.qupath.entity.QuPathEntryEntity;
import ch.epfl.biop.bdv.img.legacy.qupath.struct.MinimalQuPathProject;
import ch.epfl.biop.bdv.img.legacy.qupath.struct.ProjectIO;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.Tile;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spimdata.util.Displaysettings;

@Deprecated
public class QuPathToSpimData {
    protected static final Logger logger = LoggerFactory.getLogger(QuPathToSpimData.class);
    int viewSetupCounter = 0;
    int nTileCounter = 0;
    int maxTimepoints = -1;
    int channelCounter = 0;
    int fileIndexCounter = 0;
    final Map<Integer, Channel> channelIdToChannel = new HashMap<Integer, Channel>();
    final Map<BioFormatsTools.BioformatsChannel, Integer> channelToId = new HashMap<BioFormatsTools.BioformatsChannel, Integer>();
    final Map<URI, BioFormatsBdvOpener> openerMap = new HashMap<URI, BioFormatsBdvOpener>();
    final Map<URI, Integer> uriToFileIndexMap = new HashMap<URI, Integer>();
    final Map<Integer, QuPathImageLoader.QuPathEntryAndChannel> viewSetupToQuPathEntryAndChannel = new HashMap<Integer, QuPathImageLoader.QuPathEntryAndChannel>();
    final Map<Integer, MinimalQuPathProject.ImageEntry> viewSetupToImageEntry = new HashMap<Integer, MinimalQuPathProject.ImageEntry>();

    private int getChannelId(IMetadata omeMeta, int iSerie, int iChannel, boolean isRGB) {
        BioFormatsTools.BioformatsChannel channel = new BioFormatsTools.BioformatsChannel(omeMeta, iSerie, iChannel, false);
        if (!this.channelToId.containsKey(channel)) {
            this.channelToId.put(channel, this.channelCounter);
            logger.debug("New Channel for series " + iSerie + ", channel " + iChannel + ", set as number " + this.channelCounter);
            this.channelIdToChannel.put(this.channelCounter, new Channel(this.channelCounter));
            ++this.channelCounter;
        } else {
            logger.debug("Channel for series " + iSerie + ", channel " + iChannel + ", already known.");
        }
        int idChannel = this.channelIdToChannel.get(this.channelToId.get(channel)).getId();
        return idChannel;
    }

    public AbstractSpimData<?> getSpimDataInstance(URI quPathProject, BioFormatsBdvOpener openerModel) {
        this.viewSetupCounter = 0;
        this.nTileCounter = 0;
        this.maxTimepoints = -1;
        this.channelCounter = 0;
        Illumination dummy_ill = new Illumination(0);
        Angle dummy_ang = new Angle(0);
        ArrayList viewSetups = new ArrayList();
        try {
            JsonObject projectJson = ProjectIO.loadRawProject(new File(quPathProject));
            Gson gson = new Gson();
            MinimalQuPathProject project = (MinimalQuPathProject)gson.fromJson((JsonElement)projectJson, MinimalQuPathProject.class);
            logger.debug("Opening QuPath project " + project.uri);
            HashMap cachedReaders = new HashMap();
            project.images.forEach(image -> {
                logger.debug("Opening qupath image " + image);
                QuPathImageLoader.QuPathBioFormatsSourceIdentifier identifier = new QuPathImageLoader.QuPathBioFormatsSourceIdentifier();
                if (image.serverBuilder.builderType.equals("rotated")) {
                    String angleDegreesStr = image.serverBuilder.rotation.substring(7);
                    logger.debug("Rotated image server (" + angleDegreesStr + ")");
                    identifier.angleRotationZAxis = angleDegreesStr.equals("NONE") ? 0.0 : Double.parseDouble(angleDegreesStr) / 180.0 * Math.PI;
                    MinimalQuPathProject.ServerBuilderMetadata metadata = image.serverBuilder.metadata;
                    image.serverBuilder = image.serverBuilder.builder;
                    image.serverBuilder.metadata = metadata;
                }
                if (image.serverBuilder.builderType.equals("uri")) {
                    logger.debug("URI image server");
                    if (image.serverBuilder.providerClassName.equals("qupath.lib.images.servers.bioformats.BioFormatsServerBuilder")) {
                        try {
                            URI uri = new URI(image.serverBuilder.uri.getScheme(), image.serverBuilder.uri.getHost(), image.serverBuilder.uri.getPath(), null);
                            String filePath = Paths.get(uri).toString();
                            if (!this.openerMap.containsKey(image.serverBuilder.uri)) {
                                BioFormatsBdvOpener opener = new BioFormatsBdvOpener(openerModel).location(Paths.get(uri).toString());
                                opener = opener.ignoreMetadata();
                                this.openerMap.put(image.serverBuilder.uri, opener);
                                cachedReaders.put(opener, opener.getNewReader());
                                this.uriToFileIndexMap.put(image.serverBuilder.uri, this.fileIndexCounter);
                                ++this.fileIndexCounter;
                            }
                            identifier.uri = image.serverBuilder.uri;
                            identifier.sourceFile = filePath;
                            identifier.indexInQuPathProject = project.images.indexOf(image);
                            identifier.entryID = project.images.get((int)identifier.indexInQuPathProject).entryID;
                            int iSerie = image.serverBuilder.args.indexOf("--series");
                            Tile tile = new Tile(this.nTileCounter);
                            ++this.nTileCounter;
                            if (iSerie == -1) {
                                logger.error("Series not found in qupath project server builder!");
                                identifier.bioformatsIndex = -1;
                            } else {
                                identifier.bioformatsIndex = Integer.parseInt(image.serverBuilder.args.get(iSerie + 1));
                            }
                            logger.debug(identifier.toString());
                            BioFormatsBdvOpener opener = this.openerMap.get(image.serverBuilder.uri);
                            IFormatReader memo = (IFormatReader)cachedReaders.get(opener);
                            memo.setSeries(identifier.bioformatsIndex);
                            logger.debug("Number of Series : " + memo.getSeriesCount());
                            IMetadata omeMeta = (IMetadata)memo.getMetadataStore();
                            memo.setMetadataStore((MetadataStore)omeMeta);
                            logger.debug("\t Serie " + identifier.bioformatsIndex + " Number of timesteps = " + omeMeta.getPixelsSizeT(identifier.bioformatsIndex).getNumberValue().intValue());
                            logger.debug("\t Serie " + identifier.bioformatsIndex + " Number of channels = " + omeMeta.getChannelCount(identifier.bioformatsIndex));
                            IntStream channels = IntStream.range(0, omeMeta.getChannelCount(identifier.bioformatsIndex));
                            if (omeMeta.getPixelsSizeT(identifier.bioformatsIndex).getNumberValue().intValue() > this.maxTimepoints) {
                                this.maxTimepoints = omeMeta.getPixelsSizeT(identifier.bioformatsIndex).getNumberValue().intValue();
                            }
                            Dimensions dims = BioFormatsTools.getSeriesDimensions(omeMeta, identifier.bioformatsIndex);
                            logger.debug("X:" + dims.dimension(0) + " Y:" + dims.dimension(1) + " Z:" + dims.dimension(2));
                            VoxelDimensions voxDims = BioFormatsTools.getSeriesVoxelDimensions(omeMeta, identifier.bioformatsIndex, opener.u, opener.voxSizeReferenceFrameLength);
                            QuPathEntryEntity qpentry = new QuPathEntryEntity(identifier.entryID);
                            qpentry.setName(QuPathEntryEntity.getNameFromURIAndSerie(identifier.uri, identifier.bioformatsIndex));
                            qpentry.setQuPathProjectionLocation(Paths.get(quPathProject).toString());
                            channels.forEach(iCh -> {
                                QuPathImageLoader.QuPathEntryAndChannel usc = new QuPathImageLoader.QuPathEntryAndChannel(identifier, iCh);
                                this.viewSetupToQuPathEntryAndChannel.put(this.viewSetupCounter, usc);
                                int ch_id = this.getChannelId(omeMeta, identifier.bioformatsIndex, iCh, memo.isRGB());
                                String setupName = image.imageName + "_" + this.getChannelName(omeMeta, identifier.bioformatsIndex, iCh);
                                logger.debug(setupName);
                                ViewSetup vs = new ViewSetup(this.viewSetupCounter, setupName, dims, voxDims, tile, this.channelIdToChannel.get(ch_id), dummy_ang, dummy_ill);
                                this.viewSetupToImageEntry.put(this.viewSetupCounter, (MinimalQuPathProject.ImageEntry)image);
                                FileIndex fi = new FileIndex(this.uriToFileIndexMap.get(identifier.uri), identifier.sourceFile);
                                vs.setAttribute((Entity)fi);
                                SeriesNumber sn = new SeriesNumber(identifier.bioformatsIndex);
                                vs.setAttribute((Entity)sn);
                                vs.setAttribute((Entity)qpentry);
                                Displaysettings ds = new Displaysettings(this.viewSetupCounter);
                                ds.min = 0.0;
                                ds.max = 255.0;
                                ds.isSet = false;
                                ARGBType color = BioFormatsTools.getColorFromMetadata(omeMeta, identifier.bioformatsIndex, iCh);
                                ds.isSet = true;
                                ds.color = new int[]{ARGBType.red((int)color.get()), ARGBType.green((int)color.get()), ARGBType.blue((int)color.get()), ARGBType.alpha((int)color.get())};
                                vs.setAttribute((Entity)ds);
                                viewSetups.add(vs);
                                logger.debug("View Setup " + this.viewSetupCounter + " series " + iSerie + " channel " + iCh);
                                ++this.viewSetupCounter;
                            });
                        }
                        catch (URISyntaxException e) {
                            logger.error("URI Syntax error " + e.getMessage());
                            e.printStackTrace();
                        }
                    } else {
                        logger.error("Unsupported " + image.serverBuilder.providerClassName + " class name provider");
                        System.err.println("Unsupported " + image.serverBuilder.providerClassName + " class name provider");
                    }
                } else {
                    logger.error("Unsupported " + image.serverBuilder.builderType + " server builder");
                    System.err.println("Unsupported " + image.serverBuilder.builderType + " server builder");
                }
            });
            ArrayList timePoints = new ArrayList();
            IntStream.range(0, this.maxTimepoints).forEach(tp -> timePoints.add(new TimePoint(tp)));
            ArrayList registrations = new ArrayList();
            ArrayList missingViews = new ArrayList();
            for (int iViewSetup = 0; iViewSetup < this.viewSetupCounter; ++iViewSetup) {
                QuPathImageLoader.QuPathEntryAndChannel usc = this.viewSetupToQuPathEntryAndChannel.get(iViewSetup);
                BioFormatsBdvOpener opener = this.openerMap.get(usc.entry.uri);
                IFormatReader memo = (IFormatReader)cachedReaders.get(this.openerMap.get(usc.entry.uri));
                IMetadata omeMeta = (IMetadata)memo.getMetadataStore();
                int bfIndex = usc.entry.bioformatsIndex;
                int nTimepoints = omeMeta.getPixelsSizeT(bfIndex).getNumberValue().intValue();
                int vs = iViewSetup;
                AffineTransform3D affine = BioFormatsTools.getSeriesRootTransform(omeMeta, bfIndex, opener.u, opener.positionPreTransformMatrixArray, opener.positionPostTransformMatrixArray, opener.positionReferenceFrameLength, opener.positionIsImageCenter, opener.voxSizePreTransformMatrixArray, opener.voxSizePostTransformMatrixArray, opener.voxSizeReferenceFrameLength, opener.axesOfImageFlip);
                MinimalQuPathProject.PixelCalibrations pixelCalibrations = null;
                if (this.viewSetupToImageEntry.get(vs) != null && this.viewSetupToImageEntry.get((Object)Integer.valueOf((int)vs)).serverBuilder != null && this.viewSetupToImageEntry.get((Object)Integer.valueOf((int)vs)).serverBuilder.metadata != null) {
                    pixelCalibrations = this.viewSetupToImageEntry.get((Object)Integer.valueOf((int)vs)).serverBuilder.metadata.pixelCalibration;
                }
                boolean performQuPathRescaling = false;
                AffineTransform3D quPathRescaling = new AffineTransform3D();
                if (pixelCalibrations != null) {
                    Length defaultxPix;
                    MinimalQuPathProject.PixelCalibration pc;
                    double scaleX = 1.0;
                    double scaleY = 1.0;
                    double scaleZ = 1.0;
                    Length[] voxSizes = BioFormatsTools.getSeriesVoxelSizeAsLengths(omeMeta, bfIndex);
                    if (pixelCalibrations.pixelWidth != null) {
                        pc = pixelCalibrations.pixelWidth;
                        if (voxSizes[0] != null && voxSizes[0].value(UNITS.MICROMETER) != null) {
                            logger.debug("xVox size = " + pc.value + " micrometer");
                            scaleX = pc.value / voxSizes[0].value(UNITS.MICROMETER).doubleValue();
                        } else {
                            defaultxPix = new Length((Number)1, opener.u);
                            scaleX = pc.value / defaultxPix.value(UNITS.MICROMETER).doubleValue();
                            logger.debug("rescaling x");
                        }
                    }
                    if (pixelCalibrations.pixelHeight != null) {
                        pc = pixelCalibrations.pixelHeight;
                        if (voxSizes[1] != null && voxSizes[1].value(UNITS.MICROMETER) != null) {
                            scaleY = pc.value / voxSizes[1].value(UNITS.MICROMETER).doubleValue();
                        } else {
                            defaultxPix = new Length((Number)1, opener.u);
                            scaleY = pc.value / defaultxPix.value(UNITS.MICROMETER).doubleValue();
                            logger.debug("rescaling y");
                        }
                    }
                    if (pixelCalibrations.zSpacing != null) {
                        pc = pixelCalibrations.zSpacing;
                        if (voxSizes[2] != null && voxSizes[2].value(UNITS.MICROMETER) != null) {
                            scaleZ = pc.value / voxSizes[2].value(UNITS.MICROMETER).doubleValue();
                        } else if (voxSizes[2] == null) {
                            logger.warn("Null Z voxel size");
                        }
                    }
                    logger.debug("ScaleX: " + scaleX + " scaleY:" + scaleY + " scaleZ:" + scaleZ);
                    if (Math.abs(scaleX - 1.0) > 1.0E-4 || Math.abs(scaleY - 1.0) > 1.0E-4 || Math.abs(scaleZ - 1.0) > 1.0E-4) {
                        logger.debug("Perform QuPath rescaling");
                        quPathRescaling.scale(scaleX, scaleY, scaleZ);
                        double oX = affine.get(0, 3);
                        double oY = affine.get(1, 3);
                        double oZ = affine.get(2, 3);
                        affine.preConcatenate(quPathRescaling);
                        affine.set(oX, 0, 3);
                        affine.set(oY, 1, 3);
                        affine.set(oZ, 2, 3);
                    }
                }
                logger.debug("ViewSetup : " + vs + " append view registrations ");
                timePoints.forEach(iTp -> {
                    if (iTp.getId() < nTimepoints) {
                        registrations.add(new ViewRegistration(iTp.getId(), vs, affine));
                    } else {
                        missingViews.add(new ViewId(iTp.getId(), vs));
                    }
                });
            }
            cachedReaders.values().forEach(reader -> {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            SequenceDescription sd = new SequenceDescription(new TimePoints(timePoints), viewSetups, null, new MissingViews(missingViews));
            sd.setImgLoader((BasicImgLoader)new QuPathImageLoader(quPathProject, openerModel, (AbstractSequenceDescription<?, ?, ?>)sd, openerModel.nFetcherThread, openerModel.numPriorities));
            SpimData spimData = new SpimData((File)null, sd, new ViewRegistrations(registrations));
            return spimData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getChannelName(IMetadata omeMeta, int iSerie, int iCh) {
        String channelName = omeMeta.getChannelName(iSerie, iCh);
        channelName = channelName == null || channelName.equals("") ? "ch" + iCh : channelName;
        return channelName;
    }

    private String getImageName(String dataLocation, int seriesCount, IMetadata omeMeta, int iSerie) {
        String imageName = omeMeta.getImageName(iSerie);
        String fileNameWithoutExtension = FilenameUtils.removeExtension((String)new File(dataLocation).getName());
        fileNameWithoutExtension = fileNameWithoutExtension.replace(".ome", "");
        imageName = imageName == null || imageName.equals("") ? fileNameWithoutExtension : imageName;
        imageName = seriesCount > 1 ? imageName + "-s" + iSerie : imageName;
        return imageName;
    }
}

