/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.legacy.qupath;

import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.cache.SharedQueue;
import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsBdvOpener;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsImageLoader;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsSetupLoader;
import ch.epfl.biop.bdv.img.legacy.qupath.struct.MinimalQuPathProject;
import ch.epfl.biop.bdv.img.legacy.qupath.struct.ProjectIO;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.MultiResolutionImgLoader;
import net.imglib2.Volatile;
import net.imglib2.cache.queue.BlockingFetchQueues;
import net.imglib2.type.numeric.NumericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class QuPathImageLoader
implements ViewerImgLoader,
MultiResolutionImgLoader,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(QuPathImageLoader.class);
    final AbstractSequenceDescription<?, ?, ?> sequenceDescription;
    VolatileGlobalCellCache cache;
    protected SharedQueue sq;
    final Map<Integer, BioFormatsSetupLoader<?, ?, ?>> imgLoaders = new ConcurrentHashMap();
    final Map<URI, BioFormatsBdvOpener> openerMap = new HashMap<URI, BioFormatsBdvOpener>();
    public final int numFetcherThreads;
    public final int numPriorities;
    int viewSetupCounter = 0;
    final Map<Integer, NumericType<?>> tTypeGetter = new HashMap();
    Map<Integer, Volatile<?>> vTypeGetter = new HashMap();
    final Map<Integer, QuPathEntryAndChannel> viewSetupToQuPathEntryAndChannel = new HashMap<Integer, QuPathEntryAndChannel>();
    final URI quPathProject;
    final BioFormatsBdvOpener openerModel;

    public QuPathImageLoader(URI quPathProject, BioFormatsBdvOpener openerModel, AbstractSequenceDescription<?, ?, ?> sequenceDescription, int numFetcherThreads, int numPriorities) {
        this.quPathProject = quPathProject;
        this.openerModel = openerModel;
        this.sequenceDescription = sequenceDescription;
        this.numFetcherThreads = numFetcherThreads;
        this.numPriorities = numPriorities;
        this.sq = new SharedQueue(numFetcherThreads, numPriorities);
        this.cache = new VolatileGlobalCellCache((BlockingFetchQueues)this.sq);
        try {
            JsonObject projectJson = ProjectIO.loadRawProject(new File(quPathProject));
            Gson gson = new Gson();
            MinimalQuPathProject project = (MinimalQuPathProject)gson.fromJson((JsonElement)projectJson, MinimalQuPathProject.class);
            logger.debug("Opening QuPath project " + project.uri);
            HashMap cachedReaders = new HashMap();
            project.images.forEach(image -> {
                logger.debug("Opening qupath image " + image);
                QuPathBioFormatsSourceIdentifier identifier = new QuPathBioFormatsSourceIdentifier();
                if (image.serverBuilder.builderType.equals("rotated")) {
                    String angleDegreesStr = image.serverBuilder.rotation.substring(7);
                    logger.debug("Rotated image server (" + angleDegreesStr + ")");
                    identifier.angleRotationZAxis = angleDegreesStr.equals("NONE") ? 0.0 : Double.parseDouble(angleDegreesStr) / 180.0 * Math.PI;
                    image.serverBuilder = image.serverBuilder.builder;
                }
                if (image.serverBuilder.builderType.equals("uri")) {
                    logger.debug("URI image server");
                    if (image.serverBuilder.providerClassName.equals("qupath.lib.images.servers.bioformats.BioFormatsServerBuilder")) {
                        try {
                            BioFormatsBdvOpener opener;
                            URI uri = new URI(image.serverBuilder.uri.getScheme(), image.serverBuilder.uri.getHost(), image.serverBuilder.uri.getPath(), null);
                            String filePath = Paths.get(uri).toString();
                            if (!this.openerMap.containsKey(image.serverBuilder.uri)) {
                                String location = Paths.get(uri).toString();
                                logger.debug("Creating opener for data location " + location);
                                opener = new BioFormatsBdvOpener(openerModel).location(location);
                                opener.setCache(this.sq);
                                this.openerMap.put(image.serverBuilder.uri, opener);
                                cachedReaders.put(opener, opener.getNewReader());
                            }
                            identifier.uri = image.serverBuilder.uri;
                            identifier.sourceFile = filePath;
                            identifier.indexInQuPathProject = project.images.indexOf(image);
                            identifier.entryID = project.images.get((int)identifier.indexInQuPathProject).entryID;
                            int iSerie = image.serverBuilder.args.indexOf("--series");
                            if (iSerie == -1) {
                                logger.error("Series not found in qupath project server builder!");
                                identifier.bioformatsIndex = -1;
                            } else {
                                identifier.bioformatsIndex = Integer.parseInt(image.serverBuilder.args.get(iSerie + 1));
                            }
                            logger.debug(identifier.toString());
                            opener = this.openerMap.get(image.serverBuilder.uri);
                            IFormatReader memo = (IFormatReader)cachedReaders.get(opener);
                            memo.setSeries(identifier.bioformatsIndex);
                            logger.debug("Number of Series : " + memo.getSeriesCount());
                            IMetadata omeMeta = (IMetadata)memo.getMetadataStore();
                            memo.setMetadataStore((MetadataStore)omeMeta);
                            logger.debug("\t Serie " + identifier.bioformatsIndex + " Number of timesteps = " + omeMeta.getPixelsSizeT(identifier.bioformatsIndex).getNumberValue().intValue());
                            logger.debug("\t Serie " + identifier.bioformatsIndex + " Number of channels = " + omeMeta.getChannelCount(identifier.bioformatsIndex));
                            IntStream channels = IntStream.range(0, omeMeta.getChannelCount(identifier.bioformatsIndex));
                            NumericType<?> t = BioFormatsImageLoader.getBioformatsBdvSourceType(memo, identifier.bioformatsIndex);
                            Volatile v = BioFormatsImageLoader.getVolatileOf(t);
                            channels.forEach(iCh -> {
                                QuPathEntryAndChannel usc = new QuPathEntryAndChannel(identifier, iCh);
                                this.viewSetupToQuPathEntryAndChannel.put(this.viewSetupCounter, usc);
                                this.tTypeGetter.put(this.viewSetupCounter, (NumericType)t);
                                this.vTypeGetter.put(this.viewSetupCounter, v);
                                ++this.viewSetupCounter;
                            });
                        }
                        catch (URISyntaxException e) {
                            logger.error("URI Syntax error " + e.getMessage());
                            e.printStackTrace();
                        }
                    } else {
                        logger.error("Unsupported " + image.serverBuilder.providerClassName + " class name provider");
                    }
                } else {
                    logger.error("Unsupported " + image.serverBuilder.builderType + " server builder");
                }
            });
            cachedReaders.values().forEach(reader -> {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            logger.error("Exception " + e.getMessage());
            e.printStackTrace();
        }
    }

    public BioFormatsSetupLoader<?, ?, ?> getSetupImgLoader(int setupId) {
        if (this.imgLoaders.containsKey(setupId)) {
            return this.imgLoaders.get(setupId);
        }
        QuPathEntryAndChannel qec = this.viewSetupToQuPathEntryAndChannel.get(setupId);
        BioFormatsBdvOpener opener = this.openerMap.get(qec.entry.uri);
        int iS = qec.entry.bioformatsIndex;
        int iC = qec.iChannel;
        logger.debug("loading qupath entry number = " + qec.entry + "setupId = " + setupId + " series" + iS + " channel " + iC);
        BioFormatsSetupLoader imgL = null;
        try {
            imgL = new BioFormatsSetupLoader(opener, iS, iC, setupId, this.tTypeGetter.get(setupId), this.vTypeGetter.get(setupId), () -> this.cache);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.imgLoaders.put(setupId, imgL);
        return imgL;
    }

    public CacheControl getCacheControl() {
        return this.cache;
    }

    public URI getProjectURI() {
        return this.quPathProject;
    }

    public BioFormatsBdvOpener getModelOpener() {
        return this.openerModel;
    }

    @Override
    public void close() {
        this.openerMap.values().forEach(opener -> opener.getReaderPool().shutDown(reader -> {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        this.cache.clearCache();
        this.sq.shutdown();
    }

    public static class QuPathEntryAndChannel {
        public final QuPathBioFormatsSourceIdentifier entry;
        public final int iChannel;

        public QuPathEntryAndChannel(QuPathBioFormatsSourceIdentifier entry, int iChannel) {
            this.entry = entry;
            this.iChannel = iChannel;
        }
    }

    public static class QuPathBioFormatsSourceIdentifier {
        int indexInQuPathProject;
        int entryID;
        String sourceFile;
        int bioformatsIndex;
        double angleRotationZAxis = 0.0;
        URI uri;

        public String toString() {
            String str = "";
            str = str + "sourceFile:" + this.sourceFile + "[bf:" + this.bioformatsIndex + " - qp:" + this.indexInQuPathProject + "]";
            return str;
        }
    }
}

