/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.legacy.bioformats.command;

import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsBdvOpener;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsTools;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;

@Deprecated
public class BioformatsBigdataviewerBridgeDatasetCommand
implements Command {
    @Parameter(required=false, label="Physical units of the dataset", choices={"MILLIMETER", "MICROMETER", "NANOMETER"})
    public String unit = "MILLIMETER";
    @Parameter(required=false, label="Split RGB channels")
    public boolean splitrgbchannels = false;
    @Parameter(required=false, choices={"AUTO", "TRUE", "FALSE"})
    public String positioniscenter = "AUTO";
    @Parameter(required=false, choices={"AUTO", "TRUE", "FALSE"})
    public String switchzandc = "AUTO";
    @Parameter(required=false, choices={"AUTO", "TRUE", "FALSE"})
    public String flippositionx = "AUTO";
    @Parameter(required=false, choices={"AUTO", "TRUE", "FALSE"})
    public String flippositiony = "AUTO";
    @Parameter(required=false, choices={"AUTO", "TRUE", "FALSE"})
    public String flippositionz = "AUTO";
    @Parameter(required=false)
    public boolean usebioformatscacheblocksize = true;
    @Parameter(required=false)
    public int cachesizex = 512;
    @Parameter(required=false)
    public int cachesizey = 512;
    @Parameter(required=false)
    public int cachesizez = 1;
    @Parameter(required=false)
    public int numberofblockskeptinmemory = -1;
    @Parameter(required=false, label="Reference frame size in unit (position)")
    public double refframesizeinunitlocation = 1.0;
    @Parameter(required=false, label="Reference frame size in unit (voxel size)")
    public double refframesizeinunitvoxsize = 1.0;

    public static Map<String, Object> getDefaultParameters() {
        HashMap<String, Object> def = new HashMap<String, Object>();
        def.put("unit", "MILLIMETER");
        def.put("splitrgbchannels", false);
        def.put("positioniscenter", "AUTO");
        def.put("switchzandc", "AUTO");
        def.put("flippositionx", "AUTO");
        def.put("flippositiony", "AUTO");
        def.put("flippositionz", "AUTO");
        def.put("usebioformatscacheblocksize", true);
        def.put("cachesizex", 512);
        def.put("cachesizey", 512);
        def.put("cachesizez", 1);
        def.put("refframesizeinunitlocation", 1);
        def.put("refframesizeinunitvoxsize", 1);
        def.put("numberofblockskeptinmemory", -1);
        return def;
    }

    public BioFormatsBdvOpener getOpener(String datalocation) {
        Unit<Length> bfUnit = BioFormatsTools.getUnitFromString(this.unit);
        Length positionReferenceFrameLength = new Length((Number)this.refframesizeinunitlocation, bfUnit);
        Length voxSizeReferenceFrameLength = new Length((Number)this.refframesizeinunitvoxsize, bfUnit);
        BioFormatsBdvOpener opener = BioFormatsBdvOpener.getOpener().location(datalocation).unit(this.unit).auto().ignoreMetadata();
        if (!this.switchzandc.equals("AUTO")) {
            opener = opener.switchZandC(this.switchzandc.equals("TRUE"));
        }
        if (!this.usebioformatscacheblocksize) {
            opener = opener.cacheBlockSize(this.cachesizex, this.cachesizey, this.cachesizez);
        }
        if (this.numberofblockskeptinmemory > 0) {
            opener = opener.cacheBounded(this.numberofblockskeptinmemory);
        }
        if (!this.positioniscenter.equals("AUTO")) {
            opener = this.positioniscenter.equals("TRUE") ? opener.centerPositionConvention() : opener.cornerPositionConvention();
        }
        if (!this.flippositionx.equals("AUTO") && this.flippositionx.equals("TRUE")) {
            opener = opener.flipPositionX();
        }
        if (!this.flippositiony.equals("AUTO") && this.flippositiony.equals("TRUE")) {
            opener = opener.flipPositionY();
        }
        if (!this.flippositionz.equals("AUTO") && this.flippositionz.equals("TRUE")) {
            opener = opener.flipPositionZ();
        }
        opener = opener.unit(this.unit);
        opener = opener.positionReferenceFrameLength(positionReferenceFrameLength);
        opener = opener.voxSizeReferenceFrameLength(voxSizeReferenceFrameLength);
        if (this.splitrgbchannels) {
            opener = opener.splitRGBChannels();
        }
        return opener;
    }

    public BioFormatsBdvOpener getOpener(File f) {
        return this.getOpener(f.getAbsolutePath());
    }

    public void run() {
    }
}

