/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.legacy.bioformats;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Color;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BioFormatsTools {
    protected static final Logger logger = LoggerFactory.getLogger(BioFormatsTools.class);
    static final int[] loopR = new int[]{1, 0, 0, 1, 1, 1, 0};
    static final int[] loopG = new int[]{0, 1, 0, 1, 1, 0, 1};
    static final int[] loopB = new int[]{0, 0, 1, 1, 0, 1, 1};

    public static Length[] getSeriesPositionAsLengths(IMetadata omeMeta, int iSerie) {
        Length[] pos = new Length[3];
        try {
            pos[0] = omeMeta.getPlanePositionX(iSerie, 0) != null ? omeMeta.getPlanePositionX(iSerie, 0) : new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[1] = omeMeta.getPlanePositionY(iSerie, 0) != null ? omeMeta.getPlanePositionY(iSerie, 0) : new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[2] = omeMeta.getPlanePositionZ(iSerie, 0) != null ? omeMeta.getPlanePositionZ(iSerie, 0) : new Length((Number)0, UNITS.REFERENCEFRAME);
        }
        catch (Exception e) {
            logger.warn("Could not access omeMeta.getPlanePosition serie " + iSerie);
            pos[0] = new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[1] = new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[2] = new Length((Number)0, UNITS.REFERENCEFRAME);
        }
        logger.debug("Ch Name=" + omeMeta.getChannelName(iSerie, 0));
        logger.debug("pos[0]=" + pos[0].value() + " " + pos[0].unit().getSymbol());
        logger.debug("pos[1]=" + pos[1].value() + " " + pos[1].unit().getSymbol());
        logger.debug("pos[2]=" + pos[2].value() + " " + pos[2].unit().getSymbol());
        return pos;
    }

    public static Length[] getSeriesVoxelSizeAsLengths(IMetadata omeMeta, int iSerie) {
        Length[] vox = new Length[]{omeMeta.getPixelsPhysicalSizeX(iSerie) != null ? omeMeta.getPixelsPhysicalSizeX(iSerie) : new Length((Number)1, UNITS.REFERENCEFRAME), omeMeta.getPixelsPhysicalSizeY(iSerie) != null ? omeMeta.getPixelsPhysicalSizeY(iSerie) : new Length((Number)1, UNITS.REFERENCEFRAME), omeMeta.getPixelsPhysicalSizeZ(iSerie) != null ? omeMeta.getPixelsPhysicalSizeZ(iSerie) : new Length((Number)1, UNITS.REFERENCEFRAME)};
        logger.debug("Ch Name=" + omeMeta.getChannelName(iSerie, 0));
        logger.debug("vox[0]=" + vox[0].value() + " " + vox[0].unit().getSymbol());
        logger.debug("vox[1]=" + vox[1].value() + " " + vox[1].unit().getSymbol());
        logger.debug("vox[2]=" + vox[2].value() + " " + vox[2].unit().getSymbol());
        return vox;
    }

    public static AffineTransform3D getSeriesRootTransform(IMetadata omeMeta, int iSerie, Unit<Length> u, double[] positionPreTransformMA, double[] positionPostTransformMA, Length positionReferenceFrameLength, boolean positionIsImageCenter, double[] voxSizePreTransformMA, double[] voxSizePostTransformMA, Length voxSizeReferenceFrameLength, boolean[] axesFlip) {
        AffineTransform3D positionPreTransform = null;
        if (positionPreTransformMA != null) {
            positionPreTransform = new AffineTransform3D();
            positionPreTransform.set(positionPreTransformMA);
        }
        AffineTransform3D positionPostTransform = null;
        if (positionPostTransformMA != null) {
            positionPostTransform = new AffineTransform3D();
            positionPostTransform.set(positionPostTransformMA);
        }
        AffineTransform3D voxSizePreTransform = null;
        if (voxSizePreTransformMA != null) {
            voxSizePreTransform = new AffineTransform3D();
            voxSizePreTransform.set(voxSizePreTransformMA);
        }
        AffineTransform3D voxSizePostTransform = null;
        if (voxSizePreTransformMA != null) {
            voxSizePostTransform = new AffineTransform3D();
            voxSizePostTransform.set(voxSizePostTransformMA);
        }
        return BioFormatsTools.getSeriesRootTransform(omeMeta, iSerie, u, positionPreTransform, positionPostTransform, positionReferenceFrameLength, positionIsImageCenter, voxSizePreTransform, voxSizePostTransform, voxSizeReferenceFrameLength, axesFlip);
    }

    public static AffineTransform3D getSeriesRootTransform(IMetadata omeMeta, int iSerie, Unit<Length> u, AffineTransform3D positionPreTransform, AffineTransform3D positionPostTransform, Length positionReferenceFrameLength, boolean positionIsImageCenter, AffineTransform3D voxSizePreTransform, AffineTransform3D voxSizePostTransform, Length voxSizeReferenceFrameLength, boolean[] axesFlip) {
        Length[] voxSize = BioFormatsTools.getSeriesVoxelSizeAsLengths(omeMeta, iSerie);
        double[] d = new double[3];
        for (int iDimension = 0; iDimension < 3; ++iDimension) {
            if (voxSize[iDimension].unit() != null && voxSize[iDimension].unit().isConvertible(u).booleanValue()) {
                d[iDimension] = voxSize[iDimension].value(u).doubleValue();
                continue;
            }
            if (voxSize[iDimension].unit().getSymbol().equals("reference frame")) {
                Length l = new Length((Number)(voxSize[iDimension].value().doubleValue() * voxSizeReferenceFrameLength.value().doubleValue()), voxSizeReferenceFrameLength.unit());
                d[iDimension] = l.value(u).doubleValue();
                continue;
            }
            d[iDimension] = 1.0;
        }
        Length[] pos = BioFormatsTools.getSeriesPositionAsLengths(omeMeta, iSerie);
        double[] p = new double[3];
        Dimensions dims = BioFormatsTools.getSeriesDimensions(omeMeta, iSerie);
        for (int iDimension = 0; iDimension < 3; ++iDimension) {
            if (pos[iDimension].unit() != null && pos[iDimension].unit().isConvertible(u).booleanValue()) {
                p[iDimension] = pos[iDimension].value(u).doubleValue();
                continue;
            }
            if (pos[iDimension].unit().getSymbol().equals("reference frame")) {
                Length l = new Length((Number)(pos[iDimension].value().doubleValue() * positionReferenceFrameLength.value().doubleValue()), positionReferenceFrameLength.unit());
                p[iDimension] = l.value(u).doubleValue();
                continue;
            }
            p[iDimension] = 0.0;
        }
        AffineTransform3D translateFwd = new AffineTransform3D();
        translateFwd.translate(new double[]{-((double)dims.dimension(0) / 2.0), -((double)dims.dimension(1) / 2.0), -((double)dims.dimension(2) / 2.0)});
        AffineTransform3D translateBwd = new AffineTransform3D();
        translateBwd.translate(new double[]{(double)dims.dimension(0) / 2.0, (double)dims.dimension(1) / 2.0, (double)dims.dimension(2) / 2.0});
        AffineTransform3D flip = new AffineTransform3D();
        flip.scale(axesFlip[0] ? -1.0 : 1.0, axesFlip[1] ? -1.0 : 1.0, axesFlip[2] ? -1.0 : 1.0);
        AffineTransform3D scaleVox = new AffineTransform3D();
        scaleVox.scale(d[0], d[1], d[2]);
        AffineTransform3D position = new AffineTransform3D();
        position.translate(new double[]{p[0], p[1], p[2]});
        AffineTransform3D rootTransform = new AffineTransform3D();
        if (positionPostTransform != null) {
            rootTransform.concatenate(positionPostTransform);
        }
        rootTransform.concatenate(position);
        if (positionPreTransform != null) {
            rootTransform.concatenate(positionPreTransform);
        }
        if (voxSizePostTransform != null) {
            rootTransform.concatenate(voxSizePostTransform);
        }
        rootTransform.concatenate(scaleVox);
        if (positionIsImageCenter) {
            rootTransform.concatenate(translateFwd);
        }
        rootTransform.concatenate(translateBwd);
        rootTransform.concatenate(flip);
        rootTransform.concatenate(translateFwd);
        if (voxSizePreTransform != null) {
            rootTransform.concatenate(voxSizePreTransform);
        }
        return rootTransform;
    }

    public static VoxelDimensions getSeriesVoxelDimensions(IMetadata omeMeta, int iSerie, final Unit<Length> u, Length voxSizeReferenceFrameLength) {
        final int numDimensions = 3;
        Length[] voxSize = BioFormatsTools.getSeriesVoxelSizeAsLengths(omeMeta, iSerie);
        final double[] d = new double[3];
        for (int iDimension = 0; iDimension < 3; ++iDimension) {
            if (voxSize[iDimension].unit() != null && voxSize[iDimension].unit().isConvertible(u).booleanValue()) {
                d[iDimension] = voxSize[iDimension].value(u).doubleValue();
                continue;
            }
            if (voxSize[iDimension].unit().getSymbol().equals("reference frame")) {
                Length l = new Length((Number)(voxSize[iDimension].value().doubleValue() * voxSizeReferenceFrameLength.value().doubleValue()), voxSizeReferenceFrameLength.unit());
                d[iDimension] = l.value(u).doubleValue();
                continue;
            }
            d[iDimension] = 1.0;
        }
        VoxelDimensions voxelDimensions = new VoxelDimensions(){
            final Unit<Length> targetUnit;
            final double[] dims;
            {
                this.targetUnit = u;
                this.dims = new double[]{d[0], d[1], d[2]};
            }

            public String unit() {
                return this.targetUnit.getSymbol();
            }

            public void dimensions(double[] doubles) {
                doubles[0] = this.dims[0];
                doubles[1] = this.dims[1];
                doubles[2] = this.dims[2];
            }

            public double dimension(int i) {
                return this.dims[i];
            }

            public int numDimensions() {
                return numDimensions;
            }
        };
        return voxelDimensions;
    }

    public static Dimensions getSeriesDimensions(IMetadata omeMeta, int iSerie) {
        final int numDimensions = 3;
        int sX = omeMeta.getPixelsSizeX(iSerie).getNumberValue().intValue();
        int sY = omeMeta.getPixelsSizeY(iSerie).getNumberValue().intValue();
        int sZ = omeMeta.getPixelsSizeZ(iSerie).getNumberValue().intValue();
        final long[] dims = new long[]{sX, sY, sZ};
        Dimensions dimensions = new Dimensions(){

            public void dimensions(long[] dimensions) {
                dimensions[0] = dims[0];
                dimensions[1] = dims[1];
                dimensions[2] = dims[2];
            }

            public long dimension(int d) {
                return dims[d];
            }

            public int numDimensions() {
                return numDimensions;
            }
        };
        return dimensions;
    }

    public static ArrayList<Pair<Integer, ArrayList<Integer>>> getListOfSeriesAndChannels(IFormatReader reader, String code) {
        ArrayList<Pair<Integer, ArrayList<Integer>>> listOfSources = BioFormatsTools.commaSeparatedListToArrayOfArray(code, idxSeries -> idxSeries >= 0 ? idxSeries : reader.getSeriesCount() + idxSeries, (idxSeries, idxChannel) -> idxChannel >= 0 ? idxChannel : ((IMetadata)reader.getMetadataStore()).getChannelCount(idxSeries.intValue()) + idxChannel);
        return listOfSources;
    }

    public static ArrayList<Pair<Integer, ArrayList<Integer>>> commaSeparatedListToArrayOfArray(String expression, Function<Integer, Integer> fbounds, BiFunction<Integer, Integer, Integer> f) {
        String[] splitIndexes = expression.split(";");
        ArrayList<Pair<Integer, ArrayList<Integer>>> arrayOfArrayOfIndexes = new ArrayList<Pair<Integer, ArrayList<Integer>>>();
        for (String str : splitIndexes) {
            String seriesIdentifier = str = str.trim();
            String channelIdentifier = "*";
            if (str.contains(".")) {
                String[] boundIndex = str.split("\\.");
                if (boundIndex.length == 2) {
                    seriesIdentifier = boundIndex[0];
                    channelIdentifier = boundIndex[1];
                } else {
                    logger.warn("Number format problem with expression:" + str + " - Expression ignored");
                    break;
                }
            }
            try {
                int idxCp;
                int indexMax;
                int indexMin;
                if (seriesIdentifier.trim().equals("*")) {
                    int maxIndex = fbounds.apply(-1);
                    int index = 0;
                    while (index <= maxIndex) {
                        MutablePair current = new MutablePair();
                        int idxCp2 = index++;
                        current.setLeft((Object)idxCp2);
                        current.setRight(BioFormatsTools.expressionToArray(channelIdentifier, i -> (Integer)f.apply(idxCp2, (Integer)i)));
                        arrayOfArrayOfIndexes.add((Pair<Integer, ArrayList<Integer>>)current);
                    }
                    continue;
                }
                if (seriesIdentifier.trim().contains(":")) {
                    String[] boundIndex = seriesIdentifier.split(":");
                    assert (boundIndex.length == 2);
                    indexMin = fbounds.apply(Integer.valueOf(boundIndex[0].trim()));
                    indexMax = fbounds.apply(Integer.valueOf(boundIndex[1].trim()));
                } else {
                    indexMax = indexMin = fbounds.apply(Integer.valueOf(seriesIdentifier.trim())).intValue();
                }
                if (indexMax >= indexMin) {
                    for (int index = indexMin; index <= indexMax; ++index) {
                        MutablePair current = new MutablePair();
                        idxCp = index;
                        current.setLeft((Object)index);
                        current.setRight(BioFormatsTools.expressionToArray(channelIdentifier, i -> (Integer)f.apply(idxCp, (Integer)i)));
                        arrayOfArrayOfIndexes.add((Pair<Integer, ArrayList<Integer>>)current);
                    }
                    continue;
                }
                for (int index = indexMax; index >= indexMin; --index) {
                    MutablePair current = new MutablePair();
                    idxCp = index;
                    current.setLeft((Object)index);
                    current.setRight(BioFormatsTools.expressionToArray(channelIdentifier, i -> (Integer)f.apply(idxCp, (Integer)i)));
                    arrayOfArrayOfIndexes.add((Pair<Integer, ArrayList<Integer>>)current);
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Number format problem with expression:" + str + " - Expression ignored");
            }
        }
        return arrayOfArrayOfIndexes;
    }

    public static ArrayList<Integer> expressionToArray(String expression, Function<Integer, Integer> fbounds) {
        String[] splitIndexes = expression.split(",");
        ArrayList<Integer> arrayOfIndexes = new ArrayList<Integer>();
        for (String str : splitIndexes) {
            if ((str = str.trim()).contains(":")) {
                String[] boundIndex = str.split(":");
                if (boundIndex.length == 2) {
                    try {
                        int index;
                        int b1 = fbounds.apply(Integer.valueOf(boundIndex[0].trim()));
                        int b2 = fbounds.apply(Integer.valueOf(boundIndex[1].trim()));
                        if (b1 < b2) {
                            for (index = b1; index <= b2; ++index) {
                                arrayOfIndexes.add(index);
                            }
                            continue;
                        }
                        for (index = b2; index >= b1; --index) {
                            arrayOfIndexes.add(index);
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Number format problem with expression:" + str + " - Expression ignored");
                        continue;
                    }
                }
                logger.warn("Cannot parse expression " + str + " to pattern 'begin-end' (2-5) for instance, omitted");
                continue;
            }
            try {
                if (str.trim().equals("*")) {
                    int maxIndex = fbounds.apply(-1);
                    for (int index = 0; index <= maxIndex; ++index) {
                        arrayOfIndexes.add(index);
                    }
                    continue;
                }
                int index = fbounds.apply(Integer.valueOf(str.trim()));
                arrayOfIndexes.add(index);
            }
            catch (NumberFormatException e) {
                logger.warn("Number format problem with expression:" + str + " - Expression ignored");
            }
        }
        return arrayOfIndexes;
    }

    public static ARGBType getColorFromMetadata(IMetadata omeMeta, int iSerie, int iCh) {
        ARGBType color;
        Color c = omeMeta.getChannelColor(iSerie, iCh);
        if (c != null) {
            logger.debug("c = [" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "]");
            color = new ARGBType(ARGBType.rgba((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue(), (int)255));
        } else if (omeMeta.getChannelEmissionWavelength(iSerie, iCh) != null) {
            int emission = omeMeta.getChannelEmissionWavelength(iSerie, iCh).value(UNITS.NANOMETER).intValue();
            logger.debug("emission = " + emission);
            java.awt.Color cAwt = BioFormatsTools.getColorFromWavelength(emission);
            color = new ARGBType(ARGBType.rgba((int)cAwt.getRed(), (int)cAwt.getGreen(), (int)cAwt.getBlue(), (int)255));
        } else {
            color = new ARGBType(ARGBType.rgba((int)(255 * loopR[iCh % 7]), (int)(255 * loopG[iCh % 7]), (int)(255 * loopB[iCh % 7]), (int)255));
        }
        return color;
    }

    public static int[] waveLengthToRGB(double Wavelength) {
        double Blue;
        double Green;
        double Red;
        double Gamma = 0.8;
        double IntensityMax = 255.0;
        if (Wavelength >= 380.0 && Wavelength < 440.0) {
            Red = -(Wavelength - 440.0) / 60.0;
            Green = 0.0;
            Blue = 1.0;
        } else if (Wavelength >= 440.0 && Wavelength < 490.0) {
            Red = 0.0;
            Green = (Wavelength - 440.0) / 50.0;
            Blue = 1.0;
        } else if (Wavelength >= 490.0 && Wavelength < 510.0) {
            Red = 0.0;
            Green = 1.0;
            Blue = -(Wavelength - 510.0) / 20.0;
        } else if (Wavelength >= 510.0 && Wavelength < 580.0) {
            Red = (Wavelength - 510.0) / 70.0;
            Green = 1.0;
            Blue = 0.0;
        } else if (Wavelength >= 580.0 && Wavelength < 645.0) {
            Red = 1.0;
            Green = -(Wavelength - 645.0) / 65.0;
            Blue = 0.0;
        } else if (Wavelength >= 645.0 && Wavelength < 781.0) {
            Red = 1.0;
            Green = 0.0;
            Blue = 0.0;
        } else {
            Red = 0.0;
            Green = 0.0;
            Blue = 0.0;
        }
        double factor = Wavelength >= 380.0 && Wavelength < 420.0 ? 0.3 + 0.7 * (Wavelength - 380.0) / 40.0 : (Wavelength >= 420.0 && Wavelength < 701.0 ? 1.0 : (Wavelength >= 701.0 && Wavelength < 781.0 ? 0.3 + 0.7 * (780.0 - Wavelength) / 80.0 : 0.0));
        int[] rgb = new int[]{Red == 0.0 ? 0 : (int)Math.round(IntensityMax * Math.pow(Red * factor, Gamma)), Green == 0.0 ? 0 : (int)Math.round(IntensityMax * Math.pow(Green * factor, Gamma)), Blue == 0.0 ? 0 : (int)Math.round(IntensityMax * Math.pow(Blue * factor, Gamma))};
        return rgb;
    }

    public static java.awt.Color getColorFromWavelength(int wv) {
        int[] res = BioFormatsTools.waveLengthToRGB(wv);
        return new java.awt.Color(res[0], res[1], res[2]);
    }

    public static Unit<Length> getUnitFromString(String unit_string) {
        Field[] bfUnits;
        for (Field f : bfUnits = UNITS.class.getFields()) {
            if (!f.getType().equals(Unit.class) || f.getName() == null) continue;
            try {
                if (!f.getName().equalsIgnoreCase(unit_string.trim()) && !((Unit)f.get(null)).getSymbol().equalsIgnoreCase(unit_string.trim())) continue;
                return (Unit)f.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static class BioformatsChannel {
        final int iSerie;
        final int iChannel;
        int emissionWl = 1;
        public final String chName;
        String pxType = "";
        final boolean isRGB;

        public BioformatsChannel(IMetadata m, int iSerie, int iChannel, boolean isRGB) {
            this.iSerie = iSerie;
            this.iChannel = iChannel;
            this.isRGB = isRGB;
            if (m.getChannelEmissionWavelength(iSerie, iChannel) != null) {
                this.emissionWl = m.getChannelEmissionWavelength(iSerie, iChannel).value(UNITS.NANOMETER).intValue();
            }
            if (m.getChannelName(iSerie, iChannel) != null) {
                this.chName = m.getChannelName(iSerie, iChannel);
            } else {
                this.chName = "ch_" + iChannel;
                logger.warn("No name found for serie " + iSerie + " ch " + iChannel + " setting name to " + this.chName);
            }
            if (m.getPixelsType(iSerie) != null) {
                this.pxType = m.getPixelsType(iSerie).getValue();
            }
        }

        public int hashCode() {
            return this.chName.hashCode() * this.pxType.hashCode() * this.emissionWl * (this.iChannel + 1);
        }

        public boolean equals(Object obj) {
            if (obj instanceof BioformatsChannel) {
                BioformatsChannel bc = (BioformatsChannel)obj;
                return this.isRGB == bc.isRGB && this.chName.equals(bc.chName) && this.pxType.equals(bc.pxType) && this.iChannel == bc.iChannel && this.emissionWl == bc.emissionWl;
            }
            return false;
        }
    }
}

