/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.legacy.bioformats;

import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsBdvOpener;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsImageLoader;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsTools;
import ch.epfl.biop.bdv.img.legacy.bioformats.FileSerieChannel;
import ch.epfl.biop.bdv.img.legacy.bioformats.SeriesTps;
import ch.epfl.biop.bdv.img.legacy.bioformats.entity.FileIndex;
import ch.epfl.biop.bdv.img.legacy.bioformats.entity.SeriesNumber;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.Tile;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spimdata.util.Displaysettings;

@Deprecated
public class BioFormatsToSpimData {
    protected static final Logger logger = LoggerFactory.getLogger(BioFormatsToSpimData.class);
    int viewSetupCounter = 0;
    int nTileCounter = 0;
    int maxTimepoints = -1;
    int channelCounter = 0;
    final Map<Integer, Channel> channelIdToChannel = new HashMap<Integer, Channel>();
    final Map<BioFormatsTools.BioformatsChannel, Integer> channelToId = new HashMap<BioFormatsTools.BioformatsChannel, Integer>();
    final Map<Integer, Integer> fileIdxToNumberOfSeries = new HashMap<Integer, Integer>();
    final Map<Integer, SeriesTps> fileIdxToNumberOfSeriesAndTimepoints = new HashMap<Integer, SeriesTps>();
    final Map<Integer, FileSerieChannel> viewSetupToBFFileSerieChannel = new HashMap<Integer, FileSerieChannel>();

    private int getChannelId(IMetadata omeMeta, int iSerie, int iChannel, boolean isRGB) {
        BioFormatsTools.BioformatsChannel channel = new BioFormatsTools.BioformatsChannel(omeMeta, iSerie, iChannel, false);
        if (!this.channelToId.containsKey(channel)) {
            this.channelToId.put(channel, this.channelCounter);
            logger.debug("New Channel for series " + iSerie + ", channel " + iChannel + ", set as number " + this.channelCounter);
            Channel channelEntity = new Channel(this.channelCounter);
            channelEntity.setName(channel.chName);
            this.channelIdToChannel.put(this.channelCounter, channelEntity);
            ++this.channelCounter;
        } else {
            logger.debug("Channel for series " + iSerie + ", channel " + iChannel + ", already known.");
        }
        return this.channelIdToChannel.get(this.channelToId.get(channel)).getId();
    }

    protected AbstractSpimData<?> getSpimDataInstance(List<BioFormatsBdvOpener> openers) {
        openers.forEach(BioFormatsBdvOpener::ignoreMetadata);
        this.viewSetupCounter = 0;
        this.nTileCounter = 0;
        this.maxTimepoints = -1;
        this.channelCounter = 0;
        Illumination dummy_ill = new Illumination(0);
        Angle dummy_ang = new Angle(0);
        ArrayList viewSetups = new ArrayList();
        try {
            IMetadata omeMeta;
            int iFile;
            for (int iF = 0; iF < openers.size(); ++iF) {
                FileIndex fi = new FileIndex(iF);
                String dataLocation = openers.get(iF).getDataLocation();
                fi.setName(dataLocation);
                logger.debug("Data located at " + dataLocation);
                IFormatReader memo = openers.get(iF).getNewReader();
                iFile = iF;
                int seriesCount = memo.getSeriesCount();
                logger.debug("Number of Series " + seriesCount);
                omeMeta = (IMetadata)memo.getMetadataStore();
                this.fileIdxToNumberOfSeries.put(iF, seriesCount);
                IntStream series = IntStream.range(0, seriesCount);
                series.forEach(iSerie -> {
                    memo.setSeries(iSerie);
                    SeriesNumber sn = new SeriesNumber(iSerie, omeMeta.getImageName(iSerie));
                    this.fileIdxToNumberOfSeriesAndTimepoints.put(iFile, new SeriesTps(seriesCount, omeMeta.getPixelsSizeT(iSerie).getNumberValue().intValue()));
                    Tile tile = new Tile(this.nTileCounter);
                    ++this.nTileCounter;
                    logger.debug("\t Serie " + iSerie + " Number of timesteps = " + omeMeta.getPixelsSizeT(iSerie).getNumberValue().intValue());
                    logger.debug("\t Serie " + iSerie + " Number of channels = " + omeMeta.getChannelCount(iSerie));
                    IntStream channels = IntStream.range(0, omeMeta.getChannelCount(iSerie));
                    if (omeMeta.getPixelsSizeT(iSerie).getNumberValue().intValue() > this.maxTimepoints) {
                        this.maxTimepoints = omeMeta.getPixelsSizeT(iSerie).getNumberValue().intValue();
                    }
                    String imageName = this.getImageName(dataLocation, seriesCount, omeMeta, iSerie);
                    sn.setName(imageName);
                    Dimensions dims = BioFormatsTools.getSeriesDimensions(omeMeta, iSerie);
                    logger.debug("X:" + dims.dimension(0) + " Y:" + dims.dimension(1) + " Z:" + dims.dimension(2));
                    VoxelDimensions voxDims = BioFormatsTools.getSeriesVoxelDimensions(omeMeta, iSerie, ((BioFormatsBdvOpener)openers.get((int)iFile)).u, ((BioFormatsBdvOpener)openers.get((int)iFile)).voxSizeReferenceFrameLength);
                    channels.forEach(iCh -> {
                        int ch_id = this.getChannelId(omeMeta, iSerie, iCh, memo.isRGB());
                        String channelName = this.getChannelName(omeMeta, iSerie, iCh);
                        String setupName = imageName + "-" + channelName;
                        logger.debug(setupName);
                        ViewSetup vs = new ViewSetup(this.viewSetupCounter, setupName, dims, voxDims, tile, this.channelIdToChannel.get(ch_id), dummy_ang, dummy_ill);
                        vs.setAttribute((Entity)fi);
                        vs.setAttribute((Entity)sn);
                        Displaysettings ds = new Displaysettings(this.viewSetupCounter);
                        ds.min = 0.0;
                        ds.max = 255.0;
                        ds.isSet = false;
                        ARGBType color = BioFormatsTools.getColorFromMetadata(omeMeta, iSerie, iCh);
                        ds.isSet = true;
                        ds.color = new int[]{ARGBType.red((int)color.get()), ARGBType.green((int)color.get()), ARGBType.blue((int)color.get()), ARGBType.alpha((int)color.get())};
                        vs.setAttribute((Entity)ds);
                        viewSetups.add(vs);
                        this.viewSetupToBFFileSerieChannel.put(this.viewSetupCounter, new FileSerieChannel(iFile, iSerie, iCh));
                        ++this.viewSetupCounter;
                    });
                });
                memo.close();
            }
            ArrayList timePoints = new ArrayList();
            IntStream.range(0, this.maxTimepoints).forEach(tp -> timePoints.add(new TimePoint(tp)));
            ArrayList registrations = new ArrayList();
            ArrayList missingViews = new ArrayList();
            for (int iF = 0; iF < openers.size(); ++iF) {
                iFile = iF;
                IFormatReader memo = openers.get(iF).getNewReader();
                logger.debug("Number of Series : " + memo.getSeriesCount());
                omeMeta = (IMetadata)memo.getMetadataStore();
                int nSeries = this.fileIdxToNumberOfSeries.get(iF);
                IntStream series = IntStream.range(0, nSeries);
                series.forEach(iSerie -> {
                    int nTimepoints = omeMeta.getPixelsSizeT(iSerie).getNumberValue().intValue();
                    AffineTransform3D rootTransform = BioFormatsTools.getSeriesRootTransform(omeMeta, iSerie, ((BioFormatsBdvOpener)openers.get((int)iFile)).u, ((BioFormatsBdvOpener)openers.get((int)iFile)).positionPreTransformMatrixArray, ((BioFormatsBdvOpener)openers.get((int)iFile)).positionPostTransformMatrixArray, ((BioFormatsBdvOpener)openers.get((int)iFile)).positionReferenceFrameLength, ((BioFormatsBdvOpener)openers.get((int)iFile)).positionIsImageCenter, ((BioFormatsBdvOpener)openers.get((int)iFile)).voxSizePreTransformMatrixArray, ((BioFormatsBdvOpener)openers.get((int)iFile)).voxSizePostTransformMatrixArray, ((BioFormatsBdvOpener)openers.get((int)iFile)).voxSizeReferenceFrameLength, ((BioFormatsBdvOpener)openers.get((int)iFile)).axesOfImageFlip);
                    timePoints.forEach(iTp -> this.viewSetupToBFFileSerieChannel.keySet().stream().filter(viewSetupId -> this.viewSetupToBFFileSerieChannel.get((Object)viewSetupId).iFile == iFile).filter(viewSetupId -> this.viewSetupToBFFileSerieChannel.get((Object)viewSetupId).iSerie == iSerie).forEach(viewSetupId -> {
                        if (iTp.getId() < nTimepoints) {
                            registrations.add(new ViewRegistration(iTp.getId(), viewSetupId.intValue(), rootTransform));
                        } else {
                            missingViews.add(new ViewId(iTp.getId(), viewSetupId.intValue()));
                        }
                    }));
                });
                memo.close();
            }
            SequenceDescription sd = new SequenceDescription(new TimePoints(timePoints), viewSetups, null, new MissingViews(missingViews));
            sd.setImgLoader((BasicImgLoader)new BioFormatsImageLoader(openers, (AbstractSequenceDescription<?, ?, ?>)sd, openers.get((int)0).nFetcherThread, openers.get((int)0).numPriorities));
            return new SpimData((File)null, sd, new ViewRegistrations(registrations));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getChannelName(IMetadata omeMeta, int iSerie, int iCh) {
        String channelName = omeMeta.getChannelName(iSerie, iCh);
        channelName = channelName == null || channelName.equals("") ? "ch" + iCh : channelName;
        return channelName;
    }

    private String getImageName(String dataLocation, int seriesCount, IMetadata omeMeta, int iSerie) {
        String imageName = omeMeta.getImageName(iSerie);
        String fileNameWithoutExtension = FilenameUtils.removeExtension((String)new File(dataLocation).getName());
        fileNameWithoutExtension = fileNameWithoutExtension.replace(".ome", "");
        if (imageName == null || imageName.equals("")) {
            imageName = fileNameWithoutExtension;
            if (seriesCount > 1) {
                return imageName + "-s" + iSerie;
            }
            return imageName;
        }
        return imageName;
    }

    public static AbstractSpimData<?> getSpimData(List<BioFormatsBdvOpener> openers) {
        return new BioFormatsToSpimData().getSpimDataInstance(openers);
    }

    public static AbstractSpimData<?> getSpimData(BioFormatsBdvOpener opener) {
        ArrayList<BioFormatsBdvOpener> singleOpenerList = new ArrayList<BioFormatsBdvOpener>();
        singleOpenerList.add(opener);
        return BioFormatsToSpimData.getSpimData(singleOpenerList);
    }

    public static AbstractSpimData<?> getSpimData(File f) {
        BioFormatsBdvOpener opener = BioFormatsToSpimData.getDefaultOpener(f.getAbsolutePath());
        return BioFormatsToSpimData.getSpimData(opener);
    }

    public static AbstractSpimData<?> getSpimData(File[] files) {
        ArrayList<BioFormatsBdvOpener> openers = new ArrayList<BioFormatsBdvOpener>();
        for (File f : files) {
            openers.add(BioFormatsToSpimData.getDefaultOpener(f.getAbsolutePath()));
        }
        return BioFormatsToSpimData.getSpimData(openers);
    }

    public static BioFormatsBdvOpener getDefaultOpener(String dataLocation) {
        return BioFormatsBdvOpener.getOpener().location(dataLocation).auto();
    }
}

