/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.legacy.bioformats;

import bdv.AbstractViewerSetupImgLoader;
import bdv.img.cache.CacheArrayLoader;
import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsArrayLoaders;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsBdvOpener;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsTools;
import ch.epfl.biop.bdv.img.legacy.bioformats.ReaderPool;
import java.util.function.Function;
import java.util.function.Supplier;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.MultiResolutionSetupImgLoader;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BioFormatsSetupLoader<T extends NumericType<T> & NativeType<T>, V extends Volatile<T> & NativeType<V>, A extends DataAccess>
extends AbstractViewerSetupImgLoader<T, V>
implements MultiResolutionSetupImgLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(BioFormatsSetupLoader.class);
    final Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<FloatType>> cvtRaiToFloatRai;
    final Converter<T, FloatType> cvt;
    final BioFormatsBdvOpener opener;
    private final ReaderPool readerPool;
    final int iSerie;
    final int iChannel;
    final Supplier<VolatileGlobalCellCache> cacheSupplier;
    final int[] cellDimensions;
    final int numberOfTimePoints;
    final boolean switchZandC;
    final Unit<Length> targetUnit;
    final Dimensions[] dimensions;
    final int numMipmapLevels;
    final VoxelDimensions voxelsDimensions;
    final double[][] mmResolutions;
    final CacheArrayLoader<A> loader;
    final int setup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BioFormatsSetupLoader(BioFormatsBdvOpener opener, int sourceIndex, int channelIndex, int setup, T t, V v, Supplier<VolatileGlobalCellCache> cacheSupplier) throws Exception {
        super(t, v);
        boolean isLittleEndian;
        this.setup = setup;
        this.cacheSupplier = cacheSupplier;
        this.opener = opener;
        this.readerPool = opener.getReaderPool();
        this.iSerie = sourceIndex;
        this.iChannel = channelIndex;
        if (t instanceof FloatType) {
            this.cvt = null;
            this.cvtRaiToFloatRai = null;
        } else if (t instanceof ARGBType) {
            this.cvt = (input, output) -> {
                int val = ((ARGBType)input).get();
                int r = ARGBType.red((int)val);
                int g = ARGBType.green((int)val);
                int b = ARGBType.blue((int)val);
                output.set((float)(r + g + b));
            };
            this.cvtRaiToFloatRai = rai -> Converters.convert((RandomAccessibleInterval)rai, this.cvt, (Type)new FloatType());
        } else if (t instanceof AbstractIntegerType) {
            this.cvt = (input, output) -> output.set(((AbstractIntegerType)input).getRealFloat());
            this.cvtRaiToFloatRai = rai -> Converters.convert((RandomAccessibleInterval)rai, this.cvt, (Type)new FloatType());
        } else {
            this.cvt = null;
            this.cvtRaiToFloatRai = e -> {
                logger.error("Conversion of " + t.getClass() + " to FloatType unsupported.");
                return null;
            };
        }
        this.targetUnit = opener.u;
        this.switchZandC = opener.swZC;
        IFormatReader reader = null;
        try {
            reader = (IFormatReader)this.readerPool.acquire();
            reader.setSeries(this.iSerie);
            this.numMipmapLevels = reader.getResolutionCount();
            reader.setResolution(0);
            isLittleEndian = reader.isLittleEndian();
            IMetadata omeMeta = (IMetadata)reader.getMetadataStore();
            boolean is3D = omeMeta.getPixelsSizeZ(this.iSerie).getNumberValue().intValue() > 1;
            this.numberOfTimePoints = reader.getSizeT();
            this.cellDimensions = new int[]{opener.useBioFormatsXYBlockSize ? reader.getOptimalTileWidth() : (int)opener.cacheBlockSize.dimension(0), opener.useBioFormatsXYBlockSize ? reader.getOptimalTileHeight() : (int)opener.cacheBlockSize.dimension(1), !is3D ? 1 : (int)opener.cacheBlockSize.dimension(2)};
            this.voxelsDimensions = BioFormatsTools.getSeriesVoxelDimensions(omeMeta, this.iSerie, opener.u, opener.voxSizeReferenceFrameLength);
            this.dimensions = new Dimensions[this.numMipmapLevels];
            for (int level = 0; level < this.numMipmapLevels; ++level) {
                reader.setResolution(level);
                this.dimensions[level] = BioFormatsSetupLoader.getDimensions(reader.getSizeX(), reader.getSizeY(), !is3D ? 1L : (long)reader.getSizeZ());
            }
            this.mmResolutions = new double[this.numMipmapLevels][3];
            this.mmResolutions[0][0] = 1.0;
            this.mmResolutions[0][1] = 1.0;
            this.mmResolutions[0][2] = 1.0;
            if (reader.getFormat().equals("CellSens VSI")) {
                for (int iLevel = 1; iLevel < this.numMipmapLevels; ++iLevel) {
                    double downscalingFactor;
                    this.mmResolutions[iLevel][0] = downscalingFactor = Math.pow(2.0, iLevel);
                    this.mmResolutions[iLevel][1] = downscalingFactor;
                    this.mmResolutions[iLevel][2] = 1.0;
                }
            } else {
                int[] srcL0dims = new int[]{(int)this.dimensions[0].dimension(0), (int)this.dimensions[0].dimension(1), (int)this.dimensions[0].dimension(2)};
                for (int iLevel = 1; iLevel < this.numMipmapLevels; ++iLevel) {
                    int[] srcLidims = new int[]{(int)this.dimensions[iLevel].dimension(0), (int)this.dimensions[iLevel].dimension(1), (int)this.dimensions[iLevel].dimension(2)};
                    this.mmResolutions[iLevel][0] = (double)srcL0dims[0] / (double)srcLidims[0];
                    this.mmResolutions[iLevel][1] = (double)srcL0dims[1] / (double)srcLidims[1];
                    this.mmResolutions[iLevel][2] = (double)srcL0dims[2] / (double)srcLidims[2];
                }
            }
        }
        finally {
            this.readerPool.recycle(reader);
        }
        if (t instanceof UnsignedByteType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsUnsignedByteArrayLoader(this.readerPool, this.iSerie, this.iChannel, this.switchZandC);
        } else if (t instanceof UnsignedShortType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsUnsignedShortArrayLoader(this.readerPool, this.iSerie, this.iChannel, this.switchZandC, isLittleEndian);
        } else if (t instanceof FloatType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsFloatArrayLoader(this.readerPool, this.iSerie, this.iChannel, this.switchZandC, isLittleEndian);
        } else if (t instanceof IntType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsIntArrayLoader(this.readerPool, this.iSerie, this.iChannel, this.switchZandC, isLittleEndian);
        } else if (t instanceof ARGBType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsRGBArrayLoader(this.readerPool, this.iSerie, this.iChannel, this.switchZandC);
        } else {
            throw new UnsupportedOperationException("Pixel type " + t.getClass().getName() + " unsupported in " + BioFormatsSetupLoader.class.getName());
        }
    }

    static Dimensions getDimensions(final long sizeX, final long sizeY, final long sizeZ) {
        return new Dimensions(){

            public long dimension(int d) {
                if (d == 0) {
                    return sizeX;
                }
                if (d == 1) {
                    return sizeY;
                }
                return sizeZ;
            }

            public int numDimensions() {
                return 3;
            }
        };
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, int level, boolean normalize, ImgLoaderHint ... hints) {
        return this.cvtRaiToFloatRai.apply(this.getImage(timepointId, level, new ImgLoaderHint[0]));
    }

    public Dimensions getImageSize(int timepointId, int level) {
        return this.dimensions[level];
    }

    public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
        long[] dims = this.dimensions[level].dimensionsAsLongArray();
        int[] cellDimensions = this.cellDimensions;
        CellGrid grid = new CellGrid(dims, cellDimensions);
        int priority = this.numMipmapLevels - level;
        CacheHints cacheHints = new CacheHints(LoadingStrategy.BLOCKING, priority, false);
        return this.cacheSupplier.get().createImg(grid, timepointId, this.setup, level, cacheHints, this.loader, (NativeType)this.type);
    }

    public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
        long[] dims = this.dimensions[level].dimensionsAsLongArray();
        int[] cellDimensions = this.cellDimensions;
        CellGrid grid = new CellGrid(dims, cellDimensions);
        int priority = this.numMipmapLevels - level;
        CacheHints cacheHints = new CacheHints(LoadingStrategy.BUDGETED, priority, false);
        return this.cacheSupplier.get().createImg(grid, timepointId, this.setup, level, cacheHints, this.loader, (NativeType)this.volatileType);
    }

    public double[][] getMipmapResolutions() {
        return this.mmResolutions;
    }

    public AffineTransform3D[] getMipmapTransforms() {
        AffineTransform3D[] ats = new AffineTransform3D[this.numMipmapLevels];
        for (int iLevel = 0; iLevel < this.numMipmapLevels; ++iLevel) {
            AffineTransform3D at = new AffineTransform3D();
            at.scale(this.mmResolutions[iLevel][0], this.mmResolutions[iLevel][1], this.mmResolutions[iLevel][2]);
            ats[iLevel] = at;
        }
        return ats;
    }

    public int numMipmapLevels() {
        return this.numMipmapLevels;
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, boolean normalize, ImgLoaderHint ... hints) {
        return this.cvtRaiToFloatRai.apply(this.getImage(timepointId, 0, new ImgLoaderHint[0]));
    }

    public Dimensions getImageSize(int timepointId) {
        return this.getImageSize(0, 0);
    }

    public VoxelDimensions getVoxelSize(int timepointId) {
        return this.voxelsDimensions;
    }

    public ReaderPool getReaderPool() {
        return this.readerPool;
    }

    public BioFormatsBdvOpener getOpener() {
        return this.opener;
    }
}

