/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.legacy.bioformats;

import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.cache.SharedQueue;
import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsBdvOpener;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsSetupLoader;
import ch.epfl.biop.bdv.img.legacy.bioformats.FileSerieChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.MultiResolutionImgLoader;
import net.imglib2.Volatile;
import net.imglib2.cache.queue.BlockingFetchQueues;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.type.volatiles.VolatileFloatType;
import net.imglib2.type.volatiles.VolatileIntType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedShortType;
import ome.xml.model.enums.PixelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BioFormatsImageLoader
implements ViewerImgLoader,
MultiResolutionImgLoader,
Closeable {
    protected static final Logger logger = LoggerFactory.getLogger(BioFormatsBdvOpener.class);
    public final List<BioFormatsBdvOpener> openers;
    final AbstractSequenceDescription<?, ?, ?> sequenceDescription;
    final Map<Integer, FileSerieChannel> viewSetupToBFFileSerieChannel = new HashMap<Integer, FileSerieChannel>();
    int viewSetupCounter = 0;
    final Map<Integer, Map<Integer, NumericType<?>>> tTypeGetter = new HashMap();
    final Map<Integer, Map<Integer, Volatile<?>>> vTypeGetter = new HashMap();
    final HashMap<Integer, BioFormatsSetupLoader> imgLoaders = new HashMap();
    protected VolatileGlobalCellCache cache;
    protected SharedQueue sq;
    public final int numFetcherThreads;
    public final int numPriorities;

    public BioFormatsImageLoader(List<BioFormatsBdvOpener> openers, AbstractSequenceDescription<?, ?, ?> sequenceDescription, int numFetcherThreads, int numPriorities) {
        this.openers = openers;
        this.sequenceDescription = sequenceDescription;
        this.numFetcherThreads = numFetcherThreads;
        this.numPriorities = numPriorities;
        this.sq = new SharedQueue(numFetcherThreads, numPriorities);
        openers.forEach(opener -> opener.setCache(this.sq));
        IntStream openersIdxStream = IntStream.range(0, openers.size());
        if (sequenceDescription != null) {
            openersIdxStream.forEach(iF -> {
                try {
                    BioFormatsBdvOpener opener = (BioFormatsBdvOpener)openers.get(iF);
                    logger.debug("Data location = " + opener.getDataLocation());
                    IFormatReader memo = opener.getNewReader();
                    this.tTypeGetter.put(iF, new HashMap());
                    this.vTypeGetter.put(iF, new HashMap());
                    logger.debug("Number of Series : " + memo.getSeriesCount());
                    IMetadata omeMeta = (IMetadata)memo.getMetadataStore();
                    memo.setMetadataStore((MetadataStore)omeMeta);
                    IntStream series = IntStream.range(0, memo.getSeriesCount());
                    int iFile = iF;
                    series.forEach(iSerie -> {
                        memo.setSeries(iSerie);
                        logger.debug("\t Serie " + iSerie + " Number of timesteps = " + omeMeta.getPixelsSizeT(iSerie).getNumberValue().intValue());
                        logger.debug("\t Serie " + iSerie + " Number of channels = " + omeMeta.getChannelCount(iSerie));
                        IntStream channels = IntStream.range(0, omeMeta.getChannelCount(iSerie));
                        channels.forEach(iCh -> {
                            FileSerieChannel fsc = new FileSerieChannel(iFile, iSerie, iCh);
                            this.viewSetupToBFFileSerieChannel.put(this.viewSetupCounter, fsc);
                            ++this.viewSetupCounter;
                        });
                        NumericType<?> t = BioFormatsImageLoader.getBioformatsBdvSourceType(memo, iSerie);
                        this.tTypeGetter.get(iF).put(iSerie, t);
                        Volatile v = BioFormatsImageLoader.getVolatileOf(t);
                        this.vTypeGetter.get(iF).put(iSerie, v);
                    });
                    memo.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        this.cache = new VolatileGlobalCellCache((BlockingFetchQueues)this.sq);
    }

    public BioFormatsSetupLoader getSetupImgLoader(int setupId) {
        try {
            if (this.imgLoaders.containsKey(setupId)) {
                return this.imgLoaders.get(setupId);
            }
            int iF = this.viewSetupToBFFileSerieChannel.get((Object)Integer.valueOf((int)setupId)).iFile;
            int iS = this.viewSetupToBFFileSerieChannel.get((Object)Integer.valueOf((int)setupId)).iSerie;
            int iC = this.viewSetupToBFFileSerieChannel.get((Object)Integer.valueOf((int)setupId)).iChannel;
            logger.debug("loading file number = " + iF + " setupId = " + setupId);
            BioFormatsSetupLoader imgL = new BioFormatsSetupLoader(this.openers.get(iF), iS, iC, setupId, this.tTypeGetter.get(iF).get(iS), this.vTypeGetter.get(iF).get(iS), this::getCacheControl);
            this.imgLoaders.put(setupId, imgL);
            return imgL;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error in setup loader creation: " + e.getMessage());
        }
    }

    public CacheControl getCacheControl() {
        return this.cache;
    }

    public SharedQueue getQueue() {
        return this.sq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        BioFormatsImageLoader bioFormatsImageLoader = this;
        synchronized (bioFormatsImageLoader) {
            this.openers.forEach(opener -> opener.getReaderPool().shutDown(reader -> {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }));
            this.cache.clearCache();
            this.sq.shutdown();
        }
    }

    public static NumericType<?> getBioformatsBdvSourceType(IFormatReader reader, int image_index) throws UnsupportedOperationException {
        IMetadata omeMeta = (IMetadata)reader.getMetadataStore();
        reader.setSeries(image_index);
        if (reader.isRGB()) {
            if (omeMeta.getPixelsType(image_index) == PixelType.UINT8) {
                return new ARGBType();
            }
            throw new UnsupportedOperationException("Unhandled 16 bits RGB images");
        }
        PixelType pt = omeMeta.getPixelsType(image_index);
        if (pt == PixelType.UINT8) {
            return new UnsignedByteType();
        }
        if (pt == PixelType.UINT16) {
            return new UnsignedShortType();
        }
        if (pt == PixelType.INT32) {
            return new IntType();
        }
        if (pt == PixelType.FLOAT) {
            return new FloatType();
        }
        throw new UnsupportedOperationException("Unhandled pixel type for serie " + image_index + ": " + omeMeta.getPixelsType(image_index));
    }

    public static Volatile getVolatileOf(NumericType t) {
        if (t instanceof UnsignedShortType) {
            return new VolatileUnsignedShortType();
        }
        if (t instanceof IntType) {
            return new VolatileIntType();
        }
        if (t instanceof UnsignedByteType) {
            return new VolatileUnsignedByteType();
        }
        if (t instanceof FloatType) {
            return new VolatileFloatType();
        }
        if (t instanceof ARGBType) {
            return new VolatileARGBType();
        }
        return null;
    }
}

