/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.legacy.bioformats;

import bdv.cache.SharedQueue;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsBdvOpenerFix;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsTools;
import ch.epfl.biop.bdv.img.legacy.bioformats.ReaderPool;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.function.Consumer;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Memoizer;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BioFormatsBdvOpener {
    protected static final Logger logger = LoggerFactory.getLogger(BioFormatsBdvOpener.class);
    protected transient Consumer<IFormatReader> readerModifier;
    public String dataLocation;
    public boolean useBioFormatsXYBlockSize;
    public boolean isSoftRef;
    public FinalInterval cacheBlockSize;
    public boolean swZC;
    public boolean splitRGBChannels;
    public Unit<Length> u;
    public double[] positionPreTransformMatrixArray;
    public double[] positionPostTransformMatrixArray;
    public Length positionReferenceFrameLength;
    public boolean positionIgnoreBioFormatsMetaData;
    public boolean positionIsImageCenter;
    public double[] voxSizePreTransformMatrixArray;
    public double[] voxSizePostTransformMatrixArray;
    public Length voxSizeReferenceFrameLength;
    public boolean voxSizeIgnoreBioFormatsMetaData;
    public boolean[] axesOfImageFlip;
    public int nFetcherThread;
    public int numPriorities;
    public int maxCacheSize;
    transient SharedQueue cc;
    transient ReaderPool pool;

    public BioFormatsBdvOpener copy() {
        return new BioFormatsBdvOpener(this);
    }

    public BioFormatsBdvOpener(BioFormatsBdvOpener opener) {
        this.readerModifier = e -> {};
        this.dataLocation = null;
        this.useBioFormatsXYBlockSize = true;
        this.isSoftRef = true;
        this.cacheBlockSize = new FinalInterval(new long[]{0L, 0L, 0L}, new long[]{512L, 512L, 1L});
        this.splitRGBChannels = false;
        this.positionIgnoreBioFormatsMetaData = false;
        this.positionIsImageCenter = false;
        this.voxSizeIgnoreBioFormatsMetaData = false;
        this.axesOfImageFlip = new boolean[]{false, false, false};
        this.nFetcherThread = 2;
        this.numPriorities = 4;
        this.maxCacheSize = 1;
        this.cc = new SharedQueue(2, 4);
        this.pool = new ReaderPool(10, true, this::getNewReader);
        this.dataLocation = opener.dataLocation;
        this.useBioFormatsXYBlockSize = opener.useBioFormatsXYBlockSize;
        this.cacheBlockSize = new FinalInterval((Interval)opener.cacheBlockSize);
        this.isSoftRef = opener.isSoftRef;
        this.maxCacheSize = opener.maxCacheSize;
        this.swZC = opener.swZC;
        this.splitRGBChannels = opener.splitRGBChannels;
        this.u = opener.u;
        if (opener.positionPreTransformMatrixArray != null) {
            this.positionPreTransformMatrixArray = (double[])opener.positionPreTransformMatrixArray.clone();
        }
        if (opener.positionPostTransformMatrixArray != null) {
            this.positionPostTransformMatrixArray = (double[])opener.positionPostTransformMatrixArray.clone();
        }
        this.positionReferenceFrameLength = opener.positionReferenceFrameLength;
        this.positionIgnoreBioFormatsMetaData = opener.positionIgnoreBioFormatsMetaData;
        this.positionIsImageCenter = opener.positionIsImageCenter;
        if (opener.voxSizePreTransformMatrixArray != null) {
            this.voxSizePreTransformMatrixArray = (double[])opener.voxSizePreTransformMatrixArray.clone();
        }
        if (opener.voxSizePostTransformMatrixArray != null) {
            this.voxSizePostTransformMatrixArray = (double[])opener.voxSizePostTransformMatrixArray.clone();
        }
        this.voxSizeReferenceFrameLength = opener.voxSizeReferenceFrameLength;
        this.voxSizeIgnoreBioFormatsMetaData = opener.voxSizeIgnoreBioFormatsMetaData;
        this.axesOfImageFlip = (boolean[])opener.axesOfImageFlip.clone();
        this.nFetcherThread = opener.nFetcherThread;
        this.numPriorities = opener.numPriorities;
        this.readerModifier = opener.readerModifier;
    }

    public BioFormatsBdvOpener() {
        this.readerModifier = e -> {};
        this.dataLocation = null;
        this.useBioFormatsXYBlockSize = true;
        this.isSoftRef = true;
        this.cacheBlockSize = new FinalInterval(new long[]{0L, 0L, 0L}, new long[]{512L, 512L, 1L});
        this.splitRGBChannels = false;
        this.positionIgnoreBioFormatsMetaData = false;
        this.positionIsImageCenter = false;
        this.voxSizeIgnoreBioFormatsMetaData = false;
        this.axesOfImageFlip = new boolean[]{false, false, false};
        this.nFetcherThread = 2;
        this.numPriorities = 4;
        this.maxCacheSize = 1;
        this.cc = new SharedQueue(2, 4);
        this.pool = new ReaderPool(10, true, this::getNewReader);
    }

    public SharedQueue getCacheControl() {
        if (this.cc == null) {
            this.cc = new SharedQueue(this.nFetcherThread, this.numPriorities);
        }
        return this.cc;
    }

    public String getDataLocation() {
        return this.dataLocation;
    }

    public BioFormatsBdvOpener with(Consumer<BioFormatsBdvOpener> builderFunction) {
        builderFunction.accept(this);
        return this;
    }

    public BioFormatsBdvOpener file(File f) {
        this.dataLocation = f.getAbsolutePath();
        return this;
    }

    public BioFormatsBdvOpener positionReferenceFrameLength(Length l) {
        this.positionReferenceFrameLength = l;
        return this;
    }

    public BioFormatsBdvOpener cacheSoftRef() {
        this.isSoftRef = true;
        return this;
    }

    public BioFormatsBdvOpener cacheBounded(int maxCacheSize) {
        this.isSoftRef = false;
        this.maxCacheSize = maxCacheSize;
        return this;
    }

    public BioFormatsBdvOpener voxSizeReferenceFrameLength(Length l) {
        this.voxSizeReferenceFrameLength = l;
        return this;
    }

    public BioFormatsBdvOpener setReaderPool(ReaderPool pool) {
        this.pool = pool;
        return this;
    }

    public ReaderPool getReaderPool() {
        return this.pool;
    }

    public BioFormatsBdvOpener queueOptions(int numFetcherThreads, int numPriorities) {
        this.nFetcherThread = numFetcherThreads;
        this.numPriorities = numPriorities;
        this.cc = new SharedQueue(this.nFetcherThread, this.numPriorities);
        return this;
    }

    public BioFormatsBdvOpener setCache(SharedQueue sq) {
        this.cc = sq;
        return this;
    }

    public BioFormatsBdvOpener file(String filePath) {
        this.dataLocation = filePath;
        return this;
    }

    public BioFormatsBdvOpener splitRGBChannels() {
        this.splitRGBChannels = true;
        return this;
    }

    public BioFormatsBdvOpener flipPositionXYZ() {
        if (this.positionPreTransformMatrixArray == null) {
            this.positionPreTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
        }
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.set(this.positionPreTransformMatrixArray);
        at3D.scale(-1.0);
        this.positionPreTransformMatrixArray = at3D.getRowPackedCopy();
        return this;
    }

    public BioFormatsBdvOpener flipPositionX() {
        if (this.positionPreTransformMatrixArray == null) {
            this.positionPreTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
        }
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.set(this.positionPreTransformMatrixArray);
        at3D.scale(-1.0, 1.0, 1.0);
        this.positionPreTransformMatrixArray = at3D.getRowPackedCopy();
        return this;
    }

    public BioFormatsBdvOpener flipPositionY() {
        if (this.positionPreTransformMatrixArray == null) {
            this.positionPreTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
        }
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.set(this.positionPreTransformMatrixArray);
        at3D.scale(1.0, -1.0, 1.0);
        this.positionPreTransformMatrixArray = at3D.getRowPackedCopy();
        return this;
    }

    public BioFormatsBdvOpener flipPositionZ() {
        if (this.positionPreTransformMatrixArray == null) {
            this.positionPreTransformMatrixArray = new AffineTransform3D().getRowPackedCopy();
        }
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.set(this.positionPreTransformMatrixArray);
        at3D.scale(1.0, 1.0, -1.0);
        this.positionPreTransformMatrixArray = at3D.getRowPackedCopy();
        return this;
    }

    public BioFormatsBdvOpener setPositionPreTransform(AffineTransform3D at3d) {
        this.positionPreTransformMatrixArray = at3d.getRowPackedCopy();
        return this;
    }

    public BioFormatsBdvOpener addReaderModifier(Consumer<IFormatReader> modifier) {
        Consumer<IFormatReader> originModifier = this.readerModifier;
        this.readerModifier = r -> {
            originModifier.accept((IFormatReader)r);
            modifier.accept((IFormatReader)r);
        };
        return this;
    }

    public BioFormatsBdvOpener setPositionPostTransform(AffineTransform3D at3d) {
        this.positionPostTransformMatrixArray = at3d.getRowPackedCopy();
        return this;
    }

    public BioFormatsBdvOpener auto() {
        if (this.dataLocation == null) {
            return this;
        }
        ImageReader readerIdx = new ImageReader();
        if (this.splitRGBChannels) {
            readerIdx = new ChannelSeparator((IFormatReader)readerIdx);
        }
        readerIdx.setFlattenedResolutions(false);
        Memoizer memo = new Memoizer((IFormatReader)readerIdx);
        IMetadata omeMetaOmeXml = MetadataTools.createOMEXMLMetadata();
        memo.setMetadataStore((MetadataStore)omeMetaOmeXml);
        try {
            memo.setId(this.dataLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        logger.info("Attempts to set opener settings for file format " + memo.getFormat() + "; data location = " + this.dataLocation);
        if (memo.getFormat().equals("Nikon ND2")) {
            return BioFormatsBdvOpenerFix.fixNikonND2(this);
        }
        if (memo.getFormat().equals("Leica Image File Format")) {
            return BioFormatsBdvOpenerFix.fixLif(this);
        }
        return this;
    }

    public BioFormatsBdvOpener url(URL url) {
        this.dataLocation = url.toString();
        return this;
    }

    public BioFormatsBdvOpener location(String location) {
        this.dataLocation = location;
        return this;
    }

    public BioFormatsBdvOpener location(File f) {
        this.dataLocation = f.getAbsolutePath();
        return this;
    }

    public BioFormatsBdvOpener unit(Unit<Length> u) {
        this.u = u;
        return this;
    }

    public BioFormatsBdvOpener unit(String u) {
        this.u = BioFormatsTools.getUnitFromString(u);
        return this;
    }

    public BioFormatsBdvOpener millimeter() {
        this.u = UNITS.MILLIMETER;
        return this;
    }

    public BioFormatsBdvOpener micrometer() {
        this.u = UNITS.MICROMETER;
        return this;
    }

    public BioFormatsBdvOpener nanometer() {
        this.u = UNITS.NANOMETER;
        return this;
    }

    public BioFormatsBdvOpener centerPositionConvention() {
        this.positionIsImageCenter = true;
        return this;
    }

    public BioFormatsBdvOpener cornerPositionConvention() {
        this.positionIsImageCenter = false;
        return this;
    }

    public BioFormatsBdvOpener ignoreMetadata() {
        this.positionIgnoreBioFormatsMetaData = true;
        this.voxSizeIgnoreBioFormatsMetaData = true;
        return this;
    }

    public BioFormatsBdvOpener useCacheBlockSizeFromBioFormats(boolean flag) {
        this.useBioFormatsXYBlockSize = flag;
        return this;
    }

    public BioFormatsBdvOpener switchZandC(boolean flag) {
        this.swZC = flag;
        return this;
    }

    public BioFormatsBdvOpener cacheBlockSize(int sx, int sy, int sz) {
        this.useBioFormatsXYBlockSize = false;
        this.cacheBlockSize = new FinalInterval(new long[]{sx, sy, sz});
        return this;
    }

    public IFormatReader getNewReader() {
        logger.debug("Getting new reader for " + this.dataLocation);
        ImageReader reader = new ImageReader();
        reader.setFlattenedResolutions(false);
        if (this.splitRGBChannels) {
            reader = new ChannelSeparator((IFormatReader)reader);
        }
        Memoizer memo = new Memoizer((IFormatReader)reader);
        IMetadata omeMetaIdxOmeXml = MetadataTools.createOMEXMLMetadata();
        memo.setMetadataStore((MetadataStore)omeMetaIdxOmeXml);
        this.readerModifier.accept((IFormatReader)memo);
        try {
            logger.debug("setId for reader " + this.dataLocation);
            StopWatch watch = new StopWatch();
            watch.start();
            memo.setId(this.dataLocation);
            watch.stop();
            logger.debug("id set in " + (int)(watch.getTime() / 1000L) + " s");
        }
        catch (IOException | FormatException e) {
            e.printStackTrace();
        }
        return memo;
    }

    public static BioFormatsBdvOpener getOpener() {
        return new BioFormatsBdvOpener().positionReferenceFrameLength(new Length((Number)1, UNITS.MICROMETER)).voxSizeReferenceFrameLength(new Length((Number)1, UNITS.MICROMETER)).millimeter().useCacheBlockSizeFromBioFormats(true);
    }
}

