/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.legacy.bioformats;

import bdv.img.cache.CacheArrayLoader;
import ch.epfl.biop.bdv.img.legacy.bioformats.ReaderPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.formats.IFormatReader;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;

@Deprecated
public class BioFormatsArrayLoaders {

    public static class BioFormatsIntArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileIntArray> {
        final ByteOrder byteOrder;

        public BioFormatsIntArrayLoader(ReaderPool readerPool, int series, int channel, boolean switchZandC, boolean littleEndian) {
            super(readerPool, series, channel, switchZandC);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileIntArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.series);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 4);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = reader.openBytes(this.switchZandC ? reader.getIndex(this.channel, z, timepoint) : reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.readerPool.recycle(reader);
                int[] ints = new int[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asIntBuffer().get(ints);
                return new VolatileIntArray(ints, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    public static class BioFormatsRGBArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileIntArray> {
        public BioFormatsRGBArrayLoader(ReaderPool readerPool, int series, int channel, boolean switchZandC) {
            super(readerPool, series, channel, switchZandC);
        }

        public VolatileIntArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                byte[] bytes;
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.series);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                if (d == 1) {
                    bytes = reader.openBytes(this.switchZandC ? reader.getIndex(this.channel, minZ, timepoint) : reader.getIndex(minZ, this.channel, timepoint), minX, minY, w, h);
                } else {
                    int nBytesPerPlane = nElements * 3;
                    bytes = new byte[nBytesPerPlane];
                    int offset = 0;
                    for (int z = minZ; z < maxZ; ++z) {
                        byte[] bytesCurrentPlane = reader.openBytes(this.switchZandC ? reader.getIndex(this.channel, z, timepoint) : reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                        System.arraycopy(bytesCurrentPlane, 0, bytes, offset, nBytesPerPlane);
                        offset += nBytesPerPlane;
                    }
                }
                boolean interleaved = reader.isInterleaved();
                this.readerPool.recycle(reader);
                int[] ints = new int[nElements];
                int idxPx = 0;
                if (interleaved) {
                    for (int i = 0; i < nElements; ++i) {
                        ints[i] = 0xFF000000 | (bytes[idxPx] & 0xFF) << 16 | (bytes[idxPx + 1] & 0xFF) << 8 | bytes[idxPx + 2] & 0xFF;
                        idxPx += 3;
                    }
                } else {
                    int bOffset = 2 * nElements;
                    for (int i = 0; i < nElements; ++i) {
                        ints[i] = (bytes[idxPx] & 0xFF) << 16 | (bytes[idxPx + nElements] & 0xFF) << 8 | bytes[idxPx + bOffset] & 0xFF;
                        ++idxPx;
                    }
                }
                return new VolatileIntArray(ints, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    public static class BioFormatsFloatArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileFloatArray> {
        final ByteOrder byteOrder;

        public BioFormatsFloatArrayLoader(ReaderPool readerPool, int series, int channel, boolean switchZandC, boolean littleEndian) {
            super(readerPool, series, channel, switchZandC);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileFloatArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.series);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 4);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = reader.openBytes(this.switchZandC ? reader.getIndex(this.channel, z, timepoint) : reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.readerPool.recycle(reader);
                float[] floats = new float[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asFloatBuffer().get(floats);
                return new VolatileFloatArray(floats, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    public static class BioFormatsUnsignedShortArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileShortArray> {
        final ByteOrder byteOrder;

        public BioFormatsUnsignedShortArrayLoader(ReaderPool readerPool, int series, int channel, boolean switchZandC, boolean littleEndian) {
            super(readerPool, series, channel, switchZandC);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileShortArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.series);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 2);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = reader.openBytes(this.switchZandC ? reader.getIndex(this.channel, z, timepoint) : reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.readerPool.recycle(reader);
                short[] shorts = new short[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asShortBuffer().get(shorts);
                return new VolatileShortArray(shorts, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 2;
        }
    }

    public static class BioFormatsUnsignedByteArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileByteArray> {
        public BioFormatsUnsignedByteArrayLoader(ReaderPool readerPool, int series, int channel, boolean switchZandC) {
            super(readerPool, series, channel, switchZandC);
        }

        public VolatileByteArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.series);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytesCurrentPlane = reader.openBytes(this.switchZandC ? reader.getIndex(this.channel, z, timepoint) : reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    buffer.put(bytesCurrentPlane);
                }
                this.readerPool.recycle(reader);
                return new VolatileByteArray(buffer.array(), true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 1;
        }
    }

    static abstract class BioformatsArrayLoader {
        protected final ReaderPool readerPool;
        protected final int series;
        protected final int channel;
        protected final boolean switchZandC;

        public BioformatsArrayLoader(ReaderPool readerPool, int series, int channel, boolean switchZandC) {
            this.readerPool = readerPool;
            this.series = series;
            this.channel = channel;
            this.switchZandC = switchZandC;
        }
    }
}

