/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.imageplus.io;

import ch.epfl.biop.bdv.img.imageplus.ImagePlusImageLoader;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import net.imglib2.Volatile;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileAccess;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import org.jdom2.Content;
import org.jdom2.Element;

@ImgLoaderIo(format="spimreconstruction.biop_virtualstackimageplusimageloader", type=ImagePlusImageLoader.class)
public class ImagePlusImgLoader<T extends NativeType<T>, V extends Volatile<T>, A extends VolatileAccess & DataAccess>
implements XmlIoBasicImgLoader<ImagePlusImageLoader<T, V, A>> {
    public static final String IMAGEPLUS_FILEPATH_TAG = "imageplus_filepath";
    public static final String IMAGEPLUS_TIME_ORIGIN_TAG = "imageplus_time_origin";

    public Element toXml(ImagePlusImageLoader imgLoader, File basePath) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", this.getClass().getAnnotation(ImgLoaderIo.class).format());
        elem.addContent((Content)XmlHelpers.textElement((String)IMAGEPLUS_FILEPATH_TAG, (String)imgLoader.getImagePlus().getFileInfo().getFilePath()));
        elem.addContent((Content)XmlHelpers.intElement((String)IMAGEPLUS_TIME_ORIGIN_TAG, (int)imgLoader.getTimeShift()));
        return elem;
    }

    public ImagePlusImageLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        ImagePlusImageLoader<UnsignedByteType, VolatileUnsignedByteType, VolatileByteArray> imgLoader;
        String imagePlusFilePath = XmlHelpers.getText((Element)elem, (String)IMAGEPLUS_FILEPATH_TAG);
        int originTimePoint = XmlHelpers.getInt((Element)elem, (String)IMAGEPLUS_TIME_ORIGIN_TAG);
        ImagePlus imp = IJ.openImage((String)imagePlusFilePath);
        switch (imp.getType()) {
            case 0: {
                imgLoader = ImagePlusImageLoader.createUnsignedByteInstance(imp, originTimePoint);
                break;
            }
            case 1: {
                imgLoader = ImagePlusImageLoader.createUnsignedShortInstance(imp, originTimePoint);
                break;
            }
            case 2: {
                imgLoader = ImagePlusImageLoader.createFloatInstance(imp, originTimePoint);
                break;
            }
            default: {
                imgLoader = ImagePlusImageLoader.createARGBInstance(imp, originTimePoint);
            }
        }
        return imgLoader;
    }
}

