/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.imageplus;

import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusHelper;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusImageLoader;
import ij.ImagePlus;
import ij.process.LUT;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spimdata.util.Displaysettings;

public class ImagePlusToSpimData {
    private static final Logger logger = LoggerFactory.getLogger(ImagePlusToSpimData.class);

    public static AbstractSpimData<?> getSpimData(ImagePlus imp) throws UnsupportedOperationException {
        ImagePlusImageLoader<UnsignedByteType, VolatileUnsignedByteType, VolatileByteArray> imgLoader;
        switch (imp.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                String message = "Error in image " + imp.getShortTitle() + ": Only 8, 16, 32-bit images and RGB images are supported currently!";
                logger.error(message);
                throw new UnsupportedOperationException(message);
            }
        }
        double pw = imp.getCalibration().pixelWidth;
        double ph = imp.getCalibration().pixelHeight;
        double pd = imp.getCalibration().pixelDepth;
        String punit = imp.getCalibration().getUnit();
        if (punit == null || punit.isEmpty()) {
            punit = "px";
        }
        FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(punit, new double[]{pw, ph, pd});
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getNSlices();
        FinalDimensions size = new FinalDimensions(new int[]{w, h, d});
        int originTimePoint = ImagePlusHelper.getTimeOriginFromImagePlus(imp);
        switch (imp.getType()) {
            case 0: {
                imgLoader = ImagePlusImageLoader.createUnsignedByteInstance(imp, originTimePoint);
                break;
            }
            case 1: {
                imgLoader = ImagePlusImageLoader.createUnsignedShortInstance(imp, originTimePoint);
                break;
            }
            case 2: {
                imgLoader = ImagePlusImageLoader.createFloatInstance(imp, originTimePoint);
                break;
            }
            default: {
                imgLoader = ImagePlusImageLoader.createARGBInstance(imp, originTimePoint);
            }
        }
        int numTimepoints = imp.getNFrames();
        int numSetups = imp.getNChannels();
        HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>(numSetups);
        for (int s = 0; s < numSetups; ++s) {
            BasicViewSetup setup = new BasicViewSetup(s, String.format(imp.getTitle() + " channel %d", s + 1), (Dimensions)size, (VoxelDimensions)voxelSize);
            setup.setAttribute((Entity)new Channel(s + 1));
            Displaysettings ds = new Displaysettings(s + 1);
            imp.setPositionWithoutUpdate(s + 1, 1, 1);
            ds.min = imp.getDisplayRangeMin();
            ds.max = imp.getDisplayRangeMax();
            if (imp.getType() == 4) {
                ds.isSet = false;
            } else {
                ds.isSet = true;
                LUT[] luts = imp.getLuts();
                LUT lut = luts.length > s ? luts[s] : luts[0];
                ds.color = new int[]{lut.getRed(255), lut.getGreen(255), lut.getBlue(255), lut.getAlpha(255)};
            }
            setup.setAttribute((Entity)ds);
            setups.put(s, setup);
        }
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>(numTimepoints);
        MissingViews mv = null;
        if (originTimePoint > 0) {
            HashSet<ViewId> missingViewIds = new HashSet<ViewId>();
            for (int t = 0; t < originTimePoint; ++t) {
                for (int s = 0; s < numSetups; ++s) {
                    ViewId vId = new ViewId(t, s);
                    missingViewIds.add(vId);
                }
            }
            mv = new MissingViews(missingViewIds);
        }
        for (int t = 0; t < numTimepoints + originTimePoint; ++t) {
            timepoints.add(new TimePoint(t));
        }
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), setups, imgLoader, mv);
        AffineTransform3D sourceTransform = ImagePlusHelper.getMatrixFromImagePlus(imp);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (int t = 0; t < numTimepoints + originTimePoint; ++t) {
            for (int s = 0; s < numSetups; ++s) {
                registrations.add(new ViewRegistration(t, s, sourceTransform));
            }
        }
        File basePath = new File(".");
        return new SpimDataMinimal(basePath, seq, new ViewRegistrations(registrations));
    }
}

