/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.imageplus;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.img.cache.CacheArrayLoader;
import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.CacheControlOverride;
import ij.ImagePlus;
import java.util.HashMap;
import java.util.function.Function;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.TypedBasicImgLoader;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileAccess;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.type.volatiles.VolatileFloatType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedShortType;

public class ImagePlusImageLoader<T extends NativeType<T>, V extends Volatile<T>, A extends DataAccess & VolatileAccess>
implements ViewerImgLoader,
TypedBasicImgLoader<T>,
CacheControlOverride {
    private static final double[][] mipmapResolutions = new double[][]{{1.0, 1.0, 1.0}};
    private static final AffineTransform3D[] mipmapTransforms = new AffineTransform3D[]{new AffineTransform3D()};
    private final CacheArrayLoader<A> loader;
    private VolatileGlobalCellCache cache;
    private final long[] dimensions;
    private final int[] cellDimensions;
    private final HashMap<Integer, SetupImgLoader> setupImgLoaders;
    final ImagePlus imp;
    final int timeShift;

    public static ImagePlusImageLoader<FloatType, VolatileFloatType, VolatileFloatArray> createFloatInstance(ImagePlus imp, int offsetTime) {
        return new ImagePlusImageLoader<FloatType, VolatileFloatType, VolatileFloatArray>(imp, array -> new VolatileFloatArray((float[])array, true), new FloatType(), new VolatileFloatType(), offsetTime);
    }

    public static ImagePlusImageLoader<UnsignedShortType, VolatileUnsignedShortType, VolatileShortArray> createUnsignedShortInstance(ImagePlus imp, int offsetTime) {
        return new ImagePlusImageLoader<UnsignedShortType, VolatileUnsignedShortType, VolatileShortArray>(imp, array -> new VolatileShortArray((short[])array, true), new UnsignedShortType(), new VolatileUnsignedShortType(), offsetTime);
    }

    public static ImagePlusImageLoader<UnsignedByteType, VolatileUnsignedByteType, VolatileByteArray> createUnsignedByteInstance(ImagePlus imp, int offsetTime) {
        return new ImagePlusImageLoader<UnsignedByteType, VolatileUnsignedByteType, VolatileByteArray>(imp, array -> new VolatileByteArray((byte[])array, true), new UnsignedByteType(), new VolatileUnsignedByteType(), offsetTime);
    }

    public static ImagePlusImageLoader<ARGBType, VolatileARGBType, VolatileIntArray> createARGBInstance(ImagePlus imp, int offsetTime) {
        return new ImagePlusImageLoader<ARGBType, VolatileARGBType, VolatileIntArray>(imp, array -> new VolatileIntArray((int[])array, true), new ARGBType(), new VolatileARGBType(), offsetTime);
    }

    private static int getByteCount(PrimitiveType primitiveType) {
        switch (primitiveType) {
            case BYTE: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
        }
        return 4;
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    public int getTimeShift() {
        return this.timeShift;
    }

    protected ImagePlusImageLoader(ImagePlus imp, Function<Object, A> wrapPixels, T type, V volatileType, int timeOffset) {
        this.loader = new VirtualStackArrayLoader<A>(imp, wrapPixels, ImagePlusImageLoader.getByteCount(type.getNativeTypeFactory().getPrimitiveType()));
        this.imp = imp;
        this.timeShift = timeOffset;
        this.dimensions = new long[]{imp.getWidth(), imp.getHeight(), imp.getNSlices()};
        this.cellDimensions = new int[]{imp.getWidth(), imp.getHeight(), 1};
        int numSetups = imp.getNChannels();
        this.cache = new VolatileGlobalCellCache(1, 1);
        this.setupImgLoaders = new HashMap();
        for (int setupId = 0; setupId < numSetups; ++setupId) {
            this.setupImgLoaders.put(setupId, new SetupImgLoader(this, setupId, type, volatileType, timeOffset));
        }
    }

    protected ImagePlusImageLoader(ImagePlus imp, Function<Object, A> wrapPixels, T type, V volatileType) {
        this(imp, wrapPixels, type, volatileType, 0);
    }

    public VolatileGlobalCellCache getCacheControl() {
        return this.cache;
    }

    @Override
    public void setCacheControl(VolatileGlobalCellCache cache) {
        CacheControlOverride.Tools.shutdownCacheQueue(this.cache);
        this.cache.clearCache();
        this.cache = cache;
    }

    public SetupImgLoader getSetupImgLoader(int setupId) {
        return this.setupImgLoaders.get(setupId);
    }

    public class SetupImgLoader
    extends AbstractViewerSetupImgLoader<T, V> {
        private final int setupId;
        private final int timeOffset;
        final /* synthetic */ ImagePlusImageLoader this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        protected SetupImgLoader(int setupId, T type, V volatileType, int timeOffset) {
            this.this$0 = (ImagePlusImageLoader)this$0;
            super(type, volatileType);
            this.setupId = setupId;
            this.timeOffset = timeOffset;
        }

        public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.prepareCachedImage(timepointId - this.timeOffset, level, LoadingStrategy.BUDGETED, (NativeType)this.volatileType);
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.prepareCachedImage(timepointId - this.timeOffset, level, LoadingStrategy.BLOCKING, (NativeType)this.type);
        }

        protected <T extends NativeType<T>> AbstractCellImg<T, A, ?, ?> prepareCachedImage(int timepointId, int level, LoadingStrategy loadingStrategy, T type) {
            boolean priority = false;
            CacheHints cacheHints = new CacheHints(loadingStrategy, 0, false);
            CellGrid grid = new CellGrid(this.this$0.dimensions, this.this$0.cellDimensions);
            return this.this$0.cache.createImg(grid, timepointId, this.setupId, level, cacheHints, this.this$0.loader, type);
        }

        public double[][] getMipmapResolutions() {
            return mipmapResolutions;
        }

        public AffineTransform3D[] getMipmapTransforms() {
            return mipmapTransforms;
        }

        public int numMipmapLevels() {
            return 1;
        }
    }

    static class VirtualStackArrayLoader<A extends DataAccess>
    implements CacheArrayLoader<A> {
        private final ImagePlus imp;
        private final Function<Object, A> wrapPixels;
        private final int bytesPerElement;

        public VirtualStackArrayLoader(ImagePlus imp, Function<Object, A> wrapPixels, int bytesPerElement) {
            this.imp = imp;
            this.wrapPixels = wrapPixels;
            this.bytesPerElement = bytesPerElement;
        }

        public A loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) {
            int channel = setup + 1;
            int slice = (int)min[2] + 1;
            int frame = timepoint + 1;
            return (A)((DataAccess)this.wrapPixels.apply(this.imp.getStack().getProcessor(this.imp.getStackIndex(channel, slice, frame)).getPixels()));
        }

        public int getBytesPerElement() {
            return this.bytesPerElement;
        }
    }
}

