/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.imageplus;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.imageplus.ZerosRAI;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.HyperStackConverter;
import ij.process.LUT;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.lazy.Caches;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.cache.ref.SoftRefLoaderCache;
import net.imglib2.display.ColorConverter;
import net.imglib2.display.LinearRange;
import net.imglib2.img.Img;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.display.imagej.ImgToVirtualStack;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public class ImagePlusHelper {
    public static final String regexAffineTransform3D = "(3d-affine: \\()(.+),(.+),(.+),(.+),(.+),(.+),(.+),(.+),(.+),(.+),(.+),(.*)\\)";
    public static final String regexTimePointOrigin = "(TimePoint: \\()(.+)\\)";

    public static void storeExtendedCalibrationToImagePlus(ImagePlus imp, AffineTransform3D at3D, String unit, int timePointBegin) {
        ImagePlusHelper.storeMatrixToImagePlus(imp, at3D);
        ImagePlusHelper.setTimeOriginToImagePlus(imp, timePointBegin);
        if (unit != null) {
            imp.getCalibration().setUnit(unit);
        }
    }

    static void storeMatrixToImagePlus(ImagePlus imp, AffineTransform3D at3D) {
        Calibration cal = new Calibration();
        double[] m = at3D.getRowPackedCopy();
        double[] voxelSizes = new double[3];
        for (int d = 0; d < 3; ++d) {
            voxelSizes[d] = Math.sqrt(m[d] * m[d] + m[d + 4] * m[d + 4] + m[d + 8] * m[d + 8]);
        }
        double[] voxelSigns = new double[3];
        for (int d = 0; d < 3; ++d) {
            ArrayList<Double> entries = new ArrayList<Double>();
            entries.add(m[d]);
            entries.add(m[d + 4]);
            entries.add(m[d + 8]);
            entries.sort((o1, o2) -> Math.abs(o1) < Math.abs(o2) ? 1 : -1);
            voxelSigns[d] = Math.signum((Double)entries.get(0));
        }
        cal.pixelWidth = voxelSigns[0] * voxelSizes[0];
        cal.pixelHeight = voxelSigns[1] * voxelSizes[1];
        cal.pixelDepth = voxelSigns[2] * voxelSizes[2];
        double[] origin = new double[3];
        at3D.inverse().apply(new double[3], origin);
        cal.xOrigin = origin[0];
        cal.yOrigin = origin[1];
        cal.zOrigin = origin[2];
        imp.setCalibration(cal);
        if (imp.getInfoProperty() == null) {
            imp.setProperty("Info", (Object)" ");
        }
        String info = imp.getInfoProperty();
        info = info.replaceAll(regexAffineTransform3D, "");
        info = info + at3D + "\n";
        imp.setProperty("Info", (Object)info);
    }

    public static AffineTransform3D getMatrixFromImagePlus(ImagePlus imp) {
        AffineTransform3D at3D;
        if (imp.getInfoProperty() != null) {
            at3D = new AffineTransform3D();
            Pattern pattern = Pattern.compile(regexAffineTransform3D);
            Matcher matcher = pattern.matcher(imp.getInfoProperty());
            if (matcher.find()) {
                double[] m = new double[12];
                for (int i = 0; i < 12; ++i) {
                    m[i] = Double.parseDouble(matcher.group(i + 2));
                }
                at3D.set(m);
                return at3D;
            }
        }
        if (imp.getCalibration() != null) {
            at3D = new AffineTransform3D();
            at3D.scale(imp.getCalibration().pixelWidth, imp.getCalibration().pixelHeight, imp.getCalibration().pixelDepth);
            at3D.translate(new double[]{imp.getCalibration().xOrigin * imp.getCalibration().pixelWidth, imp.getCalibration().yOrigin * imp.getCalibration().pixelHeight, imp.getCalibration().zOrigin * imp.getCalibration().pixelDepth});
            return at3D;
        }
        return new AffineTransform3D();
    }

    static void setTimeOriginToImagePlus(ImagePlus imp, int timePoint) {
        if (imp.getInfoProperty() == null) {
            imp.setProperty("Info", (Object)" ");
        }
        String info = imp.getInfoProperty();
        info = info.replaceAll(regexTimePointOrigin, "");
        info = info + "TimePoint: (" + timePoint + ")\n";
        imp.setProperty("Info", (Object)info);
    }

    public static int getTimeOriginFromImagePlus(ImagePlus imp) {
        Pattern pattern;
        Matcher matcher;
        if (imp.getInfoProperty() != null && (matcher = (pattern = Pattern.compile(regexTimePointOrigin)).matcher(imp.getInfoProperty())).find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 0;
    }

    public static <T extends NativeType<T> & NumericType<T>> ImagePlus wrap(SourceAndConverter<T> sac, int mipmapLevel, int beginTimePoint, int nTimePoints, int timeStep) {
        int iTp;
        mipmapLevel = Math.min(mipmapLevel, sac.getSpimSource().getNumMipmapLevels() - 1);
        RandomAccessibleInterval[] rais = new RandomAccessibleInterval[nTimePoints];
        int endTimePoint = beginTimePoint + timeStep * nTimePoints;
        long xSize = 1L;
        long ySize = 1L;
        long zSize = 1L;
        int i = 0;
        for (iTp = beginTimePoint; iTp < endTimePoint; iTp += timeStep) {
            if (!sac.getSpimSource().isPresent(iTp)) continue;
            rais[i] = sac.getSpimSource().getSource(iTp, mipmapLevel);
            xSize = rais[i].dimension(0);
            ySize = rais[i].dimension(1);
            zSize = rais[i].dimension(2);
            break;
        }
        i = 0;
        for (iTp = beginTimePoint; iTp < endTimePoint; iTp += timeStep) {
            rais[i] = sac.getSpimSource().isPresent(iTp) ? sac.getSpimSource().getSource(iTp, mipmapLevel) : new ZerosRAI<NumericType>((NumericType)sac.getSpimSource().getType(), new long[]{xSize, ySize, zSize});
            ++i;
        }
        Img img = (Img)ImagePlusHelper.wrapAsVolatileCachedCellImg(Views.stack((RandomAccessibleInterval[])rais), new int[]{(int)rais[0].dimension(0), (int)rais[0].dimension(1), 1, 1});
        ImgPlus imgPlus = new ImgPlus(img, sac.getSpimSource().getName(), new AxisType[]{Axes.X, Axes.Y, Axes.Z, Axes.TIME});
        ImagePlus imp = ImageJFunctions.wrap((RandomAccessibleInterval)imgPlus, (String)"");
        imp.setTitle(sac.getSpimSource().getName());
        imp.setDimensions(1, (int)rais[0].dimension(2), nTimePoints);
        if (!(sac.getSpimSource().getType() instanceof ARGBType)) {
            ColorConverter converter;
            if (sac.getConverter() instanceof ColorConverter) {
                converter = (ColorConverter)sac.getConverter();
                ARGBType c = converter.getColor();
                imp.setLut(LUT.createLutFromColor((Color)new Color(ARGBType.red((int)c.get()), ARGBType.green((int)c.get()), ARGBType.blue((int)c.get()))));
            }
            if (sac.getConverter() instanceof LinearRange) {
                converter = (LinearRange)sac.getConverter();
                imp.setDisplayRange(converter.getMin(), converter.getMax());
            }
        }
        return imp;
    }

    public static <T extends NumericType<T> & NativeType<T>> ImagePlus wrap(List<SourceAndConverter<T>> sacs, Map<SourceAndConverter<T>, Integer> mipmapMap, int beginTimePoint, int nTimePoints, int timeStep) {
        if (sacs.size() == 1) {
            return ImagePlusHelper.wrap(sacs.get(0), mipmapMap.get(sacs.get(0)), beginTimePoint, nTimePoints, timeStep);
        }
        int endTimePoint = beginTimePoint + timeStep * nTimePoints;
        RandomAccessibleInterval[] raisList = new RandomAccessibleInterval[sacs.size()];
        for (int c = 0; c < sacs.size(); ++c) {
            int iTp;
            SourceAndConverter<T> sac = sacs.get(c);
            RandomAccessibleInterval[] rais = new RandomAccessibleInterval[nTimePoints];
            int mipmapLevel = Math.min(mipmapMap.get(sac), sac.getSpimSource().getNumMipmapLevels() - 1);
            long xSize = 1L;
            long ySize = 1L;
            long zSize = 1L;
            int i = 0;
            for (iTp = beginTimePoint; iTp < endTimePoint; iTp += timeStep) {
                if (!sac.getSpimSource().isPresent(iTp)) continue;
                rais[i] = sac.getSpimSource().getSource(iTp, mipmapLevel);
                xSize = rais[i].dimension(0);
                ySize = rais[i].dimension(1);
                zSize = rais[i].dimension(2);
                break;
            }
            i = 0;
            for (iTp = beginTimePoint; iTp < endTimePoint; iTp += timeStep) {
                rais[i] = sac.getSpimSource().isPresent(iTp) ? sac.getSpimSource().getSource(iTp, mipmapLevel) : new ZerosRAI<NumericType>((NumericType)sac.getSpimSource().getType(), new long[]{xSize, ySize, zSize});
                ++i;
            }
            raisList[c] = Views.stack((RandomAccessibleInterval[])rais);
        }
        Img img = (Img)ImagePlusHelper.wrapAsVolatileCachedCellImg(Views.stack((RandomAccessibleInterval[])raisList), new int[]{(int)raisList[0].dimension(0), (int)raisList[0].dimension(1), 1, 1, 1});
        ImgPlus imgPlus = new ImgPlus(img, "", new AxisType[]{Axes.X, Axes.Y, Axes.Z, Axes.TIME, Axes.CHANNEL});
        ImagePlus imp = HyperStackConverter.toHyperStack((ImagePlus)ImgToVirtualStack.wrap((ImgPlus)imgPlus), (int)sacs.size(), (int)((int)raisList[0].dimension(2)), (int)nTimePoints, (String)"composite");
        LUT[] luts = new LUT[sacs.size()];
        for (SourceAndConverter<T> sac : sacs) {
            LUT lut;
            ColorConverter converter;
            if (sac.getSpimSource().getType() instanceof ARGBType) continue;
            if (sac.getConverter() instanceof ColorConverter) {
                converter = (ColorConverter)sac.getConverter();
                ARGBType c = converter.getColor();
                lut = LUT.createLutFromColor((Color)new Color(ARGBType.red((int)c.get()), ARGBType.green((int)c.get()), ARGBType.blue((int)c.get())));
            } else {
                lut = LUT.createLutFromColor((Color)new Color(ARGBType.red((int)255), ARGBType.green((int)255), ARGBType.blue((int)255)));
            }
            luts[sacs.indexOf(sac)] = lut;
            imp.setC(sacs.indexOf(sac) + 1);
            if (sac.getConverter() instanceof LinearRange) {
                converter = (LinearRange)sac.getConverter();
                lut.min = converter.getMin();
                lut.max = converter.getMax();
            }
            imp.getProcessor().setLut(lut);
        }
        boolean oneIsNull = false;
        for (LUT lut : luts) {
            if (lut != null) continue;
            oneIsNull = true;
            break;
        }
        if (!oneIsNull) {
            ((CompositeImage)imp).setLuts(luts);
        }
        return imp;
    }

    public static <T extends NativeType<T>> RandomAccessibleInterval<T> wrapAsVolatileCachedCellImg(RandomAccessibleInterval<T> source, int[] blockSize) {
        CachedCellImg img;
        long[] dimensions = Intervals.dimensionsAsLongArray(source);
        CellGrid grid = new CellGrid(dimensions, blockSize);
        Caches.RandomAccessibleLoader loader = new Caches.RandomAccessibleLoader((RandomAccessible)Views.zeroMin(source));
        NativeType type = (NativeType)Util.getTypeFromInterval(source);
        Cache cache = new SoftRefLoaderCache().withLoader((CacheLoader)LoadedCellCacheLoader.get((CellGrid)grid, (CellLoader)loader, (NativeType)type, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        if (GenericByteType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.BYTE, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (GenericShortType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.SHORT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (GenericIntType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.INT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (GenericLongType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.LONG, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (FloatType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.FLOAT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (DoubleType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.DOUBLE, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (ARGBType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.INT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else {
            System.err.println("Unsupported caching of type " + type.getClass().getSimpleName());
            img = null;
        }
        return img;
    }
}

