/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.bioformats.command;

import ch.epfl.biop.DatasetHelper;
import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import mpicbg.spim.data.generic.AbstractSpimData;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Open sample dataset", label="Open sample datasets", description="Downloads and cache datasets on first open attempt.")
public class OpenSampleCommand
implements Command {
    @Parameter(label="Choose a sample dataset", choices={"VSI", "JPG_RGB", "OLYMPUS_OIR", "LIF", "TIF_TIMELAPSE_3D", "ND2_20X", "ND2_60X", "BOTH_ND2"})
    String datasetname;
    @Parameter(type=ItemIO.OUTPUT)
    AbstractSpimData<?> spimData;

    public void run() {
        Field[] fields = DatasetHelper.class.getFields();
        if (this.datasetname.equals("BOTH_ND2")) {
            int i;
            File f20 = DatasetHelper.getDataset("https://github.com/NicoKiaru/TestImages/raw/master/ND2/20x_g5_a1.nd2");
            File f60 = DatasetHelper.getDataset("https://github.com/NicoKiaru/TestImages/raw/master/ND2/60x_g5_a1.nd2");
            Length micron = new Length((Number)1, UNITS.MICROMETER);
            Length millimeter = new Length((Number)1, UNITS.MILLIMETER);
            ArrayList<OpenerSettings> settings = new ArrayList<OpenerSettings>();
            for (i = 0; i < BioFormatsHelper.getNSeries(f20); ++i) {
                OpenerSettings opener20 = new OpenerSettings().location(f20).centerPositionConvention().millimeter().voxSizeReferenceFrameLength(millimeter).positionReferenceFrameLength(micron).bioFormatsBuilder().setSerie(i).cornerPositionConvention();
                settings.add(opener20);
            }
            for (i = 0; i < BioFormatsHelper.getNSeries(f60); ++i) {
                OpenerSettings opener60 = new OpenerSettings().location(f60).centerPositionConvention().millimeter().voxSizeReferenceFrameLength(millimeter).positionReferenceFrameLength(micron).bioFormatsBuilder().setSerie(i).cornerPositionConvention();
                settings.add(opener60);
            }
            this.spimData = OpenersToSpimData.getSpimData(settings);
            return;
        }
        for (Field f : fields) {
            if (!f.getName().equals(this.datasetname.toUpperCase())) continue;
            try {
                this.datasetname = (String)f.get(null);
                if (this.datasetname.equals("https://github.com/NicoKiaru/TestImages/raw/master/VSI/Fluo3DFluoImage2Channels_01.vsi")) {
                    DatasetHelper.getSampleVSIDataset();
                }
                File file = DatasetHelper.getDataset(this.datasetname);
                this.spimData = OpenersToSpimData.getSpimData(new OpenerSettings().location(file).voxSizeReferenceFrameLength(new Length((Number)1, UNITS.MILLIMETER)).positionReferenceFrameLength(new Length((Number)1, UNITS.MILLIMETER)).bioFormatsBuilder());
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        System.err.println("Dataset not found!");
    }
}

