/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.bioformats.command;

import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import java.io.File;
import java.util.ArrayList;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Create BDV Dataset from file", description="Bridge between Bio-Formats (BioFormats) and BigDataViewer. You can create a BDV dataset from a Bio-Formats supported file.")
public class CreateBdvDatasetBioFormatsSimpleCommand
implements Command {
    @Parameter(visibility=ItemVisibility.MESSAGE)
    public String datasetname = "";
    @Parameter(label="File", callback="setDatasetName")
    File file;
    boolean auto_pyramidize = true;
    public String unit = "MILLIMETER";
    String plane_origin_convention = "TOP LEFT";
    @Parameter(type=ItemIO.OUTPUT)
    AbstractSpimData<?> spimdata;
    @Parameter
    Context ctx;

    public void run() {
        ArrayList<OpenerSettings> openerSettings = new ArrayList<OpenerSettings>();
        int nSeries = BioFormatsHelper.getNSeries(this.file);
        for (int i = 0; i < nSeries; ++i) {
            openerSettings.add(OpenerSettings.BioFormats().location(this.file).setSerie(i).unit(this.unit).splitRGBChannels(FilenameUtils.getExtension((String)this.file.getAbsolutePath()).equals("czi")).positionConvention(this.plane_origin_convention).pyramidize(this.auto_pyramidize).context(this.ctx));
        }
        if (this.datasetname != null && this.datasetname.trim().isEmpty()) {
            if (this.file.getAbsolutePath().toUpperCase().endsWith(".OME.TIFF") || this.file.getAbsolutePath().toUpperCase().endsWith(".OME.TIF")) {
                this.datasetname = FilenameUtils.getName((String)this.file.getAbsolutePath());
                this.datasetname = FilenameUtils.getName((String)this.datasetname);
            } else {
                this.datasetname = FilenameUtils.getName((String)this.file.getAbsolutePath());
            }
        }
        this.spimdata = OpenersToSpimData.getSpimData(openerSettings);
    }

    void setDatasetName() {
        if (this.file == null) {
            return;
        }
        if (this.file.getAbsolutePath().toUpperCase().endsWith(".OME.TIFF") || this.file.getAbsolutePath().toUpperCase().endsWith(".OME.TIF")) {
            this.datasetname = FilenameUtils.getBaseName((String)this.file.getAbsolutePath());
            this.datasetname = FilenameUtils.getBaseName((String)this.datasetname);
        } else {
            this.datasetname = FilenameUtils.getBaseName((String)this.file.getAbsolutePath());
        }
    }
}

