/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.bioformats.command;

import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import java.io.File;
import java.util.ArrayList;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Create BDV Dataset for BVV (16-bits) [Bio-Formats]", description="Bridge between Bio-Formats (BioFormats) and BigDataViewer. You can create a BDV dataset from a set of Bio-Formats supported files.")
public class CreateBdvDatasetBioFormats16bitsCommand
implements Command {
    @Parameter(label="Name of this dataset")
    public String datasetname = "dataset";
    @Parameter(required=false, label="Physical units of the dataset", choices={"MILLIMETER", "MICROMETER", "NANOMETER"})
    public String unit = "MILLIMETER";
    @Parameter(label="Dataset files")
    File[] files;
    @Parameter(label="Split RGB channels")
    boolean split_rgb_channels = false;
    @Parameter(required=false, label="Plane Origin Convention", choices={"CENTER", "TOP LEFT"})
    String plane_origin_convention = "CENTER";
    @Parameter(type=ItemIO.OUTPUT)
    AbstractSpimData<?> spimdata;
    @Parameter
    Context ctx;

    public void run() {
        ArrayList<OpenerSettings> openerSettings = new ArrayList<OpenerSettings>();
        for (File f : this.files) {
            int nSeries = BioFormatsHelper.getNSeries(f);
            for (int i = 0; i < nSeries; ++i) {
                openerSettings.add(OpenerSettings.BioFormats().location(f).setSerie(i).unit(this.unit).to16bits(true).splitRGBChannels(this.split_rgb_channels).positionConvention(this.plane_origin_convention).context(this.ctx));
            }
        }
        this.spimdata = OpenersToSpimData.getSpimData(openerSettings);
    }
}

