/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.bioformats.command;

import bdv.util.BdvFunctions;
import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import java.io.File;
import java.util.ArrayList;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Bio-Formats>Open File with Bio-Formats", description="Support Bio-Formats multiresolution API. Set colors based on bioformats metadata. Do not attempt auto contrast.")
public class BdvShowFileBioFormatsCommand
implements Command {
    @Parameter(required=false, label="Physical units of the dataset", choices={"MILLIMETER", "MICROMETER", "NANOMETER"})
    public String unit = "MILLIMETER";
    @Parameter(label="File to open", style="open")
    File file;
    @Parameter(required=false, label="Split RGB channels if you have 16 bits RGB images")
    boolean splitrgbchannels = true;
    @Parameter(required=false, label="Image metadata location = ", choices={"CENTER", "TOP LEFT"})
    String position_convention = "CENTER";

    public void run() {
        ArrayList<OpenerSettings> openerSettings = new ArrayList<OpenerSettings>();
        int nSeries = BioFormatsHelper.getNSeries(this.file);
        for (int i = 0; i < nSeries; ++i) {
            openerSettings.add(OpenerSettings.BioFormats().location(this.file).setSerie(i).unit(this.unit).splitRGBChannels(this.splitrgbchannels).positionConvention(this.position_convention));
        }
        AbstractSpimData<?> spimData = OpenersToSpimData.getSpimData(openerSettings);
        BdvFunctions.show(spimData);
    }
}

