/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.bioformats;

import bdv.img.cache.CacheArrayLoader;
import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.OpenerSetupLoader;
import ch.epfl.biop.bdv.img.ResourcePool;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsArrayLoaders;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsOpener;
import java.util.function.Function;
import java.util.function.Supplier;
import loci.formats.IFormatReader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioFormatsSetupLoader<T extends NumericType<T> & NativeType<T>, V extends Volatile<T> & NativeType<V>, A extends DataAccess>
extends OpenerSetupLoader<T, V, A> {
    private static final Logger logger = LoggerFactory.getLogger(BioFormatsSetupLoader.class);
    private final Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<FloatType>> cvtRaiToFloatRai;
    private final Converter<T, FloatType> cvt;
    private final ResourcePool<IFormatReader> readerPool;
    private final Supplier<VolatileGlobalCellCache> cacheSupplier;
    private final CacheArrayLoader<A> loader;
    private final double[][] mmResolutions;
    private final int[] cellDimensions;
    private final int numMipmapLevels;
    private final int iChannel;
    private final int setup;
    private final Dimensions[] dimensions;
    private final VoxelDimensions voxelsDimensions;

    protected BioFormatsSetupLoader(BioFormatsOpener opener, int channelIndex, int iSeries, int setup, T t, V v, Supplier<VolatileGlobalCellCache> cacheSupplier) {
        super(t, v);
        this.setup = setup;
        this.cacheSupplier = cacheSupplier;
        this.readerPool = opener.getPixelReader();
        if (t instanceof FloatType) {
            this.cvt = null;
            this.cvtRaiToFloatRai = null;
        } else if (t instanceof ARGBType) {
            this.cvt = (input, output) -> {
                int val = ((ARGBType)input).get();
                int r = ARGBType.red((int)val);
                int g = ARGBType.green((int)val);
                int b = ARGBType.blue((int)val);
                output.set((float)(r + g + b));
            };
            this.cvtRaiToFloatRai = rai -> Converters.convert((RandomAccessibleInterval)rai, this.cvt, (Type)new FloatType());
        } else if (t instanceof AbstractIntegerType) {
            this.cvt = (input, output) -> output.set(((AbstractIntegerType)input).getRealFloat());
            this.cvtRaiToFloatRai = rai -> Converters.convert((RandomAccessibleInterval)rai, this.cvt, (Type)new FloatType());
        } else {
            this.cvt = null;
            this.cvtRaiToFloatRai = e -> {
                logger.error("Conversion of " + t.getClass() + " to FloatType unsupported.");
                return null;
            };
        }
        this.iChannel = channelIndex;
        boolean isLittleEndian = opener.isLittleEndian();
        this.voxelsDimensions = opener.getVoxelDimensions();
        this.dimensions = opener.getDimensions();
        this.numMipmapLevels = opener.getNumMipmapLevels();
        this.cellDimensions = opener.getCellDimensions(0);
        this.mmResolutions = new double[this.numMipmapLevels][3];
        this.mmResolutions[0][0] = 1.0;
        this.mmResolutions[0][1] = 1.0;
        this.mmResolutions[0][2] = 1.0;
        if (opener.getImageFormat().equals("CellSens VSI")) {
            for (int iLevel = 1; iLevel < this.numMipmapLevels; ++iLevel) {
                double downscalingFactor;
                this.mmResolutions[iLevel][0] = downscalingFactor = Math.pow(2.0, iLevel);
                this.mmResolutions[iLevel][1] = downscalingFactor;
                this.mmResolutions[iLevel][2] = 1.0;
            }
        } else {
            int[] srcL0dims = new int[]{(int)this.dimensions[0].dimension(0), (int)this.dimensions[0].dimension(1), (int)this.dimensions[0].dimension(2)};
            for (int iLevel = 1; iLevel < this.numMipmapLevels; ++iLevel) {
                int[] srcLidims = new int[]{(int)this.dimensions[iLevel].dimension(0), (int)this.dimensions[iLevel].dimension(1), (int)this.dimensions[iLevel].dimension(2)};
                this.mmResolutions[iLevel][0] = (double)srcL0dims[0] / (double)srcLidims[0];
                this.mmResolutions[iLevel][1] = (double)srcL0dims[1] / (double)srcLidims[1];
                this.mmResolutions[iLevel][2] = (double)srcL0dims[2] / (double)srcLidims[2];
            }
        }
        if (t instanceof UnsignedByteType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsUnsignedByteArrayLoader(this.readerPool, this.iChannel, iSeries);
        } else if (t instanceof UnsignedShortType) {
            this.loader = opener.to16bit() ? new BioFormatsArrayLoaders.BioFormatsUnsignedByteToUnsignedShortArrayLoader(this.readerPool, this.iChannel, iSeries) : new BioFormatsArrayLoaders.BioFormatsUnsignedShortArrayLoader(this.readerPool, this.iChannel, iSeries, isLittleEndian);
        } else if (t instanceof ShortType) {
            if (opener.to16bit()) {
                throw new UnsupportedOperationException("Pixel type " + t.getClass().getName() + " conversion to 16 bits unsupported in " + BioFormatsSetupLoader.class.getName());
            }
            this.loader = new BioFormatsArrayLoaders.BioFormatsShortArrayLoader(this.readerPool, this.iChannel, iSeries, isLittleEndian);
        } else if (t instanceof FloatType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsFloatArrayLoader(this.readerPool, this.iChannel, iSeries, isLittleEndian);
        } else if (t instanceof IntType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsIntArrayLoader(this.readerPool, this.iChannel, iSeries, isLittleEndian);
        } else if (t instanceof ARGBType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsRGBArrayLoader(this.readerPool, this.iChannel, iSeries, opener.hasAlphaChannel());
        } else if (t instanceof UnsignedIntType) {
            this.loader = new BioFormatsArrayLoaders.BioFormatsIntArrayLoader(this.readerPool, this.iChannel, iSeries, opener.hasAlphaChannel());
        } else {
            throw new UnsupportedOperationException("Pixel type " + t.getClass().getName() + " unsupported in " + BioFormatsSetupLoader.class.getName());
        }
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, int level, boolean normalize, ImgLoaderHint ... hints) {
        return this.cvtRaiToFloatRai.apply(this.getImage(timepointId, level, new ImgLoaderHint[0]));
    }

    public Dimensions getImageSize(int timepointId, int level) {
        return this.dimensions[level];
    }

    public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
        long[] dims = this.dimensions[level].dimensionsAsLongArray();
        int[] cellDimensions = this.cellDimensions;
        CellGrid grid = new CellGrid(dims, cellDimensions);
        int priority = this.numMipmapLevels - level;
        CacheHints cacheHints = new CacheHints(LoadingStrategy.BLOCKING, priority, false);
        return this.cacheSupplier.get().createImg(grid, timepointId, this.setup, level, cacheHints, this.loader, (NativeType)this.type);
    }

    public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
        long[] dims = this.dimensions[level].dimensionsAsLongArray();
        int[] cellDimensions = this.cellDimensions;
        CellGrid grid = new CellGrid(dims, cellDimensions);
        int priority = this.numMipmapLevels - level;
        CacheHints cacheHints = new CacheHints(LoadingStrategy.BUDGETED, priority, false);
        return this.cacheSupplier.get().createImg(grid, timepointId, this.setup, level, cacheHints, this.loader, (NativeType)this.volatileType);
    }

    public double[][] getMipmapResolutions() {
        return this.mmResolutions;
    }

    public AffineTransform3D[] getMipmapTransforms() {
        AffineTransform3D[] ats = new AffineTransform3D[this.numMipmapLevels];
        for (int iLevel = 0; iLevel < this.numMipmapLevels; ++iLevel) {
            AffineTransform3D at = new AffineTransform3D();
            at.scale(this.mmResolutions[iLevel][0], this.mmResolutions[iLevel][1], this.mmResolutions[iLevel][2]);
            ats[iLevel] = at;
        }
        return ats;
    }

    public int numMipmapLevels() {
        return this.numMipmapLevels;
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, boolean normalize, ImgLoaderHint ... hints) {
        return this.cvtRaiToFloatRai.apply(this.getImage(timepointId, 0, new ImgLoaderHint[0]));
    }

    public Dimensions getImageSize(int timepointId) {
        return this.getImageSize(0, 0);
    }

    public VoxelDimensions getVoxelSize(int timepointId) {
        return this.voxelsDimensions;
    }
}

