/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.bioformats;

import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.OpenerSetupLoader;
import ch.epfl.biop.bdv.img.ResourcePool;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsSetupLoader;
import ch.epfl.biop.bdv.img.bioformats.entity.FileName;
import ch.epfl.biop.bdv.img.bioformats.entity.SeriesIndex;
import ch.epfl.biop.bdv.img.entity.Field;
import ch.epfl.biop.bdv.img.entity.Well;
import ch.epfl.biop.bdv.img.opener.ChannelProperties;
import ch.epfl.biop.bdv.img.opener.Opener;
import ch.epfl.biop.bdv.img.opener.OpenerHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Memoizer;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Plate;
import ome.xml.model.WellSample;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioFormatsOpener
implements Opener<IFormatReader> {
    protected static final Logger logger = LoggerFactory.getLogger(BioFormatsOpener.class);
    private final ReaderPool pool;
    private final int nTimePoints;
    private final String format;
    private final IMetadata omeMeta;
    private final String dataLocation;
    private final boolean memoize;
    private final boolean isLittleEndian;
    private final boolean isRGB;
    private final boolean hasAlphaChannel;
    private final VoxelDimensions voxelDimensions;
    private final Type<? extends NumericType<?>> t;
    private final int[] cellDimensions;
    private final int nMipMapLevels;
    private final Dimensions[] dimensions;
    private final boolean splitRGBChannels;
    private final int nChannels;
    private final int iSerie;
    private final String rawPixelDataKey;
    private final String filename;
    private final int idxFilename;
    private final Opener.OpenerMeta meta;
    private final Map<String, String> readerOptions;
    static ServiceFactory factory;
    static OMEXMLService service;
    boolean to16Bits = false;

    public BioFormatsOpener(Context context, String dataLocation, final int iSerie, double[] positionPreTransformMatrixArray, double[] positionPostTransformMatrixArray, boolean positionIsImageCenter, Length defaultSpaceUnit, Length defaultVoxelUnit, String unit, int poolSize, boolean useDefaultXYBlockSize, int[] cacheBlockSize, boolean splitRGBChannels, final Map<String, Object> cachedObjects, int defaultNumberOfChannels, boolean skipMeta, boolean to16Bits, final String options) throws Exception {
        if (iSerie < 0) {
            throw new IllegalStateException("Invalid series number for file " + dataLocation + " iSerie = " + iSerie + " requested");
        }
        this.readerOptions = BioFormatsOpener.bfOptionsToMap(options);
        this.dataLocation = dataLocation;
        this.iSerie = iSerie;
        this.splitRGBChannels = splitRGBChannels;
        String buildRawPixelDataKey = "opener.bioformats." + splitRGBChannels + "." + dataLocation + "." + iSerie + "." + options;
        if (!useDefaultXYBlockSize) {
            buildRawPixelDataKey = buildRawPixelDataKey + "." + Arrays.toString(cacheBlockSize);
        }
        this.rawPixelDataKey = buildRawPixelDataKey;
        this.memoize = this.readerOptions.containsKey("use_bfmemo") ? Boolean.getBoolean(this.readerOptions.get("use_bfmemo")) : true;
        logger.debug("Unique key for bio-formats opener: " + this.rawPixelDataKey);
        logger.debug("Using memoization for bio-formats opener: " + this.memoize);
        this.filename = new File(dataLocation).getName();
        Integer currentIndexFilename = OpenerHelper.memoize("opener.bioformats.currentfileindex", cachedObjects, () -> 0);
        this.idxFilename = OpenerHelper.memoize("opener.bioformats.fileindex." + dataLocation + "." + options, cachedObjects, () -> {
            cachedObjects.put("opener.bioformats.currentfileindex", currentIndexFilename + 1);
            return currentIndexFilename;
        });
        this.pool = OpenerHelper.memoize("opener.bioformats." + splitRGBChannels + "." + dataLocation + "." + options, cachedObjects, () -> {
            logger.debug("Creating pool for opener.bioformats." + splitRGBChannels + "." + dataLocation + "." + options);
            try {
                return new ReaderPool(poolSize, true, this::getNewReader, dataLocation.toUpperCase().trim().endsWith(".CZI"));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        IFormatReader reader = (IFormatReader)this.pool.acquire();
        reader.setSeries(iSerie);
        this.omeMeta = (IMetadata)reader.getMetadataStore();
        this.nChannels = this.omeMeta.getChannelCount(iSerie);
        this.nMipMapLevels = reader.getResolutionCount();
        this.nTimePoints = reader.getSizeT();
        Unit u = BioFormatsHelper.getUnitFromString(unit);
        if (u == null) {
            logger.error("Could not find matching length unit from String: " + unit);
            u = UNITS.REFERENCEFRAME;
        }
        this.voxelDimensions = BioFormatsHelper.getSeriesVoxelDimensions(this.omeMeta, this.iSerie, u, defaultVoxelUnit);
        this.isLittleEndian = reader.isLittleEndian();
        this.isRGB = reader.isRGB();
        this.hasAlphaChannel = reader.getSizeC() == 4;
        this.format = reader.getFormat();
        this.cellDimensions = new int[]{useDefaultXYBlockSize ? reader.getOptimalTileWidth() : cacheBlockSize[0], useDefaultXYBlockSize ? reader.getOptimalTileHeight() : cacheBlockSize[1], useDefaultXYBlockSize ? 1 : cacheBlockSize[2]};
        this.dimensions = new Dimensions[this.nMipMapLevels];
        for (int level = 0; level < this.nMipMapLevels; ++level) {
            reader.setResolution(level);
            this.dimensions[level] = BioFormatsOpener.getDimension(reader.getSizeX(), reader.getSizeY(), reader.getSizeZ());
        }
        int pixelType = reader.getPixelType();
        this.pool.recycle(reader);
        this.to16Bits = to16Bits;
        Type type = this.t = to16Bits ? new Type() : BioFormatsOpener.getBioformatsBdvSourceType(pixelType, this.isRGB, iSerie);
        if (!skipMeta) {
            final AffineTransform3D rootTransform = BioFormatsHelper.getSeriesRootTransform(this.omeMeta, iSerie, BioFormatsHelper.getUnitFromString(unit), positionPreTransformMatrixArray, positionPostTransformMatrixArray, defaultSpaceUnit, positionIsImageCenter, new AffineTransform3D().getRowPackedCopy(), new AffineTransform3D().getRowPackedCopy(), defaultVoxelUnit, new boolean[]{false, false, false});
            final String imageName = BioFormatsOpener.getImageName(this.omeMeta, iSerie, dataLocation);
            final List<ChannelProperties> channelPropertiesList = this.getChannelProperties(this.omeMeta, iSerie, this.nChannels);
            this.meta = new Opener.OpenerMeta(){

                @Override
                public ChannelProperties getChannel(int iChannel) {
                    if (iChannel >= BioFormatsOpener.this.nChannels) {
                        logger.error("You are trying to get the channel " + iChannel + " in an image with only " + BioFormatsOpener.this.nChannels);
                        return null;
                    }
                    return (ChannelProperties)channelPropertiesList.get(iChannel);
                }

                @Override
                public List<Entity> getEntities(int iChannel) {
                    ArrayList<Entity> entityList = new ArrayList<Entity>();
                    entityList.add((Entity)new FileName(BioFormatsOpener.this.idxFilename, BioFormatsOpener.this.filename));
                    entityList.add(new SeriesIndex(iSerie));
                    BioFormatsOpener.this.addPlateInfo(entityList, options, iSerie, cachedObjects);
                    return entityList;
                }

                @Override
                public String getImageName() {
                    return imageName;
                }

                @Override
                public AffineTransform3D getTransform() {
                    return rootTransform;
                }
            };
        } else {
            this.meta = null;
        }
    }

    private void addPlateInfo(ArrayList<Entity> entityList, String options, int iSerie, Map<String, Object> cachedObjects) {
        if (this.omeMeta.getPlateCount() == 0) {
            return;
        }
        if (this.omeMeta.getPlateCount() > 1) {
            logger.warn("Plate information ignored: only bio-formats containing single wells are supported");
            return;
        }
        if (!(this.omeMeta.getRoot() instanceof OMEXMLMetadataRoot)) {
            logger.warn("Can't detect plate information since ome meta root is not of class OMEXMLMetadataRoot");
            return;
        }
        OMEXMLMetadataRoot r = (OMEXMLMetadataRoot)this.omeMeta.getRoot();
        Plate plate = r.getPlate(0);
        Integer currentPlateIndex = OpenerHelper.memoize("opener.bioformats.currentplateindex", cachedObjects, () -> 0);
        int idxPlate = OpenerHelper.memoize("opener.bioformats.plateIndex." + this.dataLocation + "." + options, cachedObjects, () -> {
            cachedObjects.put("opener.bioformats.currentplateindex", currentPlateIndex + 1);
            return currentPlateIndex;
        });
        entityList.add((Entity)new ch.epfl.biop.bdv.img.entity.Plate(idxPlate, plate.getName()));
        Map idToWellSample = OpenerHelper.memoize("opener.bioformats.idtowell." + this.dataLocation + "." + options, cachedObjects, () -> {
            HashMap idToWS = new HashMap();
            plate.copyWellList().forEach(well -> well.copyWellSampleList().forEach(ws -> {
                if (ws.getLinkedImage() != null && ws.getLinkedImage().getID() != null) {
                    idToWS.put(Integer.parseInt(ws.getLinkedImage().getID().split(":")[1]), ws);
                }
            }));
            return idToWS;
        });
        if (idToWellSample.containsKey(iSerie)) {
            WellSample ws = (WellSample)idToWellSample.get(iSerie);
            System.out.println("ws=" + ws.getID());
            int id = Integer.parseInt(ws.getID().split(":")[3]);
            entityList.add(new Field(id));
            if (ws.getWell() != null) {
                ome.xml.model.Well w = ws.getWell();
                entityList.add((Entity)new Well(Integer.parseInt(w.getID().split(":")[2]), (char)((Integer)w.getRow().getValue() + 65) + Integer.toString((Integer)w.getColumn().getValue() + 1), (Integer)w.getRow().getValue(), (Integer)w.getColumn().getValue()));
            }
        }
    }

    private List<ChannelProperties> getChannelProperties(IMetadata omeMeta, int iSerie, int nChannels) {
        ArrayList<ChannelProperties> channelPropertiesList = new ArrayList<ChannelProperties>();
        for (int i = 0; i < nChannels; ++i) {
            channelPropertiesList.add(new ChannelProperties(i).setNChannels(nChannels).setChannelName(iSerie, omeMeta).setEmissionWavelength(iSerie, omeMeta).setExcitationWavelength(iSerie, omeMeta).setChannelColor(iSerie, omeMeta).setRGB(this.isRGB).setPixelType(this.t).setDisplayRange(0.0, 255.0));
        }
        return channelPropertiesList;
    }

    private static String getImageName(IMetadata omeMeta, int iSerie, String dataLocation) {
        String imageName = omeMeta.getImageName(iSerie);
        String fileNameWithoutExtension = FilenameUtils.removeExtension((String)new File(dataLocation).getName());
        fileNameWithoutExtension = fileNameWithoutExtension.replace(".ome", "");
        if (imageName == null || imageName.isEmpty()) {
            imageName = fileNameWithoutExtension;
            return imageName + "-s" + iSerie;
        }
        return imageName;
    }

    public static Map<String, String> bfOptionsToMap(String options) {
        LinkedHashMap<String, String> readerOptions = new LinkedHashMap<String, String>();
        try {
            String[] opts = options.split(" ");
            for (int i = 0; i < opts.length; ++i) {
                String[] kv;
                if (!opts[i].trim().equals("--bfOptions")) continue;
                if ((kv = opts[++i].split("=")).length != 2) {
                    kv = opts[i + 1].split("\\u003d");
                }
                if (kv.length != 2) continue;
                if (kv[0].trim().startsWith("-")) {
                    kv[0] = kv[0].substring(1).trim();
                }
                readerOptions.put(kv[0], kv[1].trim());
            }
        }
        catch (Exception e) {
            System.err.println("Could not parse bio formats args: " + options);
            e.printStackTrace();
        }
        return readerOptions;
    }

    public IFormatReader getNewReader() {
        MetadataOptions metadataOptions;
        logger.debug("Getting new reader for " + this.dataLocation);
        ImageReader reader = new ImageReader();
        reader.setFlattenedResolutions(false);
        if (!this.readerOptions.isEmpty() && (metadataOptions = reader.getMetadataOptions()) instanceof DynamicMetadataOptions) {
            try {
                reader.setMetadataStore((MetadataStore)service.createOMEXMLMetadata());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Map.Entry<String, String> option : this.readerOptions.entrySet()) {
                logger.debug("setting reader option:" + option.getKey() + ":" + option.getValue());
                ((DynamicMetadataOptions)metadataOptions).set(option.getKey(), option.getValue());
            }
        }
        if (this.splitRGBChannels) {
            reader = new ChannelSeparator((IFormatReader)reader);
        }
        if (this.memoize) {
            Memoizer memo = new Memoizer((IFormatReader)reader);
            try {
                memo.setId(this.dataLocation);
            }
            catch (IOException | FormatException e) {
                e.printStackTrace();
            }
            return memo;
        }
        try {
            reader.setId(this.dataLocation);
        }
        catch (IOException | FormatException e) {
            e.printStackTrace();
        }
        return reader;
    }

    private static Type<? extends NumericType<?>> getBioformatsBdvSourceType(int pt, boolean isReaderRGB, int image_index) throws UnsupportedOperationException {
        if (isReaderRGB) {
            if (pt == 1) {
                return new ARGBType();
            }
            throw new UnsupportedOperationException("Unhandled 16 bits RGB images");
        }
        if (pt == 1) {
            return new UnsignedByteType();
        }
        if (pt == 3) {
            return new UnsignedShortType();
        }
        if (pt == 4) {
            return new IntType();
        }
        if (pt == 6) {
            return new FloatType();
        }
        if (pt == 5) {
            return new UnsignedIntType();
        }
        if (pt == 2) {
            return new ShortType();
        }
        throw new UnsupportedOperationException("Unhandled pixel type for serie " + image_index + ": " + pt);
    }

    @Override
    public String getImageFormat() {
        return this.format;
    }

    static Dimensions getDimension(final long sizeX, final long sizeY, final long sizeZ) {
        return new Dimensions(){

            public long dimension(int d) {
                if (d == 0) {
                    return sizeX;
                }
                if (d == 1) {
                    return sizeY;
                }
                return sizeZ;
            }

            public int numDimensions() {
                return 3;
            }
        };
    }

    @Override
    public int getNumMipmapLevels() {
        return this.nMipMapLevels;
    }

    @Override
    public int getNTimePoints() {
        return this.nTimePoints;
    }

    @Override
    public ResourcePool<IFormatReader> getPixelReader() {
        return this.pool;
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return this.voxelDimensions;
    }

    @Override
    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    @Override
    public OpenerSetupLoader<?, ?, ?> getSetupLoader(int channelIdx, int setupIdx, Supplier<VolatileGlobalCellCache> cacheSupplier) {
        return new BioFormatsSetupLoader(this, channelIdx, this.iSerie, setupIdx, (NumericType)this.getPixelType(), OpenerHelper.getVolatileOf((NumericType)this.getPixelType()), cacheSupplier);
    }

    @Override
    public String getRawPixelDataKey() {
        return this.rawPixelDataKey;
    }

    @Override
    public Opener.OpenerMeta getMeta() {
        return this.meta;
    }

    @Override
    public int[] getCellDimensions(int level) {
        return this.cellDimensions;
    }

    @Override
    public Dimensions[] getDimensions() {
        return this.dimensions;
    }

    @Override
    public int getNChannels() {
        return this.nChannels;
    }

    @Override
    public Type<? extends NumericType<?>> getPixelType() {
        return this.t;
    }

    @Override
    public void close() {
        this.getPixelReader().shutDown(reader -> {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public boolean to16bit() {
        return this.to16Bits;
    }

    public boolean hasAlphaChannel() {
        return this.hasAlphaChannel;
    }

    static {
        try {
            factory = new ServiceFactory();
            service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        }
        catch (DependencyException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ReaderPool
    extends ResourcePool<IFormatReader> {
        final Supplier<IFormatReader> readerSupplier;
        final IFormatReader model;
        volatile boolean modelHasBeenRecycled = false;

        public ReaderPool(int size, Boolean dynamicCreation, Supplier<IFormatReader> readerSupplier, boolean createBase) throws Exception {
            super(size, dynamicCreation);
            this.readerSupplier = readerSupplier;
            this.model = createBase ? (IFormatReader)this.acquire() : null;
        }

        @Override
        public IFormatReader createObject() {
            if (this.model != null && BioFormatsHelper.hasCopyMethod(this.model)) {
                return BioFormatsHelper.copy(this.model);
            }
            return this.readerSupplier.get();
        }

        @Override
        public synchronized void shutDown(Consumer<IFormatReader> closer) {
            if (!this.modelHasBeenRecycled) {
                this.modelHasBeenRecycled = true;
                if (this.model != null) {
                    try {
                        this.recycle(this.model);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    closer.accept(this.model);
                }
            }
            super.shutDown(closer);
        }
    }
}

