/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.bioformats;

import ch.epfl.biop.bdv.img.bioformats.BioFormatsOpener;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Memoizer;
import loci.formats.ReaderWrapper;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.realtransform.AffineTransform3D;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioFormatsHelper {
    protected static final Logger logger = LoggerFactory.getLogger(BioFormatsHelper.class);
    static ServiceFactory factory;
    static OMEXMLService service;

    public static int getNSeries(File f) {
        return BioFormatsHelper.getNSeries(f, "");
    }

    public static int getNSeries(File f, String options) {
        logger.debug("Getting opener for file f " + f.getAbsolutePath());
        ImageReader reader = new ImageReader();
        reader.setFlattenedResolutions(false);
        Map<String, String> readerOptions = BioFormatsOpener.bfOptionsToMap(options);
        MetadataOptions metadataOptions = reader.getMetadataOptions();
        boolean memoize = true;
        if (!readerOptions.isEmpty() && metadataOptions instanceof DynamicMetadataOptions) {
            try {
                reader.setMetadataStore((MetadataStore)service.createOMEXMLMetadata());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Map.Entry<String, String> option : readerOptions.entrySet()) {
                if (option.getKey().equals("use_bfmemo")) {
                    memoize = Boolean.getBoolean(option.getValue());
                }
                logger.debug("setting reader option:" + option.getKey() + ":" + option.getValue());
                ((DynamicMetadataOptions)metadataOptions).set(option.getKey(), option.getValue());
            }
        }
        if (memoize) {
            reader = new Memoizer((IFormatReader)reader);
        }
        int nSeries = 0;
        try {
            logger.debug("setId for reader " + f.getAbsolutePath());
            StopWatch watch = new StopWatch();
            watch.start();
            reader.setId(f.getAbsolutePath());
            nSeries = reader.getSeriesCount();
            watch.stop();
            logger.debug("id set in " + (int)(watch.getTime() / 1000L) + " s");
        }
        catch (Exception e) {
            System.err.println("Error in file " + f.getAbsolutePath() + ": " + e.getMessage());
            e.printStackTrace();
        }
        return nSeries;
    }

    public static Length[] getSeriesPositionAsLengths(IMetadata omeMeta, int iSerie) {
        Length[] pos = new Length[3];
        try {
            pos[0] = omeMeta.getPlanePositionX(iSerie, 0) != null ? omeMeta.getPlanePositionX(iSerie, 0) : new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[1] = omeMeta.getPlanePositionY(iSerie, 0) != null ? omeMeta.getPlanePositionY(iSerie, 0) : new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[2] = omeMeta.getPlanePositionZ(iSerie, 0) != null ? omeMeta.getPlanePositionZ(iSerie, 0) : new Length((Number)0, UNITS.REFERENCEFRAME);
        }
        catch (Exception e) {
            logger.warn("Could not access omeMeta.getPlanePosition serie " + iSerie);
            pos[0] = new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[1] = new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[2] = new Length((Number)0, UNITS.REFERENCEFRAME);
        }
        logger.debug("Ch Name=" + omeMeta.getChannelName(iSerie, 0));
        logger.debug("pos[0]=" + pos[0].value() + " " + pos[0].unit().getSymbol());
        logger.debug("pos[1]=" + pos[1].value() + " " + pos[1].unit().getSymbol());
        logger.debug("pos[2]=" + pos[2].value() + " " + pos[2].unit().getSymbol());
        return pos;
    }

    public static Length[] getSeriesVoxelSizeAsLengths(IMetadata omeMeta, int iSerie) {
        Length[] vox = new Length[]{omeMeta.getPixelsPhysicalSizeX(iSerie) != null ? omeMeta.getPixelsPhysicalSizeX(iSerie) : new Length((Number)1, UNITS.REFERENCEFRAME), omeMeta.getPixelsPhysicalSizeY(iSerie) != null ? omeMeta.getPixelsPhysicalSizeY(iSerie) : new Length((Number)1, UNITS.REFERENCEFRAME), omeMeta.getPixelsPhysicalSizeZ(iSerie) != null ? omeMeta.getPixelsPhysicalSizeZ(iSerie) : new Length((Number)1, UNITS.REFERENCEFRAME)};
        logger.debug("Ch Name=" + omeMeta.getChannelName(iSerie, 0));
        logger.debug("vox[0]=" + vox[0].value() + " " + vox[0].unit().getSymbol());
        logger.debug("vox[1]=" + vox[1].value() + " " + vox[1].unit().getSymbol());
        logger.debug("vox[2]=" + vox[2].value() + " " + vox[2].unit().getSymbol());
        return vox;
    }

    protected static AffineTransform3D getSeriesRootTransform(IMetadata omeMeta, int iSerie, Unit<Length> u, double[] positionPreTransformMA, double[] positionPostTransformMA, Length positionReferenceFrameLength, boolean positionIsImageCenter, double[] voxSizePreTransformMA, double[] voxSizePostTransformMA, Length voxSizeReferenceFrameLength, boolean[] axesFlip) {
        AffineTransform3D positionPreTransform = null;
        if (positionPreTransformMA != null) {
            positionPreTransform = new AffineTransform3D();
            positionPreTransform.set(positionPreTransformMA);
        }
        AffineTransform3D positionPostTransform = null;
        if (positionPostTransformMA != null) {
            positionPostTransform = new AffineTransform3D();
            positionPostTransform.set(positionPostTransformMA);
        }
        AffineTransform3D voxSizePreTransform = null;
        if (voxSizePreTransformMA != null) {
            voxSizePreTransform = new AffineTransform3D();
            voxSizePreTransform.set(voxSizePreTransformMA);
        }
        AffineTransform3D voxSizePostTransform = null;
        if (voxSizePreTransformMA != null) {
            voxSizePostTransform = new AffineTransform3D();
            voxSizePostTransform.set(voxSizePostTransformMA);
        }
        return BioFormatsHelper.getSeriesRootTransform(omeMeta, iSerie, u, positionPreTransform, positionPostTransform, positionReferenceFrameLength, positionIsImageCenter, voxSizePreTransform, voxSizePostTransform, voxSizeReferenceFrameLength, axesFlip);
    }

    public static AffineTransform3D getSeriesRootTransform(IMetadata omeMeta, int iSerie, Unit<Length> u, AffineTransform3D positionPreTransform, AffineTransform3D positionPostTransform, Length positionReferenceFrameLength, boolean positionIsImageCenter, AffineTransform3D voxSizePreTransform, AffineTransform3D voxSizePostTransform, Length voxSizeReferenceFrameLength, boolean[] axesFlip) {
        Length[] voxSize = BioFormatsHelper.getSeriesVoxelSizeAsLengths(omeMeta, iSerie);
        double[] d = new double[3];
        for (int iDimension = 0; iDimension < 3; ++iDimension) {
            if (voxSize[iDimension].unit() != null && voxSize[iDimension].unit().isConvertible(u).booleanValue()) {
                d[iDimension] = voxSize[iDimension].value(u).doubleValue();
                continue;
            }
            if (voxSize[iDimension].unit().getSymbol().equals("reference frame")) {
                Length l = new Length((Number)(voxSize[iDimension].value().doubleValue() * voxSizeReferenceFrameLength.value().doubleValue()), voxSizeReferenceFrameLength.unit());
                d[iDimension] = l.value(u).doubleValue();
                continue;
            }
            d[iDimension] = 1.0;
        }
        Length[] pos = BioFormatsHelper.getSeriesPositionAsLengths(omeMeta, iSerie);
        double[] p = new double[3];
        Dimensions dims = BioFormatsHelper.getSeriesDimensions(omeMeta, iSerie);
        for (int iDimension = 0; iDimension < 3; ++iDimension) {
            if (pos[iDimension].unit() != null && pos[iDimension].unit().isConvertible(u).booleanValue()) {
                p[iDimension] = pos[iDimension].value(u).doubleValue();
                continue;
            }
            if (pos[iDimension].unit().getSymbol().equals("reference frame")) {
                Length l = new Length((Number)(pos[iDimension].value().doubleValue() * positionReferenceFrameLength.value().doubleValue()), positionReferenceFrameLength.unit());
                p[iDimension] = l.value(u).doubleValue();
                continue;
            }
            p[iDimension] = 0.0;
        }
        AffineTransform3D translateFwd = new AffineTransform3D();
        translateFwd.translate(new double[]{-((double)dims.dimension(0) / 2.0), -((double)dims.dimension(1) / 2.0), -((double)dims.dimension(2) / 2.0)});
        AffineTransform3D translateBwd = new AffineTransform3D();
        translateBwd.translate(new double[]{(double)dims.dimension(0) / 2.0, (double)dims.dimension(1) / 2.0, (double)dims.dimension(2) / 2.0});
        AffineTransform3D flip = new AffineTransform3D();
        flip.scale(axesFlip[0] ? -1.0 : 1.0, axesFlip[1] ? -1.0 : 1.0, axesFlip[2] ? -1.0 : 1.0);
        AffineTransform3D scaleVox = new AffineTransform3D();
        scaleVox.scale(d[0], d[1], d[2]);
        AffineTransform3D position = new AffineTransform3D();
        position.translate(new double[]{p[0], p[1], p[2]});
        AffineTransform3D rootTransform = new AffineTransform3D();
        if (positionPostTransform != null) {
            rootTransform.concatenate(positionPostTransform);
        }
        rootTransform.concatenate(position);
        if (positionPreTransform != null) {
            rootTransform.concatenate(positionPreTransform);
        }
        if (voxSizePostTransform != null) {
            rootTransform.concatenate(voxSizePostTransform);
        }
        rootTransform.concatenate(scaleVox);
        if (positionIsImageCenter) {
            rootTransform.concatenate(translateFwd);
        }
        rootTransform.concatenate(translateBwd);
        rootTransform.concatenate(flip);
        rootTransform.concatenate(translateFwd);
        if (voxSizePreTransform != null) {
            rootTransform.concatenate(voxSizePreTransform);
        }
        return rootTransform;
    }

    public static VoxelDimensions getSeriesVoxelDimensions(IMetadata omeMeta, int iSerie, final Unit<Length> u, Length voxSizeReferenceFrameLength) {
        final int numDimensions = 3;
        Length[] voxSize = BioFormatsHelper.getSeriesVoxelSizeAsLengths(omeMeta, iSerie);
        final double[] d = new double[3];
        for (int iDimension = 0; iDimension < 3; ++iDimension) {
            if (voxSize[iDimension].unit() != null && voxSize[iDimension].unit().isConvertible(u).booleanValue()) {
                d[iDimension] = voxSize[iDimension].value(u).doubleValue();
                continue;
            }
            if (voxSize[iDimension].unit().getSymbol().equals("reference frame")) {
                Length l = new Length((Number)(voxSize[iDimension].value().doubleValue() * voxSizeReferenceFrameLength.value().doubleValue()), voxSizeReferenceFrameLength.unit());
                d[iDimension] = l.value(u).doubleValue();
                continue;
            }
            d[iDimension] = 1.0;
        }
        VoxelDimensions voxelDimensions = new VoxelDimensions(){
            final Unit<Length> targetUnit;
            final double[] dims;
            {
                this.targetUnit = u;
                this.dims = new double[]{d[0], d[1], d[2]};
            }

            public String unit() {
                return this.targetUnit.getSymbol();
            }

            public void dimensions(double[] doubles) {
                doubles[0] = this.dims[0];
                doubles[1] = this.dims[1];
                doubles[2] = this.dims[2];
            }

            public double dimension(int i) {
                return this.dims[i];
            }

            public int numDimensions() {
                return numDimensions;
            }
        };
        return voxelDimensions;
    }

    public static Dimensions getSeriesDimensions(IMetadata omeMeta, int iSerie) {
        final int numDimensions = 3;
        int sX = (Integer)omeMeta.getPixelsSizeX(iSerie).getValue();
        int sY = (Integer)omeMeta.getPixelsSizeY(iSerie).getValue();
        int sZ = (Integer)omeMeta.getPixelsSizeZ(iSerie).getValue();
        final long[] dims = new long[]{sX, sY, sZ};
        Dimensions dimensions = new Dimensions(){

            public void dimensions(long[] dimensions) {
                dimensions[0] = dims[0];
                dimensions[1] = dims[1];
                dimensions[2] = dims[2];
            }

            public long dimension(int d) {
                return dims[d];
            }

            public int numDimensions() {
                return numDimensions;
            }
        };
        return dimensions;
    }

    public static ArrayList<Pair<Integer, ArrayList<Integer>>> getListOfSeriesAndChannels(IFormatReader reader, String code) {
        ArrayList<Pair<Integer, ArrayList<Integer>>> listOfSources = BioFormatsHelper.commaSeparatedListToArrayOfArray(code, idxSeries -> idxSeries >= 0 ? idxSeries : reader.getSeriesCount() + idxSeries, (idxSeries, idxChannel) -> idxChannel >= 0 ? idxChannel : ((IMetadata)reader.getMetadataStore()).getChannelCount(idxSeries.intValue()) + idxChannel);
        return listOfSources;
    }

    public static ArrayList<Pair<Integer, ArrayList<Integer>>> commaSeparatedListToArrayOfArray(String expression, Function<Integer, Integer> fbounds, BiFunction<Integer, Integer, Integer> f) {
        String[] splitIndexes = expression.split(";");
        ArrayList<Pair<Integer, ArrayList<Integer>>> arrayOfArrayOfIndexes = new ArrayList<Pair<Integer, ArrayList<Integer>>>();
        for (String str : splitIndexes) {
            String seriesIdentifier = str = str.trim();
            String channelIdentifier = "*";
            if (str.contains(".")) {
                String[] boundIndex = str.split("\\.");
                if (boundIndex.length == 2) {
                    seriesIdentifier = boundIndex[0];
                    channelIdentifier = boundIndex[1];
                } else {
                    logger.warn("Number format problem with expression:" + str + " - Expression ignored");
                    break;
                }
            }
            try {
                int idxCp;
                int indexMax;
                int indexMin;
                if (seriesIdentifier.trim().equals("*")) {
                    int maxIndex = fbounds.apply(-1);
                    int index = 0;
                    while (index <= maxIndex) {
                        MutablePair current = new MutablePair();
                        int idxCp2 = index++;
                        current.setLeft((Object)idxCp2);
                        current.setRight(BioFormatsHelper.expressionToArray(channelIdentifier, i -> (Integer)f.apply(idxCp2, (Integer)i)));
                        arrayOfArrayOfIndexes.add((Pair<Integer, ArrayList<Integer>>)current);
                    }
                    continue;
                }
                if (seriesIdentifier.trim().contains(":")) {
                    String[] boundIndex = seriesIdentifier.split(":");
                    assert (boundIndex.length == 2);
                    indexMin = fbounds.apply(Integer.valueOf(boundIndex[0].trim()));
                    indexMax = fbounds.apply(Integer.valueOf(boundIndex[1].trim()));
                } else {
                    indexMax = indexMin = fbounds.apply(Integer.valueOf(seriesIdentifier.trim())).intValue();
                }
                if (indexMax >= indexMin) {
                    for (int index = indexMin; index <= indexMax; ++index) {
                        MutablePair current = new MutablePair();
                        idxCp = index;
                        current.setLeft((Object)index);
                        current.setRight(BioFormatsHelper.expressionToArray(channelIdentifier, i -> (Integer)f.apply(idxCp, (Integer)i)));
                        arrayOfArrayOfIndexes.add((Pair<Integer, ArrayList<Integer>>)current);
                    }
                    continue;
                }
                for (int index = indexMax; index >= indexMin; --index) {
                    MutablePair current = new MutablePair();
                    idxCp = index;
                    current.setLeft((Object)index);
                    current.setRight(BioFormatsHelper.expressionToArray(channelIdentifier, i -> (Integer)f.apply(idxCp, (Integer)i)));
                    arrayOfArrayOfIndexes.add((Pair<Integer, ArrayList<Integer>>)current);
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Number format problem with expression:" + str + " - Expression ignored");
            }
        }
        return arrayOfArrayOfIndexes;
    }

    public static ArrayList<Integer> expressionToArray(String expression, Function<Integer, Integer> fbounds) {
        String[] splitIndexes = expression.split(",");
        ArrayList<Integer> arrayOfIndexes = new ArrayList<Integer>();
        for (String str : splitIndexes) {
            if ((str = str.trim()).contains(":")) {
                String[] boundIndex = str.split(":");
                if (boundIndex.length == 2) {
                    try {
                        int index;
                        int b1 = fbounds.apply(Integer.valueOf(boundIndex[0].trim()));
                        int b2 = fbounds.apply(Integer.valueOf(boundIndex[1].trim()));
                        if (b1 < b2) {
                            for (index = b1; index <= b2; ++index) {
                                arrayOfIndexes.add(index);
                            }
                            continue;
                        }
                        for (index = b2; index >= b1; --index) {
                            arrayOfIndexes.add(index);
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Number format problem with expression:" + str + " - Expression ignored");
                        continue;
                    }
                }
                logger.warn("Cannot parse expression " + str + " to pattern 'begin-end' (2-5) for instance, omitted");
                continue;
            }
            try {
                if (str.trim().equals("*")) {
                    int maxIndex = fbounds.apply(-1);
                    for (int index = 0; index <= maxIndex; ++index) {
                        arrayOfIndexes.add(index);
                    }
                    continue;
                }
                int index = fbounds.apply(Integer.valueOf(str.trim()));
                arrayOfIndexes.add(index);
            }
            catch (NumberFormatException e) {
                logger.warn("Number format problem with expression:" + str + " - Expression ignored");
            }
        }
        return arrayOfIndexes;
    }

    public static Unit<Length> getUnitFromString(String unit_string) {
        Field[] bfUnits;
        for (Field f : bfUnits = UNITS.class.getFields()) {
            if (!f.getType().equals(Unit.class) || f.getName() == null) continue;
            try {
                if (!f.getName().equals(unit_string.trim()) && !((Unit)f.get(null)).getSymbol().equals(unit_string.trim())) continue;
                return (Unit)f.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean hasCopyMethod(IFormatReader reader) {
        if (reader instanceof Memoizer) {
            reader = ((Memoizer)reader).getReader();
        }
        if (reader instanceof ChannelSeparator) {
            reader = ((ChannelSeparator)reader).getReader();
        }
        if (reader instanceof ImageReader) {
            ImageReader ir = (ImageReader)reader;
            reader = ir.getReader();
        }
        if (reader instanceof ReaderWrapper) {
            ReaderWrapper rw = (ReaderWrapper)reader;
            reader = rw.getReader();
        }
        Optional<Method> copyMethod = Arrays.stream(reader.getClass().getMethods()).filter(m -> m.getName().equals("copy") && m.getParameterCount() == 0).findFirst();
        return copyMethod.isPresent();
    }

    public static IFormatReader copy(IFormatReader reader) throws UnsupportedOperationException {
        Optional<Method> copyMethod;
        if (reader instanceof Memoizer) {
            reader = ((Memoizer)reader).getReader();
        }
        boolean hasChannelSeparator = false;
        if (reader instanceof ChannelSeparator) {
            reader = ((ChannelSeparator)reader).getReader();
            hasChannelSeparator = true;
        }
        if (reader instanceof ImageReader) {
            ImageReader ir = (ImageReader)reader;
            reader = ir.getReader();
        }
        if (reader instanceof ReaderWrapper) {
            ReaderWrapper rw = (ReaderWrapper)reader;
            reader = rw.getReader();
        }
        if ((copyMethod = Arrays.stream(reader.getClass().getMethods()).filter(m -> m.getName().equals("copy") && m.getParameterCount() == 0).findFirst()).isPresent()) {
            try {
                IFormatReader newReader = (IFormatReader)copyMethod.get().invoke((Object)reader, new Object[0]);
                if (hasChannelSeparator) {
                    return new ChannelSeparator(newReader);
                }
                return newReader;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("The reader " + reader + " has no copy method");
    }

    static {
        try {
            factory = new ServiceFactory();
            service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        }
        catch (DependencyException e) {
            throw new RuntimeException(e);
        }
    }
}

