/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img.bioformats;

import bdv.img.cache.CacheArrayLoader;
import ch.epfl.biop.bdv.img.ResourcePool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import loci.formats.IFormatReader;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;

public class BioFormatsArrayLoaders {

    protected static class BioFormatsUnsignedByteToUnsignedShortArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileShortArray> {
        protected BioFormatsUnsignedByteToUnsignedShortArrayLoader(ResourcePool<IFormatReader> readerPool, int channel, int iSeries) {
            super(readerPool, channel, iSeries);
        }

        public VolatileShortArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.iSeries);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ShortBuffer buffer = ShortBuffer.allocate(nElements);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytesCurrentPlane = reader.openBytes(reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    short[] shortsCurrentPlane = new short[bytesCurrentPlane.length];
                    for (int i = 0; i < bytesCurrentPlane.length; ++i) {
                        shortsCurrentPlane[i] = (short)Byte.toUnsignedInt(bytesCurrentPlane[i]);
                    }
                    buffer.put(shortsCurrentPlane);
                }
                this.readerPool.recycle(reader);
                return new VolatileShortArray(buffer.array(), true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 1;
        }
    }

    public static class BioFormatsIntArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileIntArray> {
        final ByteOrder byteOrder;

        protected BioFormatsIntArrayLoader(ResourcePool<IFormatReader> readerPool, int channel, int iSeries, boolean littleEndian) {
            super(readerPool, channel, iSeries);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileIntArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.iSeries);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 4);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = reader.openBytes(reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.readerPool.recycle(reader);
                int[] ints = new int[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asIntBuffer().get(ints);
                return new VolatileIntArray(ints, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    public static class BioFormatsRGBArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileIntArray> {
        final boolean hasAlphaChannel;

        protected BioFormatsRGBArrayLoader(ResourcePool<IFormatReader> readerPool, int channel, int iSeries, boolean hasAlphaChannel) {
            super(readerPool, channel, iSeries);
            this.hasAlphaChannel = hasAlphaChannel;
        }

        public VolatileIntArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.iSeries);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                if (d != 1) {
                    throw new UnsupportedOperationException("RGB image block of size above 1 unsupported");
                }
                byte[] bytes = reader.openBytes(reader.getIndex(minZ, this.channel, timepoint), minX, minY, w, h);
                boolean interleaved = reader.isInterleaved();
                this.readerPool.recycle(reader);
                int[] ints = new int[nElements];
                int idxPx = 0;
                if (interleaved) {
                    if (this.hasAlphaChannel) {
                        for (int i = 0; i < nElements; ++i) {
                            ints[i] = (255 - bytes[idxPx + 3] & 0xFF) << 24 | (bytes[idxPx] & 0xFF) << 16 | (bytes[idxPx + 1] & 0xFF) << 8 | bytes[idxPx + 2] & 0xFF;
                            idxPx += 4;
                        }
                    } else {
                        for (int i = 0; i < nElements; ++i) {
                            ints[i] = 0xFF000000 | (bytes[idxPx] & 0xFF) << 16 | (bytes[idxPx + 1] & 0xFF) << 8 | bytes[idxPx + 2] & 0xFF;
                            idxPx += 3;
                        }
                    }
                } else {
                    if (this.hasAlphaChannel) {
                        throw new UnsupportedOperationException("Non interleaved ARGB pixels unsupported");
                    }
                    int bOffset = 2 * nElements;
                    for (int i = 0; i < nElements; ++i) {
                        ints[i] = (bytes[idxPx] & 0xFF) << 16 | (bytes[idxPx + nElements] & 0xFF) << 8 | bytes[idxPx + bOffset] & 0xFF;
                        ++idxPx;
                    }
                }
                return new VolatileIntArray(ints, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    public static class BioFormatsFloatArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileFloatArray> {
        final ByteOrder byteOrder;

        protected BioFormatsFloatArrayLoader(ResourcePool<IFormatReader> readerPool, int channel, int iSeries, boolean littleEndian) {
            super(readerPool, channel, iSeries);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileFloatArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.iSeries);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 4);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = reader.openBytes(reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.readerPool.recycle(reader);
                float[] floats = new float[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asFloatBuffer().get(floats);
                return new VolatileFloatArray(floats, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 4;
        }
    }

    public static class BioFormatsShortArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileShortArray> {
        final ByteOrder byteOrder;

        protected BioFormatsShortArrayLoader(ResourcePool<IFormatReader> readerPool, int channel, int iSeries, boolean littleEndian) {
            super(readerPool, channel, iSeries);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileShortArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.iSeries);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 2);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = reader.openBytes(reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.readerPool.recycle(reader);
                short[] shorts = new short[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asShortBuffer().get(shorts);
                return new VolatileShortArray(shorts, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 2;
        }
    }

    public static class BioFormatsUnsignedShortArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileShortArray> {
        final ByteOrder byteOrder;

        protected BioFormatsUnsignedShortArrayLoader(ResourcePool<IFormatReader> readerPool, int channel, int iSeries, boolean littleEndian) {
            super(readerPool, channel, iSeries);
            this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }

        public VolatileShortArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.iSeries);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements * 2);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytes = reader.openBytes(reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    buffer.put(bytes);
                }
                this.readerPool.recycle(reader);
                short[] shorts = new short[nElements];
                buffer.flip();
                buffer.order(this.byteOrder).asShortBuffer().get(shorts);
                return new VolatileShortArray(shorts, true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 2;
        }
    }

    protected static class BioFormatsUnsignedByteArrayLoader
    extends BioformatsArrayLoader
    implements CacheArrayLoader<VolatileByteArray> {
        protected BioFormatsUnsignedByteArrayLoader(ResourcePool<IFormatReader> readerPool, int channel, int iSeries) {
            super(readerPool, channel, iSeries);
        }

        public VolatileByteArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
            try {
                IFormatReader reader = (IFormatReader)this.readerPool.acquire();
                reader.setSeries(this.iSeries);
                reader.setResolution(level);
                int minX = (int)min[0];
                int minY = (int)min[1];
                int minZ = (int)min[2];
                int maxX = Math.min(minX + dimensions[0], reader.getSizeX());
                int maxY = Math.min(minY + dimensions[1], reader.getSizeY());
                int maxZ = Math.min(minZ + dimensions[2], reader.getSizeZ());
                int w = maxX - minX;
                int h = maxY - minY;
                int d = maxZ - minZ;
                int nElements = w * h * d;
                ByteBuffer buffer = ByteBuffer.allocate(nElements);
                for (int z = minZ; z < maxZ; ++z) {
                    byte[] bytesCurrentPlane = reader.openBytes(reader.getIndex(z, this.channel, timepoint), minX, minY, w, h);
                    buffer.put(bytesCurrentPlane);
                }
                this.readerPool.recycle(reader);
                return new VolatileByteArray(buffer.array(), true);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        public int getBytesPerElement() {
            return 1;
        }
    }

    static abstract class BioformatsArrayLoader {
        protected final ResourcePool<IFormatReader> readerPool;
        protected final int channel;
        protected final int iSeries;

        private BioformatsArrayLoader(ResourcePool<IFormatReader> readerPool, int channel, int iSeries) {
            this.readerPool = readerPool;
            this.channel = channel;
            this.iSeries = iSeries;
        }
    }
}

