/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img;

import ch.epfl.biop.bdv.img.FixFilePathsCommand;
import ch.epfl.biop.bdv.img.OpenersImageLoader;
import ch.epfl.biop.bdv.img.Services;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import org.apache.commons.io.FilenameUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.scijava.command.CommandModule;
import org.scijava.util.VersionUtils;

@ImgLoaderIo(format="spimreconstruction.openersimageloader", type=OpenersImageLoader.class)
public class XmlIoOpenersImageLoader
implements XmlIoBasicImgLoader<OpenersImageLoader> {
    public static final String OPENERS_TAG = "openers";
    public static final String VERSION_TAG = "version";

    public Element toXml(OpenersImageLoader imgLoader, File basePath) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", this.getClass().getAnnotation(ImgLoaderIo.class).format());
        String allOpeners = new GsonBuilder().create().toJson((Object)imgLoader.getOpenerSettings().toArray(new OpenerSettings[0]));
        elem.addContent((Content)XmlHelpers.textElement((String)VERSION_TAG, (String)VersionUtils.getVersion(OpenersImageLoader.class)));
        elem.addContent((Content)XmlHelpers.textElement((String)OPENERS_TAG, (String)allOpeners));
        return elem;
    }

    public OpenersImageLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        try {
            String allOpeners = XmlHelpers.getText((Element)elem, (String)OPENERS_TAG);
            List<Object> openerSettingsList = Arrays.asList((Object[])new Gson().fromJson(allOpeners, OpenerSettings[].class));
            this.validateOpeners(openerSettingsList);
            openerSettingsList.forEach(opener -> opener.context(Services.commandService.context()).skipMeta());
            return new OpenersImageLoader(openerSettingsList, sequenceDescription);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void validateOpeners(List<OpenerSettings> openerSettingsList) {
        Map invalidLocations = openerSettingsList.stream().filter(openerSettings -> openerSettings.getType().equals((Object)OpenerSettings.OpenerType.BIOFORMATS) || openerSettings.getType().equals((Object)OpenerSettings.OpenerType.QUPATH)).filter(openerSettings -> !new File(openerSettings.getLocation()).exists()).collect(Collectors.groupingBy(OpenerSettings::getLocation, LinkedHashMap::new, Collectors.toList()));
        if (!invalidLocations.isEmpty()) {
            String[] in = invalidLocations.keySet().toArray(new String[0]);
            String message_in = in.length > 1 ? "<html> Please enter updated file paths for the following files:<br> " : "<html> Please enter updated file paths for the following file:<br> ";
            for (String path : in) {
                message_in = message_in + path + "<br>";
            }
            message_in = message_in + "</html>";
            try {
                FixFilePathsCommand.message_in = message_in;
                File[] out = (File[])((CommandModule)Services.commandService.run(FixFilePathsCommand.class, true, new Object[]{"invalidFilePaths", in}).get()).getOutput("fixedFilePaths");
                if (out.length != in.length) {
                    System.err.println("You did not enter the requested number of files");
                    return;
                }
                for (File file : out) {
                    if (file.exists()) continue;
                    System.err.println("The file " + file.getAbsolutePath() + " does not exists!");
                    return;
                }
                for (int iFile = 0; iFile < in.length; ++iFile) {
                    String extensionOut;
                    File fileIn = new File(in[iFile]);
                    File fileOut = out[iFile];
                    String extensionIn = FilenameUtils.getExtension((String)fileIn.getAbsolutePath());
                    if (extensionIn.equals(extensionOut = FilenameUtils.getExtension((String)fileOut.getAbsolutePath()))) continue;
                    System.err.println("You replaced the file " + fileIn.getAbsolutePath() + " by the file " + fileOut.getAbsolutePath() + " but\n + they do not have the same extension (" + extensionIn + " vs" + extensionOut + ")");
                    return;
                }
                HashMap<String, String> oldToNew = new HashMap<String, String>();
                for (int i = 0; i < in.length; ++i) {
                    oldToNew.put(in[i], out[i].getAbsolutePath());
                }
                invalidLocations.values().forEach(openerSettingsL -> openerSettingsL.forEach(openerSettings -> openerSettings.location((String)oldToNew.get(openerSettings.getLocation()))));
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

