/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public abstract class ResourcePool<Resource> {
    private final BlockingQueue<Resource> pool;
    private final ReentrantLock lock = new ReentrantLock();
    private int createdObjects = 0;
    private final int size;
    volatile boolean isClosed = false;

    protected ResourcePool(int size, Boolean dynamicCreation) {
        this.pool = new ArrayBlockingQueue<Resource>(size, true);
        this.size = size;
        if (!dynamicCreation.booleanValue()) {
            this.lock.lock();
        }
    }

    public Resource takeOrCreate() throws Exception {
        if (this.isClosed) {
            throw new IllegalStateException("The pool has been closed");
        }
        if (this.createdObjects > 0) {
            return this.pool.take();
        }
        if (!this.lock.isLocked() && this.lock.tryLock()) {
            try {
                ++this.createdObjects;
                Resource Resource = this.createObject();
                return Resource;
            }
            finally {
                if (this.createdObjects < this.size) {
                    this.lock.unlock();
                }
            }
        }
        return this.pool.take();
    }

    public Resource acquire() throws Exception {
        if (this.isClosed) {
            throw new IllegalStateException("The pool has been closed");
        }
        if (!this.lock.isLocked() && this.lock.tryLock()) {
            try {
                ++this.createdObjects;
                Resource Resource = this.createObject();
                return Resource;
            }
            finally {
                if (this.createdObjects < this.size) {
                    this.lock.unlock();
                }
            }
        }
        return this.pool.take();
    }

    public void recycle(Resource resource) throws Exception {
        this.pool.add(resource);
    }

    public void createPool() {
        if (this.isClosed) {
            throw new IllegalStateException("The pool has been closed");
        }
        if (this.lock.isLocked()) {
            for (int i = 0; i < this.size; ++i) {
                this.pool.add(this.createObject());
                ++this.createdObjects;
            }
        }
    }

    protected abstract Resource createObject();

    public synchronized void shutDown(Consumer<Resource> closer) {
        if (!this.isClosed) {
            this.isClosed = true;
            ArrayList<Resource> resources = new ArrayList<Resource>(this.size);
            this.pool.drainTo(resources);
            resources.forEach(closer);
        }
    }
}

